/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataSet;
import de.markusbordihn.easynpc.data.objective.ObjectiveType;
import de.markusbordihn.easynpc.data.server.ServerDataAccessor;
import de.markusbordihn.easynpc.data.server.ServerDataIndex;
import de.markusbordihn.easynpc.data.server.ServerEntityData;
import de.markusbordihn.easynpc.data.ticker.TickerType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.ResetUniversalAngerTargetGoal;
import de.markusbordihn.easynpc.entity.easynpc.data.AttributeData;
import de.markusbordihn.easynpc.entity.easynpc.data.TickerData;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_3222;

public interface ObjectiveData<T extends class_1314>
extends EasyNPC<T> {
    public static final class_2941<ObjectiveDataSet> OBJECTIVE_DATA_SET = new class_2941<ObjectiveDataSet>(){

        public void write(class_2540 buffer, ObjectiveDataSet value) {
            buffer.method_10794(value.createTag());
        }

        public ObjectiveDataSet read(class_2540 buffer) {
            return new ObjectiveDataSet(buffer.method_10798());
        }

        public ObjectiveDataSet copy(ObjectiveDataSet value) {
            return value;
        }
    };
    public static final class_2941<HashSet<UUID>> TARGETED_ENTITY_HASH_SET = new class_2941<HashSet<UUID>>(){

        public void write(class_2540 buffer, HashSet<UUID> value) {
            for (UUID entry : value) {
                buffer.method_10797(entry);
            }
        }

        public HashSet<UUID> read(class_2540 buffer) {
            HashSet<UUID> value = new HashSet<UUID>();
            while (buffer.isReadable()) {
                value.add(buffer.method_10790());
            }
            return value;
        }

        public HashSet<UUID> copy(HashSet<UUID> value) {
            return value;
        }
    };
    public static final class_2941<HashSet<String>> TARGETED_PLAYER_HASH_SET = new class_2941<HashSet<String>>(){

        public void write(class_2540 buffer, HashSet<String> value) {
            for (String entry : value) {
                buffer.method_10814(entry);
            }
        }

        public HashSet<String> read(class_2540 buffer) {
            HashSet<String> value = new HashSet<String>();
            while (buffer.isReadable()) {
                value.add(buffer.method_19772());
            }
            return value;
        }

        public HashSet<String> copy(HashSet<String> value) {
            return value;
        }
    };
    public static final ServerDataAccessor<ObjectiveDataSet> CUSTOM_DATA_OBJECTIVE_DATA_SET = ServerEntityData.defineId(ServerDataIndex.OBJECTIVE_DATA_SET, OBJECTIVE_DATA_SET);
    public static final ServerDataAccessor<HashSet<UUID>> CUSTOM_DATA_TARGETED_ENTITY_SET = ServerEntityData.defineId(ServerDataIndex.OBJECTIVE_ENTITY_SET, TARGETED_ENTITY_HASH_SET);
    public static final ServerDataAccessor<HashSet<String>> CUSTOM_DATA_TARGETED_PLAYER_SET = ServerEntityData.defineId(ServerDataIndex.OBJECTIVE_PLAYER_SET, TARGETED_PLAYER_HASH_SET);
    public static final int CUSTOM_OBJECTIVE_DELAYED_REGISTRATION_TICK = 300;
    public static final String DATA_HAS_ENTITY_TARGET_TAG = "HasEntityTarget";
    public static final String DATA_HAS_OBJECTIVE_TAG = "HasObjectives";
    public static final String DATA_HAS_PLAYER_TARGET_TAG = "HasPlayerTarget";
    public static final String DATA_HAS_TRAVEL_TARGET_TAG = "HasTravelTarget";
    public static final String DATA_OBJECTIVE_DATA_TAG = "ObjectiveData";

    public static void registerObjectiveDataSerializer() {
        class_2943.method_12720(OBJECTIVE_DATA_SET);
        class_2943.method_12720(TARGETED_PLAYER_HASH_SET);
        class_2943.method_12720(TARGETED_ENTITY_HASH_SET);
    }

    default public ObjectiveDataSet getObjectiveDataSet() {
        return this.getEasyNPCServerData().getServerEntityData(CUSTOM_DATA_OBJECTIVE_DATA_SET);
    }

    default public void setObjectiveDataSet(ObjectiveDataSet objectiveDataSet) {
        this.getEasyNPCServerData().setServerEntityData(CUSTOM_DATA_OBJECTIVE_DATA_SET, objectiveDataSet);
    }

    default public boolean hasObjective(String objectiveId) {
        return this.getObjectiveDataSet() != null && this.getObjectiveDataSet().hasObjective(objectiveId);
    }

    default public boolean hasObjective(ObjectiveType objectiveType) {
        return this.getObjectiveDataSet() != null && this.getObjectiveDataSet().hasObjective(objectiveType);
    }

    default public boolean hasObjective(ObjectiveDataEntry objectiveDataEntry) {
        return this.getObjectiveDataSet() != null && this.getObjectiveDataSet().hasObjective(objectiveDataEntry.getId());
    }

    default public boolean hasObjectives() {
        return this.getObjectiveDataSet() != null && this.getObjectiveDataSet().hasObjectives();
    }

    default public ObjectiveDataEntry getObjective(ObjectiveType objectiveType) {
        return this.getObjectiveDataSet() != null ? this.getObjectiveDataSet().getObjective(objectiveType) : null;
    }

    default public void removeObjective(ObjectiveType objectiveType) {
        if (objectiveType == null) {
            return;
        }
        this.getObjectiveDataSet().removeObjective(objectiveType);
    }

    default public void addObjective(ObjectiveDataEntry objectiveDataEntry) {
        if (objectiveDataEntry == null) {
            return;
        }
        this.getObjectiveDataSet().addObjective(objectiveDataEntry);
    }

    default public boolean hasTravelTargetObjectives() {
        return this.getObjectiveDataSet() != null && this.getObjectiveDataSet().hasTravelTarget();
    }

    default public boolean hasPlayerTargetObjectives() {
        return this.getObjectiveDataSet() != null && this.getObjectiveDataSet().hasPlayerTarget();
    }

    default public boolean hasEntityTargetObjectives() {
        return this.getObjectiveDataSet() != null && this.getObjectiveDataSet().hasEntityTarget();
    }

    default public boolean hasOwnerTargetObjectives() {
        return this.getObjectiveDataSet() != null && this.getObjectiveDataSet().hasOwnerTarget();
    }

    default public void onEasyNPCJoinUpdateObjective(EasyNPC<?> easyNPC) {
        if (this.hasEntityTargetObjectives() && !this.getObjectiveDataSet().hasValidTarget(this) && this.getObjectiveDataSet().isTargetedEntity(easyNPC.getUUID())) {
            this.refreshCustomObjectives();
        }
    }

    default public void onEasyNPCLeaveUpdateObjective(EasyNPC<?> easyNPC) {
        if (this.hasEntityTargetObjectives() && this.getObjectiveDataSet().hasValidTarget(this) && this.getObjectiveDataSet().isTargetedEntity(this.getUUID())) {
            this.refreshCustomObjectives();
        }
    }

    default public void onPlayerJoinUpdateObjective(class_3222 serverPlayer) {
        if (this.hasOwnerTargetObjectives() && !this.getObjectiveDataSet().hasValidTarget(this) && (this.isObjectiveOwner(serverPlayer) || this.isObjectiveTargetedPlayer(serverPlayer))) {
            this.refreshCustomObjectives();
        }
    }

    private boolean isObjectiveOwner(class_3222 serverPlayer) {
        return this.getEasyNPCOwnerData() != null && this.getEasyNPCOwnerData().isOwner(serverPlayer);
    }

    private boolean isObjectiveTargetedPlayer(class_3222 serverPlayer) {
        return this.getObjectiveDataSet().isTargetedPlayer(serverPlayer.method_5477().getString());
    }

    default public void onPlayerLeaveUpdateObjective(class_3222 serverPlayer) {
        if (this.hasOwnerTargetObjectives() && this.getObjectiveDataSet().hasValidTarget(this) && (this.isObjectiveOwner(serverPlayer) || this.isObjectiveTargetedPlayer(serverPlayer))) {
            this.refreshCustomObjectives();
        }
    }

    default public void onLivingEntityJoinUpdateObjective(class_1309 livingEntity) {
        if (this.hasEntityTargetObjectives() && !this.getObjectiveDataSet().hasValidTarget(this) && this.getObjectiveDataSet().isTargetedEntity(livingEntity.method_5667())) {
            this.refreshCustomObjectives();
        }
    }

    default public void onLivingEntityLeaveUpdateObjective(class_1309 livingEntity) {
        if (this.hasObjectives() && this.getObjectiveDataSet().hasValidTarget(this) && this.getObjectiveDataSet().isTargetedEntity(livingEntity.method_5667())) {
            this.refreshCustomObjectives();
        }
    }

    default public void refreshCustomObjectives() {
        if (this.method_38069()) {
            return;
        }
        for (ObjectiveDataEntry objectiveDataEntry : this.getObjectiveDataSet().getObjectives()) {
            if (objectiveDataEntry == null || objectiveDataEntry.getType() == ObjectiveType.NONE || objectiveDataEntry.hasValidTarget(this) && objectiveDataEntry.isRegistered()) continue;
            log.debug("Refresh Objective {} for {}", (Object)objectiveDataEntry, (Object)this);
            this.addOrUpdateCustomObjective(objectiveDataEntry);
        }
    }

    default public void registerAttributeBasedObjectives() {
        if (this.method_38069()) {
            return;
        }
        log.info("Register attribute based objectives for {}", (Object)this);
        ObjectiveDataEntry floatObjective = new ObjectiveDataEntry(ObjectiveType.FLOAT, 0);
        AttributeData attributeData = this.getEasyNPCAttributeData();
        if (attributeData.getAttributeCanFloat()) {
            if (!this.hasObjective(floatObjective)) {
                this.addOrUpdateCustomObjective(floatObjective);
            }
        } else if (this.hasObjective(floatObjective)) {
            this.removeCustomObjective(floatObjective);
        }
        ObjectiveDataEntry closeDoorObjective = new ObjectiveDataEntry(ObjectiveType.CLOSE_DOOR, 8);
        if (attributeData.getAttributeCanCloseDoor()) {
            if (!this.hasObjective(closeDoorObjective)) {
                this.addOrUpdateCustomObjective(closeDoorObjective);
            }
        } else if (this.hasObjective(closeDoorObjective)) {
            this.removeCustomObjective(closeDoorObjective);
        }
        ObjectiveDataEntry openDoorObjective = new ObjectiveDataEntry(ObjectiveType.OPEN_DOOR, 8);
        if (attributeData.getAttributeCanOpenDoor()) {
            if (!this.hasObjective(closeDoorObjective)) {
                this.addOrUpdateCustomObjective(openDoorObjective);
            }
        } else if (this.hasObjective(openDoorObjective)) {
            this.removeCustomObjective(openDoorObjective);
        }
    }

    default public void registerCustomObjectives() {
        if (this.method_38069()) {
            return;
        }
        Set<ObjectiveDataEntry> objectives = this.getObjectiveDataSet().getObjectives();
        if (objectives == null || objectives.isEmpty()) {
            return;
        }
        log.debug("Register custom objectives for {}", (Object)this);
        class_1355 targetSelector = this.getEntityTargetSelector();
        for (ObjectiveDataEntry objectiveDataEntry : objectives) {
            this.addOrUpdateCustomObjective(objectiveDataEntry);
        }
        if (!targetSelector.method_35115().isEmpty()) {
            log.debug("- Register reset universal anger target for {}", (Object)this);
            targetSelector.method_6277(4, new ResetUniversalAngerTargetGoal<ObjectiveData>(this, false));
        }
    }

    default public boolean addOrUpdateCustomObjective(ObjectiveDataEntry objectiveDataEntry) {
        class_1352 target;
        if (objectiveDataEntry == null || objectiveDataEntry.getType() == ObjectiveType.NONE) {
            log.error("- Unable to add custom objective {} for {}!", (Object)objectiveDataEntry, (Object)this);
            return false;
        }
        boolean addedCustomObjective = false;
        class_1352 goal = objectiveDataEntry.getGoal(this);
        if (goal != null) {
            class_1355 goalSelector = this.getEntityGoalSelector();
            if (!objectiveDataEntry.hasValidTarget(this)) {
                if (this.hasObjective(objectiveDataEntry.getId()) && objectiveDataEntry.isRegistered()) {
                    log.warn("- Removing existing goal {} for {} because target was not found! Will try later again.", (Object)goal, (Object)this);
                }
                goalSelector.method_6280(goal);
            } else {
                log.debug("- Adding goal {} for {}", (Object)goal, (Object)this);
                goalSelector.method_6280(goal);
                goalSelector.method_6277(objectiveDataEntry.getPriority(), goal);
                addedCustomObjective = true;
            }
        }
        if ((target = objectiveDataEntry.getTarget(this)) != null) {
            log.debug("- Adding target goal {} for {}", (Object)target, (Object)this);
            class_1355 targetSelector = this.getEntityTargetSelector();
            targetSelector.method_6280(target);
            targetSelector.method_6277(objectiveDataEntry.getPriority(), target);
            addedCustomObjective = true;
        }
        objectiveDataEntry.setRegistered(addedCustomObjective);
        this.getObjectiveDataSet().addObjective(objectiveDataEntry);
        return objectiveDataEntry.isRegistered();
    }

    default public void handleCustomObjectiveBaseTick() {
        TickerData tickerData = this.getEasyNPCTickerData();
        if (tickerData.checkAndIncreaseTicker(TickerType.CUSTOM_OBJECTIVE_DELAYED_REGISTRATION, 300)) {
            if (this.hasObjectives()) {
                this.refreshCustomObjectives();
            }
            tickerData.resetTicker(TickerType.CUSTOM_OBJECTIVE_DELAYED_REGISTRATION);
        }
    }

    default public boolean removeCustomObjective(ObjectiveDataEntry objectiveDataEntry) {
        if (objectiveDataEntry == null || objectiveDataEntry.getType() == ObjectiveType.NONE) {
            log.error("- Unable to remove custom objective {} for {}!", (Object)objectiveDataEntry, (Object)this);
            return false;
        }
        if (objectiveDataEntry.getId() != null && !objectiveDataEntry.getId().isEmpty() && (objectiveDataEntry = this.getObjectiveDataSet().getObjective(objectiveDataEntry.getId())) == null) {
            log.error("- Unable to remove non-existing custom objective {} for {}!", (Object)objectiveDataEntry, (Object)this);
            return false;
        }
        class_1352 goal = objectiveDataEntry.getGoal(this);
        class_1352 target = objectiveDataEntry.getTarget(this);
        if (goal == null && target == null) {
            log.error("- Unable to remove custom objective for {}!", (Object)this);
            return false;
        }
        if (goal != null) {
            log.debug("- Removing goal {} for {}", (Object)goal, (Object)this);
            this.getEntityGoalSelector().method_6280(goal);
        }
        if (target != null) {
            log.debug("- Removing target goal {} for {}", (Object)target, (Object)this);
            this.getEntityTargetSelector().method_6280(target);
        }
        return this.getObjectiveDataSet().removeObjective(objectiveDataEntry);
    }

    default public void registerStandardObjectives() {
        log.debug("Register standard objectives for {}", (Object)this);
        this.addOrUpdateCustomObjective(new ObjectiveDataEntry(ObjectiveType.LOOK_AT_RESET, 9));
        this.addOrUpdateCustomObjective(new ObjectiveDataEntry(ObjectiveType.LOOK_AT_PLAYER, 9));
        this.addOrUpdateCustomObjective(new ObjectiveDataEntry(ObjectiveType.LOOK_AT_MOB, 10));
    }

    default public void defineCustomObjectiveData() {
        this.getEasyNPCServerData().defineServerEntityData(CUSTOM_DATA_OBJECTIVE_DATA_SET, new ObjectiveDataSet());
        this.getEasyNPCServerData().defineServerEntityData(CUSTOM_DATA_TARGETED_PLAYER_SET, new HashSet());
        this.getEasyNPCServerData().defineServerEntityData(CUSTOM_DATA_TARGETED_ENTITY_SET, new HashSet());
    }

    default public void addAdditionalObjectiveData(class_2487 compoundTag) {
        class_2487 objectiveTag = new class_2487();
        if (this.isServerSide()) {
            ObjectiveDataSet objectiveDataSet = this.getObjectiveDataSet();
            if (objectiveDataSet != null) {
                objectiveDataSet.save(objectiveTag);
            }
            objectiveTag.method_10556(DATA_HAS_OBJECTIVE_TAG, this.hasObjectives());
            if (this.hasTravelTargetObjectives()) {
                objectiveTag.method_10556(DATA_HAS_TRAVEL_TARGET_TAG, this.hasTravelTargetObjectives());
            }
            if (this.hasPlayerTargetObjectives()) {
                objectiveTag.method_10556(DATA_HAS_PLAYER_TARGET_TAG, this.hasPlayerTargetObjectives());
            }
            if (this.hasEntityTargetObjectives()) {
                objectiveTag.method_10556(DATA_HAS_ENTITY_TARGET_TAG, this.hasEntityTargetObjectives());
            }
        }
        compoundTag.method_10566(DATA_OBJECTIVE_DATA_TAG, (class_2520)objectiveTag);
    }

    default public void readAdditionalObjectiveData(class_2487 compoundTag) {
        if (!compoundTag.method_10545(DATA_OBJECTIVE_DATA_TAG)) {
            return;
        }
        class_2487 objectiveDataTag = compoundTag.method_10562(DATA_OBJECTIVE_DATA_TAG);
        if (objectiveDataTag.method_10545("ObjectiveDataSet")) {
            ObjectiveDataSet objectiveDataSet = new ObjectiveDataSet(objectiveDataTag);
            this.setObjectiveDataSet(objectiveDataSet);
            this.registerCustomObjectives();
        }
        if (this.getNPCDataVersion() == -1) {
            this.registerStandardObjectives();
        }
    }
}

