/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.data.trading.TradingDataSet;
import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SoundData;
import java.util.EnumMap;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_1916;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public interface TradingData<E extends class_1314>
extends EasyNPC<E>,
class_1915 {
    public static final String DATA_TRADING_INVENTORY_TAG = "Inventory";
    public static final String DATA_TRADING_OFFERS_TAG = "Offers";
    public static final String DATA_TRADING_RECIPES_TAG = "Recipes";
    public static final String DATA_TRADING_DATA_TAG = "TradingData";
    public static final class_2941<class_1916> MERCHANT_OFFERS = new class_2941<class_1916>(){

        public void write(class_2540 buffer, class_1916 value) {
            buffer.method_10794(value.method_8268());
        }

        public class_1916 read(class_2540 buffer) {
            class_2487 compoundTag = buffer.method_10798();
            return compoundTag != null ? new class_1916(compoundTag) : new class_1916();
        }

        public class_1916 copy(class_1916 value) {
            return value;
        }
    };
    public static final class_2941<TradingDataSet> TRADING_DATA_SET = new class_2941<TradingDataSet>(){

        public void write(class_2540 buffer, TradingDataSet value) {
            buffer.method_10794(value.createTag());
        }

        public TradingDataSet read(class_2540 buffer) {
            return new TradingDataSet(buffer.method_10798());
        }

        public TradingDataSet copy(TradingDataSet value) {
            return value;
        }
    };

    public static void registerSyncedTradingData(EnumMap<SynchedDataIndex, class_2940<?>> map, Class<? extends class_1297> entityClass) {
        log.info("- Registering Synched Trading Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.TRADING_DATA_SET, class_2945.method_12791(entityClass, TRADING_DATA_SET));
        map.put(SynchedDataIndex.TRADING_INVENTORY, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13318));
        map.put(SynchedDataIndex.TRADING_MERCHANT_OFFERS, class_2945.method_12791(entityClass, MERCHANT_OFFERS));
    }

    public static void registerTradingDataSerializer() {
        class_2943.method_12720(TRADING_DATA_SET);
        class_2943.method_12720(MERCHANT_OFFERS);
    }

    public class_1657 method_8257();

    public void method_8259(class_1657 var1);

    public class_1916 getMerchantTradingOffers();

    public void setMerchantTradingOffers(class_1916 var1);

    default public class_1916 method_8264() {
        if (this.getMerchantTradingOffers() == null) {
            this.updateMerchantTradingOffers();
        }
        return this.getMerchantTradingOffers();
    }

    default public void updateMerchantTradingOffers() {
        class_1916 merchantOffers = new class_1916();
        TradingDataSet tradingDataSet = this.getTradingDataSet();
        if (tradingDataSet.isType(TradingType.BASIC) || tradingDataSet.isType(TradingType.ADVANCED)) {
            merchantOffers = new class_1916(this.getTradingOffers().method_8268());
        }
        if (!merchantOffers.isEmpty()) {
            merchantOffers.removeIf(merchantOffer -> merchantOffer.method_8246().method_7960() && merchantOffer.method_8247().method_7960() || merchantOffer.method_8250().method_7960());
        }
        this.setMerchantTradingOffers(merchantOffers);
    }

    default public void method_8261(class_1916 merchantOffers) {
    }

    default public int method_19269() {
        return 0;
    }

    default public void method_19271(int experience) {
    }

    default public boolean method_19270() {
        return true;
    }

    default public class_3414 method_18010() {
        return class_3417.field_14815;
    }

    @Override
    default public boolean method_38069() {
        return this.getLevel() != null && this.getLevel().method_8608();
    }

    default public void setAdvancedTradingOffers(class_1263 container) {
        class_1916 merchantOffers = new class_1916();
        int merchantOfferIndex = 0;
        for (int tradingOffer = 0; tradingOffer < 25; ++tradingOffer) {
            class_1914 existingMerchantOffer;
            class_1799 itemResult;
            class_1799 itemB;
            class_1799 itemA = container.method_5438(tradingOffer * 3);
            if (!this.isValidTradingOffer(itemA, itemB = container.method_5438(tradingOffer * 3 + 1), itemResult = container.method_5438(tradingOffer * 3 + 2))) continue;
            class_1916 existingMerchantOffers = this.getTradingOffers();
            class_1914 class_19142 = existingMerchantOffer = existingMerchantOffers != null && existingMerchantOffers.size() > tradingOffer ? (class_1914)existingMerchantOffers.get(tradingOffer) : null;
            if (existingMerchantOffer != null) {
                merchantOffers.add(merchantOfferIndex++, (Object)new class_1914(itemA, itemB, itemResult, existingMerchantOffer.method_8249(), existingMerchantOffer.method_8248(), existingMerchantOffer.method_19279(), existingMerchantOffer.method_19278(), existingMerchantOffer.method_21725()));
                continue;
            }
            merchantOffers.add(merchantOfferIndex++, (Object)new class_1914(itemA, itemB, itemResult, 64, 1, 1.0f));
        }
        if (!merchantOffers.isEmpty()) {
            this.getTradingDataSet().setType(TradingType.ADVANCED);
            this.setTradingOffers(merchantOffers);
        }
    }

    default public void setBasicTradingOffers(class_1263 container) {
        class_1916 merchantOffers = new class_1916();
        for (int tradingOffer = 0; tradingOffer < 12; ++tradingOffer) {
            class_1799 itemResult;
            class_1799 itemB;
            class_1799 itemA = container.method_5438(tradingOffer * 3);
            if (!this.isValidTradingOffer(itemA, itemB = container.method_5438(tradingOffer * 3 + 1), itemResult = container.method_5438(tradingOffer * 3 + 2))) continue;
            class_1914 merchantOffer = new class_1914(itemA, itemB, itemResult, this.getTradingDataSet().getMaxUses(), this.getTradingDataSet().getRewardedXP(), 1.0f);
            merchantOffers.add((Object)merchantOffer);
        }
        if (!merchantOffers.isEmpty()) {
            this.getTradingDataSet().setType(TradingType.BASIC);
            this.setTradingOffers(merchantOffers);
        }
    }

    default public void updateBasicTradingOffers() {
        if (this.getTradingDataSet().isType(TradingType.BASIC)) {
            return;
        }
        class_1916 merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty()) {
            return;
        }
        class_1916 newMerchantOffers = new class_1916();
        for (class_1914 merchantOffer : merchantOffers) {
            if (!this.isValidTradingOffer(merchantOffer.method_8246(), merchantOffer.method_8247(), merchantOffer.method_8250())) continue;
            class_1914 newMerchantOffer = new class_1914(merchantOffer.method_8246(), merchantOffer.method_8247(), merchantOffer.method_8250(), this.getTradingDataSet().getMaxUses(), this.getTradingDataSet().getRewardedXP(), merchantOffer.method_19278());
            newMerchantOffers.add((Object)newMerchantOffer);
        }
        this.setTradingOffers(newMerchantOffers);
    }

    default public void resetTradingOffers() {
        class_1916 merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty()) {
            return;
        }
        log.debug("Reset trading offers {} for {}", (Object)merchantOffers, (Object)this);
        for (class_1914 merchantOffer : merchantOffers) {
            merchantOffer.method_19275();
        }
        this.setTradingOffers(merchantOffers);
        this.getTradingDataSet().setLastReset(System.currentTimeMillis());
    }

    default public class_1916 getTradingOffers() {
        return (class_1916)this.getSynchedEntityData(SynchedDataIndex.TRADING_MERCHANT_OFFERS);
    }

    default public void setTradingOffers(class_1916 merchantOffers) {
        this.setSynchedEntityData(SynchedDataIndex.TRADING_MERCHANT_OFFERS, new class_1916());
        this.setSynchedEntityData(SynchedDataIndex.TRADING_MERCHANT_OFFERS, merchantOffers);
        this.updateMerchantTradingOffers();
    }

    default public class_2487 getTradingInventory() {
        return (class_2487)this.getSynchedEntityData(SynchedDataIndex.TRADING_INVENTORY);
    }

    default public void setTradingInventory(class_2487 tradingInventory) {
        this.setSynchedEntityData(SynchedDataIndex.TRADING_INVENTORY, tradingInventory);
    }

    default public void method_8262(class_1914 merchantOffer) {
        merchantOffer.method_8244();
        this.getMob().field_6191 = -this.getMob().method_5970();
        this.rewardTradeXp(merchantOffer);
        class_1657 class_16572 = this.method_8257();
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            log.debug("Trade {} with {} for {}", (Object)merchantOffer, (Object)serverPlayer, (Object)this);
        }
    }

    default public void method_8258(class_1799 itemStack) {
        if (!this.method_38069() && this.getMob().field_6191 > -this.getMob().method_5970() + 20) {
            this.getMob().field_6191 = -this.getMob().method_5970();
            SoundData soundData = this.getEasyNPCSoundData();
            soundData.playDefaultTradeUpdatedSound(!itemStack.method_7960());
        }
    }

    default public void rewardTradeXp(class_1914 merchantOffer) {
        if (merchantOffer.method_8256() && merchantOffer.method_19279() > 0) {
            class_1309 livingEntity = this.getLivingEntity();
            int tradeExperience = 3 + livingEntity.method_6051().method_43048(merchantOffer.method_19279());
            livingEntity.method_37908().method_8649((class_1297)new class_1303(livingEntity.method_37908(), livingEntity.method_23317(), livingEntity.method_23318() + 0.5, livingEntity.method_23321(), tradeExperience));
        }
    }

    default public boolean hasTradingData() {
        TradingType tradingType = this.getTradingDataSet().getType();
        return (tradingType == TradingType.BASIC || tradingType == TradingType.ADVANCED) && this.getTradingOffers() != null && !this.getTradingOffers().isEmpty() || tradingType == TradingType.CUSTOM;
    }

    default public void stopTrading() {
        class_1915 merchant = this.getMerchant();
        if (merchant != null) {
            merchant.method_8259(null);
        }
    }

    default public void setAdvancedTradingMaxUses(int tradingOfferIndex, int maxUses) {
        class_1916 merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        class_1914 merchantOffer = (class_1914)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new class_1914(merchantOffer.method_8246(), merchantOffer.method_8247(), merchantOffer.method_8250(), 0, maxUses, merchantOffer.method_19279(), merchantOffer.method_19278(), merchantOffer.method_21725()));
        this.setTradingOffers(merchantOffers);
    }

    default public void setAdvancedTradingXp(int tradingOfferIndex, int xp) {
        class_1916 merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        class_1914 merchantOffer = (class_1914)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new class_1914(merchantOffer.method_8246(), merchantOffer.method_8247(), merchantOffer.method_8250(), merchantOffer.method_8249(), merchantOffer.method_8248(), xp, merchantOffer.method_19278(), merchantOffer.method_21725()));
        this.setTradingOffers(merchantOffers);
    }

    default public void setAdvancedTradingPriceMultiplier(int tradingOfferIndex, float priceMultiplier) {
        class_1916 merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        class_1914 merchantOffer = (class_1914)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new class_1914(merchantOffer.method_8246(), merchantOffer.method_8247(), merchantOffer.method_8250(), merchantOffer.method_8249(), merchantOffer.method_8248(), merchantOffer.method_19279(), priceMultiplier, merchantOffer.method_21725()));
        this.setTradingOffers(merchantOffers);
    }

    default public void setAdvancedTradingDemand(int tradingOfferIndex, int demand) {
        class_1916 merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        class_1914 merchantOffer = (class_1914)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new class_1914(merchantOffer.method_8246(), merchantOffer.method_8247(), merchantOffer.method_8250(), merchantOffer.method_8249(), merchantOffer.method_8248(), merchantOffer.method_19279(), merchantOffer.method_19278(), demand));
        this.setTradingOffers(merchantOffers);
    }

    default public TradingDataSet getTradingDataSet() {
        return (TradingDataSet)this.getSynchedEntityData(SynchedDataIndex.TRADING_DATA_SET);
    }

    default public void setTradingDataSet(TradingDataSet tradingDataSet) {
        this.setSynchedEntityData(SynchedDataIndex.TRADING_DATA_SET, tradingDataSet);
    }

    default public boolean isValidTradingOffer(class_1799 itemA, class_1799 itemB, class_1799 itemResult) {
        if (itemResult == null || itemA == null && itemB == null) {
            return false;
        }
        return (itemA != null && !itemA.method_7960() || itemB != null && !itemB.method_7960()) && !itemResult.method_7960();
    }

    default public class_1269 openTradingScreen(class_3222 serverPlayer) {
        if (this.method_38069()) {
            return class_1269.field_5812;
        }
        class_1915 merchant = this.getMerchant();
        if (merchant == null) {
            log.error("No merchant found for {} with {} from {}", (Object)this, (Object)this.getTradingOffers(), (Object)serverPlayer);
            return class_1269.field_5814;
        }
        class_1916 merchantOffers = merchant.method_8264();
        if (merchantOffers.isEmpty()) {
            log.error("No trading offers found for {} with {} from {}", (Object)this, (Object)merchantOffers, (Object)serverPlayer);
            return class_1269.field_5814;
        }
        if (merchant.method_8257() != null && merchant.method_8257() != serverPlayer) {
            log.warn("Unable to open trading screen for {} with {} from {}, {} is still trading.", (Object)this, (Object)merchantOffers, (Object)serverPlayer, (Object)merchant.method_8257());
            serverPlayer.method_43496((class_2561)class_2561.method_43469((String)"text.easy_npc.trading.busy", (Object[])new Object[]{merchant.method_8257()}));
            return class_1269.field_5814;
        }
        if (this.getTradingDataSet().getResetsEveryMin() > 0) {
            long currentTime = System.currentTimeMillis();
            long resetTimeInMillis = (long)this.getTradingDataSet().getResetsEveryMin() * 60L * 1000L;
            if (currentTime - this.getTradingDataSet().getLastReset() > resetTimeInMillis) {
                this.resetTradingOffers();
            }
        }
        log.debug("Open trading screen for {} with {} from {}", (Object)this, (Object)merchantOffers, (Object)serverPlayer);
        merchant.method_8259((class_1657)serverPlayer);
        merchant.method_17449((class_1657)serverPlayer, (class_2561)(this.getEntity().method_5797() != null ? this.getEntity().method_5797() : class_2561.method_43471((String)"text.easy_npc.trading")), 140);
        return class_1269.field_21466;
    }

    default public void defineSynchedTradingData() {
        this.defineSynchedEntityData(SynchedDataIndex.TRADING_DATA_SET, new TradingDataSet());
        this.defineSynchedEntityData(SynchedDataIndex.TRADING_INVENTORY, new class_2487());
        this.defineSynchedEntityData(SynchedDataIndex.TRADING_MERCHANT_OFFERS, new class_1916());
    }

    default public void addAdditionalTradingData(class_2487 compoundTag) {
        class_2487 tradingDataTag = new class_2487();
        TradingDataSet tradingDataSet = this.getTradingDataSet();
        if (tradingDataSet != null) {
            tradingDataSet.save(tradingDataTag);
        }
        compoundTag.method_10566(DATA_TRADING_DATA_TAG, (class_2520)tradingDataTag);
        class_2487 tradingOffersTag = new class_2487();
        tradingOffersTag.method_10566(DATA_TRADING_INVENTORY_TAG, (class_2520)this.getTradingInventory());
        tradingOffersTag.method_10566(DATA_TRADING_RECIPES_TAG, (class_2520)this.getTradingOffers().method_8268());
        compoundTag.method_10566(DATA_TRADING_OFFERS_TAG, (class_2520)tradingOffersTag);
    }

    default public void readAdditionalTradingData(class_2487 compoundTag) {
        class_2487 tradingOffersTag;
        class_2487 tradingDataTag = compoundTag.method_10562(DATA_TRADING_DATA_TAG);
        if (tradingDataTag.method_10545("TradingDataSet")) {
            TradingDataSet tradingDataSet = new TradingDataSet(tradingDataTag);
            this.setTradingDataSet(tradingDataSet);
        }
        if ((tradingOffersTag = compoundTag.method_10562(DATA_TRADING_OFFERS_TAG)).method_10545(DATA_TRADING_RECIPES_TAG)) {
            class_1916 merchantOffers = new class_1916(tradingOffersTag.method_10562(DATA_TRADING_RECIPES_TAG));
            if (!merchantOffers.isEmpty()) {
                this.setTradingOffers(merchantOffers);
            }
            return;
        }
        if (tradingOffersTag.method_10545(DATA_TRADING_INVENTORY_TAG)) {
            this.setTradingInventory(tradingOffersTag.method_10562(DATA_TRADING_INVENTORY_TAG));
        }
    }
}

