/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.EnumMap;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;

public interface VariantData<T extends class_1314>
extends EasyNPC<T> {
    public static final String EASY_NPC_DATA_VARIANT_TAG = "Variant";

    public static void registerSyncedVariantData(EnumMap<SynchedDataIndex, class_2940<?>> map, Class<? extends class_1297> entityClass) {
        log.info("- Registering Synched Variant Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.VARIANT, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13326));
    }

    default public Enum<?> getDefaultVariant() {
        return Variant.STEVE;
    }

    default public Enum<?> getVariant() {
        return this.getVariant((String)this.getSynchedEntityData(SynchedDataIndex.VARIANT));
    }

    default public void setVariant(Enum<?> variant) {
        this.setSynchedEntityData(SynchedDataIndex.VARIANT, variant != null ? variant.name() : "");
    }

    default public void setVariant(String name) {
        Enum<?> variant = this.getVariant(name);
        if (variant != null) {
            this.setVariant(variant);
        } else {
            log.error("Unknown variant {} for {}", (Object)name, (Object)this);
        }
    }

    default public Enum<?> getVariant(String name) {
        return Variant.valueOf(name);
    }

    default public Enum<?>[] getVariants() {
        return Variant.values();
    }

    default public Stream<String> getVariantNames() {
        return Stream.of(this.getVariants()).map(Enum::name);
    }

    default public class_2561 getVariantName() {
        Enum<?> variant = this.getVariant();
        return variant != null ? TextUtils.normalizeName(variant.name()) : this.getEasyNPCTypeName();
    }

    default public boolean hasVariantCrossedArms() {
        return this.hasVariantCrossedArms(this.getVariant());
    }

    default public boolean hasVariantCrossedArms(Enum<?> variant) {
        return variant != null && variant.name().endsWith("_CROSSED_ARMS");
    }

    default public boolean hasVariantSaddled() {
        return this.hasVariantSaddled(this.getVariant());
    }

    default public boolean hasVariantSaddled(Enum<?> variant) {
        return variant != null && variant.name().endsWith("_SADDLED");
    }

    default public void defineSynchedVariantData() {
        this.defineSynchedEntityData(SynchedDataIndex.VARIANT, this.getDefaultVariant().name());
    }

    default public void addAdditionalVariantData(class_2487 compoundTag) {
        if (this.getVariant() != null) {
            compoundTag.method_10582(EASY_NPC_DATA_VARIANT_TAG, this.getVariant().name());
        }
    }

    default public void readAdditionalVariantData(class_2487 compoundTag) {
        String variant;
        if (compoundTag.method_10545(EASY_NPC_DATA_VARIANT_TAG) && !(variant = compoundTag.method_10558(EASY_NPC_DATA_VARIANT_TAG)).isEmpty()) {
            this.setVariant(this.getVariant(variant));
        }
    }

    public static enum Variant {
        STEVE,
        ALEX;

    }
}

