/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.data.attribute.EntityAttribute;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttributeData;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationData;
import de.markusbordihn.easynpc.entity.easynpc.data.ObjectiveData;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttributeHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");

    private AttributeHandler() {
    }

    public static boolean setEntityAttribute(EasyNPC<?> easyNPC, EntityAttribute entityAttribute, boolean value) {
        if (easyNPC == null || entityAttribute == null) {
            return false;
        }
        AttributeData<?> attributeData = easyNPC.getEasyNPCAttributeData();
        if (attributeData != null) {
            ObjectiveData<?> objectiveData = easyNPC.getEasyNPCObjectiveData();
            NavigationData<?> navigationData = easyNPC.getEasyNPCNavigationData();
            switch (entityAttribute) {
                case FREEFALL: {
                    log.debug("Change freefall={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeFreefall(value);
                    break;
                }
                case CAN_BE_LEASHED: {
                    log.debug("Change canBeLeashed={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeCanBeLeashed(value);
                    break;
                }
                case CAN_FLOAT: {
                    log.debug("Change canFloat={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeCanFloat(value);
                    if (objectiveData != null) {
                        objectiveData.registerAttributeBasedObjectives();
                    }
                    if (navigationData == null) break;
                    navigationData.refreshGroundNavigation();
                    break;
                }
                case CAN_OPEN_DOOR: {
                    log.debug("Change canOpenDoor={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeCanOpenDoor(value);
                    if (navigationData != null) {
                        navigationData.refreshGroundNavigation();
                    }
                    if (objectiveData == null) break;
                    objectiveData.registerAttributeBasedObjectives();
                    break;
                }
                case CAN_CLOSE_DOOR: {
                    log.debug("Change canCloseDoor={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeCanCloseDoor(value);
                    if (objectiveData == null) break;
                    objectiveData.registerAttributeBasedObjectives();
                    break;
                }
                case CAN_PASS_DOOR: {
                    log.debug("Change canPassDoor={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeCanPassDoor(value);
                    if (navigationData == null) break;
                    navigationData.refreshGroundNavigation();
                    break;
                }
                case CAN_USE_NETHER_PORTAL: {
                    log.debug("Change canUseNetherPortal={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeCanUseNetherPortal(value);
                    break;
                }
                case IS_ATTACKABLE: {
                    log.debug("Change isAttackable={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeIsAttackable(value);
                    if (easyNPC.getLivingEntity() == null) break;
                    easyNPC.getLivingEntity().method_5684(!value);
                    break;
                }
                case IS_PUSHABLE: {
                    log.debug("Change isPushable={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeIsPushable(value);
                    break;
                }
                case PUSH_ENTITIES: {
                    log.debug("Change pushEntities={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributePushEntities(value);
                    break;
                }
                case SILENT: {
                    log.debug("Change silent={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeSilent(value);
                    break;
                }
                default: {
                    log.error("Unimplemented entity attribute {} for {}", (Object)entityAttribute, easyNPC);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean setBaseAttribute(EasyNPC<?> easyNPC, class_2960 attribute, Double value) {
        if (easyNPC == null || attribute == null || value == null) {
            return false;
        }
        AttributeData<?> attributeData = easyNPC.getEasyNPCAttributeData();
        if (attributeData != null) {
            switch (attribute.toString()) {
                case "minecraft:generic.max_health": {
                    attributeData.setBaseAttribute(class_5134.field_23716, value);
                    class_1309 livingEntity = easyNPC.getLivingEntity();
                    if (livingEntity == null) break;
                    livingEntity.method_6033(value.floatValue());
                    break;
                }
                case "minecraft:generic.follow_range": {
                    attributeData.setBaseAttribute(class_5134.field_23717, value);
                    break;
                }
                case "minecraft:generic.knockback_resistance": {
                    attributeData.setBaseAttribute(class_5134.field_23718, value);
                    break;
                }
                case "minecraft:generic.movement_speed": {
                    attributeData.setBaseAttribute(class_5134.field_23719, value);
                    break;
                }
                case "minecraft:generic.flying_speed": {
                    attributeData.setBaseAttribute(class_5134.field_23720, value);
                    break;
                }
                case "minecraft:generic.attack_damage": {
                    attributeData.setBaseAttribute(class_5134.field_23721, value);
                    break;
                }
                case "minecraft:generic.attack_knockback": {
                    attributeData.setBaseAttribute(class_5134.field_23722, value);
                    break;
                }
                case "minecraft:generic.attack_speed": {
                    attributeData.setBaseAttribute(class_5134.field_23723, value);
                    break;
                }
                case "minecraft:generic.armor": {
                    attributeData.setBaseAttribute(class_5134.field_23724, value);
                    break;
                }
                case "minecraft:generic.armor_toughness": {
                    attributeData.setBaseAttribute(class_5134.field_23725, value);
                    break;
                }
                case "minecraft:generic.luck": {
                    attributeData.setBaseAttribute(class_5134.field_23726, value);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

