/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network;

import de.markusbordihn.easynpc.network.NetworkHandlerInterface;
import de.markusbordihn.easynpc.network.NetworkHandlerManager;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkHandler
implements NetworkHandlerInterface {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");

    public NetworkHandler() {
        log.info("{} NetworkHandler ...", (Object)"\ud83d\udde3 Register Easy NPC");
    }

    public static void registerClientNetworkHandler() {
        NetworkHandlerManager.registerClientNetworkHandler();
    }

    public static void registerServerNetworkHandler() {
        NetworkHandlerManager.registerServerNetworkHandler();
    }

    public void sendToServer(NetworkMessageRecord networkMessageRecord) {
        if (class_310.method_1551().method_1562() == null) {
            log.warn("Failed to send {} to server: No connection available", (Object)networkMessageRecord);
            return;
        }
        try {
            ClientPlayNetworking.send((class_2960)networkMessageRecord.id(), (class_2540)networkMessageRecord.payload());
        }
        catch (Exception e) {
            log.error("Failed to send {} to server:", (Object)networkMessageRecord, (Object)e);
        }
    }

    public void sendToPlayer(NetworkMessageRecord networkMessageRecord, class_3222 serverPlayer) {
        try {
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)networkMessageRecord.id(), (class_2540)networkMessageRecord.payload());
        }
        catch (Exception e) {
            log.error("Failed to send {} to player {}:", (Object)networkMessageRecord, (Object)serverPlayer, (Object)e);
        }
    }

    @Override
    public <M extends NetworkMessageRecord> void registerClientNetworkMessageHandler(class_2960 messageID, Class<M> networkMessageRecord, Function<class_2540, M> creator) {
        try {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)messageID, (client, channelHandler, buffer, responseSender) -> {
                NetworkMessageRecord networkMessage = (NetworkMessageRecord)creator.apply(buffer);
                networkMessage.handleClient();
            });
        }
        catch (Exception e) {
            log.error("Failed to register client network message handler {}:", networkMessageRecord, (Object)e);
        }
    }

    @Override
    public <M extends NetworkMessageRecord> void registerServerNetworkMessageHandler(class_2960 messageID, Class<M> networkMessageRecord, Function<class_2540, M> creator) {
        try {
            ServerPlayNetworking.registerGlobalReceiver((class_2960)messageID, (server, serverPlayer, channelHandler, buffer, responseSender) -> {
                NetworkMessageRecord networkMessage = (NetworkMessageRecord)creator.apply(buffer);
                networkMessage.handleServer(serverPlayer);
            });
        }
        catch (Exception e) {
            log.error("Failed to register server network message handler {}:", (Object)messageID, (Object)e);
        }
    }
}

