/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.trading.TradingValueType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record ChangeAdvancedTradingMessage(UUID uuid, int tradingOfferIndex, TradingValueType tradingValueType, float tradingValue) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc", "change_advanced_trading");

    public static ChangeAdvancedTradingMessage create(class_2540 buffer) {
        return new ChangeAdvancedTradingMessage(buffer.method_10790(), buffer.readInt(), (TradingValueType)buffer.method_10818(TradingValueType.class), buffer.readFloat());
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.writeInt(this.tradingOfferIndex);
        buffer.method_10817((Enum)this.tradingValueType);
        buffer.writeFloat(this.tradingValue);
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(class_3222 serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.tradingOfferIndex < 0) {
            log.error("Trading offer index {} is out of range (>= 0) for {}", (Object)this.tradingOfferIndex, (Object)serverPlayer);
            return;
        }
        if (this.tradingValueType == null) {
            log.error("Trading value type is unknown for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if ((double)this.tradingValue < 0.0) {
            log.error("Trading value {} for {} is out of range (>= 0) for {}", (Object)Float.valueOf(this.tradingValue), (Object)this.tradingValueType, (Object)serverPlayer);
            return;
        }
        TradingData<?> tradingData = easyNPC.getEasyNPCTradingData();
        if (tradingData == null) {
            log.error("Trading data for {} is not available for {}", easyNPC, (Object)serverPlayer);
            return;
        }
        switch (this.tradingValueType) {
            case RESET_TRADING_EVERY_MIN: {
                log.debug("Set trading resets every min to {} for {} from {}", (Object)Float.valueOf(this.tradingValue), easyNPC, (Object)serverPlayer);
                tradingData.getTradingDataSet().setResetsEveryMin((int)this.tradingValue);
                break;
            }
            case MAX_USES: {
                log.debug("Set advanced trading max uses {}# for {} to {} by {}", (Object)this.tradingOfferIndex, easyNPC, (Object)Float.valueOf(this.tradingValue), (Object)serverPlayer);
                tradingData.setAdvancedTradingMaxUses(this.tradingOfferIndex, (int)this.tradingValue);
                break;
            }
            case REWARD_EXP: {
                log.debug("Set advanced trading xp {}# for {} to {} by {}", (Object)this.tradingOfferIndex, easyNPC, (Object)Float.valueOf(this.tradingValue), (Object)serverPlayer);
                tradingData.setAdvancedTradingXp(this.tradingOfferIndex, (int)this.tradingValue);
                break;
            }
            case PRICE_MULTIPLIER: {
                log.debug("Set advanced trading price multiplier {}# for {} to {} by {}", (Object)this.tradingOfferIndex, easyNPC, (Object)Float.valueOf(this.tradingValue), (Object)serverPlayer);
                tradingData.setAdvancedTradingPriceMultiplier(this.tradingOfferIndex, this.tradingValue);
                break;
            }
            case DEMAND: {
                log.debug("Set advanced trading demand {}# for {} to {} by {}", (Object)this.tradingOfferIndex, easyNPC, (Object)Float.valueOf(this.tradingValue), (Object)serverPlayer);
                tradingData.setAdvancedTradingDemand(this.tradingOfferIndex, (int)this.tradingValue);
                break;
            }
            default: {
                log.error("Trading value type {} with value {}# for {} is unknown for {}", (Object)this.tradingValueType, (Object)Float.valueOf(this.tradingValue), (Object)this.tradingOfferIndex, (Object)serverPlayer);
            }
        }
    }
}

