/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.block.entity.BaseEasyNPCSpawnerBlockEntity;
import de.markusbordihn.easynpc.data.spawner.SpawnerSettingType;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public record ChangeSpawnerSettingMessage(class_2338 blockPos, SpawnerSettingType settingType, int settingValue) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc", "change_spawner_settings");

    public static ChangeSpawnerSettingMessage create(class_2540 buffer) {
        return new ChangeSpawnerSettingMessage(buffer.method_10811(), (SpawnerSettingType)buffer.method_10818(SpawnerSettingType.class), buffer.readInt());
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10807(this.blockPos);
        buffer.method_10817((Enum)this.settingType);
        buffer.writeInt(this.settingValue);
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(class_3222 serverPlayer) {
        if (serverPlayer == null) {
            return;
        }
        class_3218 serverLevel = serverPlayer.method_51469();
        class_2586 blockEntity = serverLevel.method_8321(this.blockPos);
        if (blockEntity == null) {
            blockEntity = serverLevel.method_8500(this.blockPos).method_12201(this.blockPos, class_2818.class_2819.field_12860);
        }
        if (!(blockEntity instanceof BaseEasyNPCSpawnerBlockEntity)) {
            log.error("Found {}({}) instead of NPC spawner block entity at {}", (Object)blockEntity, (Object)serverLevel.method_8320(this.blockPos), (Object)this.blockPos);
            return;
        }
        BaseEasyNPCSpawnerBlockEntity spawnerBlockEntity = (BaseEasyNPCSpawnerBlockEntity)blockEntity;
        if (!serverPlayer.method_7337() && spawnerBlockEntity.getOwner() != null && !spawnerBlockEntity.getOwner().equals(serverPlayer.method_5667())) {
            log.warn("Player {} has no permission to change the settings of spawner at {}", (Object)serverPlayer.method_5477().getString(), (Object)this.blockPos);
            return;
        }
        switch (this.settingType) {
            case SPAWN_RANGE: {
                log.debug("Set spawner {} spawn range to {}", (Object)spawnerBlockEntity, (Object)this.settingValue);
                spawnerBlockEntity.setSpawnRange(this.settingValue);
                break;
            }
            case DESPAWN_RANGE: {
                log.debug("Set spawner {} despawn range to {}", (Object)spawnerBlockEntity, (Object)this.settingValue);
                spawnerBlockEntity.setDespawnRange(this.settingValue);
                break;
            }
            case REQUIRED_PLAYER_RANGE: {
                log.debug("Set spawner {} required player range to {}", (Object)spawnerBlockEntity, (Object)this.settingValue);
                spawnerBlockEntity.setRequiredPlayerRange(this.settingValue);
                break;
            }
            case DELAY: {
                log.debug("Set spawner {} delay to {}", (Object)spawnerBlockEntity, (Object)this.settingValue);
                spawnerBlockEntity.setDelay(this.settingValue);
                break;
            }
            case MAX_NEARBY_ENTITIES: {
                log.debug("Set spawner {} max nearby entities to {}", (Object)spawnerBlockEntity, (Object)this.settingValue);
                spawnerBlockEntity.setMaxNearbyEntities(this.settingValue);
                break;
            }
            case SPAWN_COUNT: {
                log.debug("Set spawner {} spawn count to {}", (Object)spawnerBlockEntity, (Object)this.settingValue);
                spawnerBlockEntity.setSpawnCount(this.settingValue);
                break;
            }
            default: {
                log.error("Unknown spawner setting type {} for {}", (Object)this.settingType, (Object)spawnerBlockEntity);
            }
        }
    }
}

