/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record ChangeTradingTypeMessage(UUID uuid, TradingType tradingType) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc", "change_trading_type");

    public static ChangeTradingTypeMessage create(class_2540 buffer) {
        return new ChangeTradingTypeMessage(buffer.method_10790(), (TradingType)buffer.method_10818(TradingType.class));
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10817((Enum)this.tradingType);
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(class_3222 serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.tradingType == null) {
            log.error("Invalid trading type for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        TradingData<?> tradingData = easyNPC.getEasyNPCTradingData();
        if (tradingData == null) {
            log.error("Invalid trading data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change trading type: {} for {} from {}", (Object)this.tradingType, easyNPC, (Object)serverPlayer);
        tradingData.getTradingDataSet().setType(this.tradingType);
    }
}

