/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventData;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public record SaveDialogButtonMessage(UUID uuid, UUID dialogId, UUID dialogButtonId, DialogButtonEntry dialogButtonEntry) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc", "save_dialog_button");

    public static SaveDialogButtonMessage create(class_2540 buffer) {
        return new SaveDialogButtonMessage(buffer.method_10790(), buffer.method_10790(), buffer.method_10790(), new DialogButtonEntry(buffer.method_10798()));
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10797(this.dialogId);
        buffer.method_10797(this.dialogButtonId);
        buffer.method_10794(this.dialogButtonEntry.createTag());
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(class_3222 serverPlayer) {
        int permissionLevel;
        MinecraftServer minecraftServer;
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.dialogId == null) {
            log.error("Invalid dialog id for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.dialogButtonEntry == null) {
            log.error("Invalid dialog button data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        DialogData<?> dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Invalid dialog data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        ActionEventData<?> actionEventData = easyNPC.getEasyNPCActionEventData();
        if (actionEventData == null) {
            log.error("Invalid action data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (!dialogData.hasDialog(this.dialogId)) {
            log.error("Unknown dialog button editor request for dialog {} for {} from {}", (Object)this.dialogId, easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.dialogButtonId != null && !dialogData.hasDialogButton(this.dialogId, this.dialogButtonId)) {
            log.error("Invalid dialog button {} for {} from {}", (Object)this.dialogButtonId, easyNPC, (Object)serverPlayer);
            return;
        }
        int currentPermissionLevel = actionEventData.getActionPermissionLevel();
        if (currentPermissionLevel == 0 && (minecraftServer = serverPlayer.method_5682()) != null && (permissionLevel = minecraftServer.method_3835(serverPlayer.method_7334())) > currentPermissionLevel) {
            log.debug("Update owner permission level from {} to {} for {} from {}", (Object)currentPermissionLevel, (Object)permissionLevel, easyNPC, (Object)serverPlayer);
            actionEventData.setActionPermissionLevel(permissionLevel);
        }
        if (this.dialogButtonId == null) {
            log.info("Add new dialog button {} for dialog {} for {} from {}", (Object)this.dialogButtonEntry, (Object)this.dialogId, easyNPC, (Object)serverPlayer);
            dialogData.getDialogDataSet().getDialog(this.dialogId).setDialogButton(this.dialogButtonEntry);
        } else {
            log.info("Edit existing dialog button {} for dialog {} for {} from {}", (Object)this.dialogButtonEntry, (Object)this.dialogId, easyNPC, (Object)serverPlayer);
            dialogData.getDialogDataSet().getDialog(this.dialogId).setDialogButton(this.dialogButtonId, this.dialogButtonEntry);
        }
    }
}

