/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.entity.easynpc.data.GuiData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.entity.easynpc.data.ProfessionData;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderData;
import de.markusbordihn.easynpc.entity.easynpc.data.ScaleData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_898;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ScreenHelper {
    protected ScreenHelper() {
    }

    public static void renderEntity(int x, int y, int scale, float yRot, float xRot, class_1309 livingEntity) {
        class_310 minecraft = class_310.method_1551();
        float f = (float)Math.atan(yRot / 40.0f);
        float f1 = (float)Math.atan(xRot / 40.0f);
        class_4587 poseStack = RenderSystem.getModelViewStack();
        poseStack.method_22903();
        poseStack.method_22904((double)x, (double)y, 1050.0);
        poseStack.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 poseStack1 = new class_4587();
        poseStack1.method_22904(0.0, 0.0, 1000.0);
        poseStack1.method_22905((float)scale, (float)scale, (float)scale);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf1 = new Quaternionf().rotateX(f1 * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf1);
        poseStack1.method_22907(quaternionf);
        class_2561 entityCustomName = livingEntity.method_5797();
        boolean entityShouldShowName = livingEntity.method_5733();
        float entityXRot = livingEntity.method_36455();
        float entityYBodyRot = livingEntity.field_6283;
        float entityYHeadRot = livingEntity.field_6241;
        float entityYHeadRotO = livingEntity.field_6259;
        float entityYRot = livingEntity.method_36454();
        boolean entityInvisible = livingEntity.method_5767();
        class_270 entityTeam = livingEntity.method_5781();
        livingEntity.method_5648(false);
        livingEntity.field_6283 = 180.0f + f * 20.0f;
        livingEntity.method_36456(180.0f + f * 40.0f);
        livingEntity.method_36457(-f1 * 20.0f);
        livingEntity.field_6241 = livingEntity.method_36454();
        if (entityTeam instanceof class_268) {
            class_268 playerTeam = (class_268)entityTeam;
            livingEntity.method_37908().method_8428().method_1157(livingEntity.method_5820(), playerTeam);
        }
        boolean minecraftHideGui = false;
        if (minecraft != null) {
            minecraftHideGui = minecraft.field_1690.field_1842;
            minecraft.field_1690.field_1842 = true;
        } else {
            livingEntity.method_5665(null);
            livingEntity.method_5880(false);
        }
        class_308.method_34742();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        quaternionf1.conjugate();
        entityRenderDispatcher.method_24196(quaternionf1);
        entityRenderDispatcher.method_3948(false);
        class_4597.class_4598 multiBuffer = class_310.method_1551().method_22940().method_23000();
        entityRenderDispatcher.method_3954((class_1297)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack1, (class_4597)multiBuffer, 0xF000F0);
        multiBuffer.method_22993();
        entityRenderDispatcher.method_3948(true);
        livingEntity.method_5648(entityInvisible);
        livingEntity.field_6283 = entityYBodyRot;
        livingEntity.method_36456(entityYRot);
        livingEntity.method_36457(entityXRot);
        livingEntity.field_6241 = entityYHeadRot;
        livingEntity.field_6259 = entityYHeadRotO;
        if (entityTeam instanceof class_268) {
            class_268 playerTeam = (class_268)entityTeam;
            livingEntity.method_37908().method_8428().method_1172(livingEntity.method_5820(), playerTeam);
        }
        if (minecraft != null) {
            minecraft.field_1690.field_1842 = minecraftHideGui;
        } else {
            livingEntity.method_5665(entityCustomName);
            livingEntity.method_5880(entityShouldShowName);
        }
        poseStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
    }

    public static void renderScaledEntityAvatar(int x, int y, int scale, float yRot, float xRot, EasyNPC<?> easyNPC) {
        ScaleData<?> scaleData = easyNPC.getEasyNPCScaleData();
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        if (scaleData != null && modelData != null) {
            ScreenHelper.renderScaledEntityAvatar(x, y, scale, yRot, xRot, easyNPC, scaleData, modelData);
        } else {
            ScreenHelper.renderEntity(x, y, scale, yRot, xRot, easyNPC.getLivingEntity());
        }
    }

    public static void renderScaledEntityAvatar(int x, int y, float yRot, float xRot, EasyNPC<?> easyNPC) {
        GuiData<?> guiData = easyNPC.getEasyNPCGuiData();
        ScreenHelper.renderScaledEntityAvatar(x, y, guiData.getEntityGuiScaling(), yRot, xRot, easyNPC);
    }

    public static void renderScaledEntityAvatar(int x, int y, int scale, float yRot, float xRot, EasyNPC<?> easyNPC, ScaleData<?> scaleData, ModelData<?> modelData) {
        CustomRotation entityModelRootRotation;
        float entityScaleX = scaleData != null ? scaleData.getScaleX().floatValue() : 0.4f;
        float entityScaleY = scaleData != null ? scaleData.getScaleY().floatValue() : 0.4f;
        float entityScaleZ = scaleData != null ? scaleData.getScaleZ().floatValue() : 0.4f;
        CustomRotation customRotation = entityModelRootRotation = modelData != null ? modelData.getModelRootRotation() : null;
        if (scaleData != null) {
            scaleData.setScaleX(scaleData.getDefaultScaleX());
            scaleData.setScaleY(scaleData.getDefaultScaleY());
            scaleData.setScaleZ(scaleData.getDefaultScaleZ());
        }
        if (modelData != null) {
            modelData.setModelRootRotation(new CustomRotation(0.0f, 0.0f, 0.0f));
        }
        ScreenHelper.renderEntity(x, y, scale, yRot, xRot, easyNPC.getLivingEntity());
        if (scaleData != null) {
            scaleData.setScaleX(Float.valueOf(entityScaleX));
            scaleData.setScaleY(Float.valueOf(entityScaleY));
            scaleData.setScaleZ(Float.valueOf(entityScaleZ));
        }
        if (modelData != null && entityModelRootRotation != null) {
            modelData.setModelRootRotation(entityModelRootRotation);
        }
    }

    public static void renderCustomPoseEntityAvatar(int x, int y, int scale, float yRot, float xRot, EasyNPC<?> easyNPC) {
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        class_1297 entity = easyNPC.getEntity();
        ModelPose entityModelPose = modelData.getModelPose();
        class_4050 entityPose = easyNPC.getEntity().method_18376();
        modelData.setModelPose(ModelPose.CUSTOM);
        entity.method_18380(class_4050.field_18076);
        ScreenHelper.renderScaledEntityAvatar(x, y, scale, yRot, xRot, easyNPC, easyNPC.getEasyNPCScaleData(), modelData);
        modelData.setModelPose(entityModelPose);
        entity.method_18380(entityPose);
    }

    public static void renderEntityAvatarForScaling(int x, int y, int scale, float yRot, float xRot, EasyNPC<?> easyNPC) {
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        class_1297 entity = easyNPC.getEntity();
        CustomRotation entityModelRootRotation = modelData.getModelRootRotation();
        boolean entityInvisible = entity.method_5767();
        modelData.setModelRootRotation(new CustomRotation(0.0f, 0.0f, 0.0f));
        entity.method_5648(false);
        ScreenHelper.renderEntity(x, y, scale, yRot, xRot, easyNPC.getLivingEntity());
        modelData.setModelRootRotation(entityModelRootRotation);
        entity.method_5648(entityInvisible);
    }

    public static void renderEntityDialog(int x, int y, float yRot, float xRot, EasyNPC<?> easyNPC) {
        DialogData<?> dialogData = easyNPC.getEasyNPCDialogData();
        ScreenHelper.renderEntity(x, y, dialogData.getEntityDialogScaling(), yRot, xRot, easyNPC.getLivingEntity());
    }

    public static void renderEntityCustomModel(int x, int y, int scale, float yRot, float xRot, EasyNPC<?> easyNPC, class_1299<? extends class_1297> entityType) {
        GuiData<?> guiData = easyNPC.getEasyNPCGuiData();
        RenderData<?> renderData = easyNPC.getEasyNPCRenderData();
        RenderDataSet renderDataSet = renderData.getRenderDataSet();
        RenderType renderType = renderDataSet.getRenderType();
        class_1299<? extends class_1297> renderEntityType = renderDataSet.getRenderEntityType();
        renderDataSet.setRenderType(RenderType.CUSTOM);
        renderDataSet.setRenderEntityType(entityType);
        ScreenHelper.renderScaledEntityAvatar(x + guiData.getEntityGuiLeft(), y + guiData.getEntityGuiTop(), scale, yRot, xRot, easyNPC, easyNPC.getEasyNPCScaleData(), easyNPC.getEasyNPCModelData());
        renderDataSet.setRenderType(renderType);
        renderDataSet.setRenderEntityType(renderEntityType);
    }

    public static void renderEntityCustomSkin(int x, int y, float yRot, float xRot, EasyNPC<?> easyNPC, UUID userUUID, SkinType skinType) {
        SkinData<?> skinData = easyNPC.getEasyNPCSkinData();
        GuiData<?> guiData = easyNPC.getEasyNPCGuiData();
        SkinType entitySkinType = skinData.getSkinType();
        UUID entitySkinUUID = skinData.getSkinUUID();
        skinData.setSkinDataEntry(skinData.getSkinDataEntry().withType(skinType).withUUID(userUUID));
        ScreenHelper.renderScaledEntityAvatar(x + guiData.getEntityGuiLeft(), y + guiData.getEntityGuiTop(), skinData.getEntitySkinScaling(), yRot, xRot, easyNPC, easyNPC.getEasyNPCScaleData(), easyNPC.getEasyNPCModelData());
        skinData.setSkinDataEntry(skinData.getSkinDataEntry().withType(entitySkinType).withUUID(entitySkinUUID));
    }

    public static void renderEntityDefaultSkin(int x, int y, float yRot, float xRot, EasyNPC<?> easyNPC, Enum<?> variant, Profession profession) {
        SkinData<?> skinData = easyNPC.getEasyNPCSkinData();
        VariantData<?> variantData = easyNPC.getEasyNPCVariantData();
        ProfessionData<?> professionData = easyNPC.getEasyNPCProfessionData();
        GuiData<?> guiData = easyNPC.getEasyNPCGuiData();
        SkinType entitySkinType = skinData.getSkinType();
        Enum<?> entityVariant = variantData.getVariant();
        Profession entityProfession = professionData.getProfession();
        skinData.setSkinDataEntry(skinData.getSkinDataEntry().withType(SkinType.DEFAULT).withName("default"));
        variantData.setVariant(variant);
        professionData.setProfession(profession);
        ScreenHelper.renderEntity(x + guiData.getEntityGuiLeft(), y + guiData.getEntityGuiTop(), skinData.getEntitySkinScaling(), yRot, xRot, easyNPC.getLivingEntity());
        skinData.setSkinDataEntry(skinData.getSkinDataEntry().withType(entitySkinType));
        variantData.setVariant(entityVariant);
        professionData.setProfession(entityProfession);
    }
}

