/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import net.minecraft.class_1915;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_3222;

public class TradingCommand
extends Command {
    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"trading").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"open").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> {
            class_3222 serverPlayer = ((class_2168)context.getSource()).method_9207();
            return TradingCommand.open((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "target"), serverPlayer);
        })).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> TradingCommand.open((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "target"), class_2186.method_9315((CommandContext)context, (String)"player"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(class_2170.method_9244((String)"target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> TradingCommand.reset((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "target")))));
    }

    private static int reset(class_2168 context, EasyNPC<?> easyNPC) {
        if (easyNPC == null) {
            return 0;
        }
        TradingData<?> tradingData = easyNPC.getEasyNPCTradingData();
        if (tradingData == null) {
            return TradingCommand.sendFailureMessageNoTradingData(context, easyNPC);
        }
        tradingData.resetTradingOffers();
        return TradingCommand.sendSuccessMessage(context, "Trading offers for " + easyNPC + " were reset to default values.");
    }

    private static int open(class_2168 context, EasyNPC<?> easyNPC, class_3222 serverPlayer) {
        if (easyNPC == null || serverPlayer == null) {
            return 0;
        }
        class_1915 merchant = easyNPC.getMerchant();
        if (merchant == null) {
            return TradingCommand.sendFailureMessageNoMerchant(context, easyNPC);
        }
        TradingData<?> tradingData = easyNPC.getEasyNPCTradingData();
        if (tradingData == null) {
            return TradingCommand.sendFailureMessageNoTradingData(context, easyNPC);
        }
        tradingData.openTradingScreen(serverPlayer);
        return TradingCommand.sendSuccessMessage(context, "Opened trading screen for " + serverPlayer + " with merchant " + easyNPC + " !");
    }
}

