/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.utils;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ValueUtils {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final String POSITIVE_NUMBER_MATCH_PATTERN = "^\\d+$";

    private ValueUtils() {
    }

    public static boolean isFloatValue(String text) {
        return text != null && (text.isEmpty() || text.matches("^\\d+(\\.?\\d*)?$") && Float.parseFloat(text) >= 0.0f);
    }

    public static boolean isNumericValue(String text, int min, int max) {
        return text != null && !text.isEmpty() && text.matches(POSITIVE_NUMBER_MATCH_PATTERN) && Integer.parseInt(text) >= min && Integer.parseInt(text) <= max;
    }

    public static boolean isPositiveNumericValueOrZero(String text) {
        return text != null && !text.isEmpty() && text.matches(POSITIVE_NUMBER_MATCH_PATTERN) && Integer.parseInt(text) >= 0;
    }

    public static boolean isNumericValue(String text) {
        return text != null && (text.isEmpty() || text.matches("^-?\\d+$"));
    }

    public static Double getDoubleValue(String value) {
        if (value != null && !value.isEmpty()) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                log.error("Failed to parse double value: {}", (Object)value);
            }
        }
        return 0.0;
    }

    public static Integer getIntValue(String value) {
        if (value != null && !value.isEmpty()) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                log.error("Failed to parse integer value: {}", (Object)value);
            }
        }
        return 0;
    }
}

