/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dev.emi.emi.com.unascribed.qdcss.QDCSS;
import dev.emi.emi.config.ConfigEnum;
import dev.emi.emi.config.EffectLocation;
import dev.emi.emi.config.FluidUnit;
import dev.emi.emi.config.HeaderType;
import dev.emi.emi.config.HelpLevel;
import dev.emi.emi.config.IndexSource;
import dev.emi.emi.config.IntGroup;
import dev.emi.emi.config.Margins;
import dev.emi.emi.config.RecipeBookAction;
import dev.emi.emi.config.ScreenAlign;
import dev.emi.emi.config.SidebarPages;
import dev.emi.emi.config.SidebarSettings;
import dev.emi.emi.config.SidebarSide;
import dev.emi.emi.config.SidebarSubpanels;
import dev.emi.emi.config.SidebarTheme;
import dev.emi.emi.config.SidebarType;
import dev.emi.emi.input.EmiBind;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.runtime.EmiLog;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.File;
import java.io.FileWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import net.minecraft.class_156;
import net.minecraft.class_2583;
import net.minecraft.class_3675;
import net.minecraft.class_5225;
import net.minecraft.class_5348;

public class EmiConfig {
    private static final Map<Class<?>, Setter> SETTERS = Maps.newHashMap();
    private static final Map<Class<?>, Writer<?>> WRITERS = Maps.newHashMap();
    private static final Map<Class<?>, MultiWriter<?>> MULTI_WRITERS = Maps.newHashMap();
    private static final Map<String, List<String>> unparsed = Maps.newHashMap();
    public static final Map<String, Predicate<?>> FILTERS = Maps.newHashMap();
    public static final String DEFAULT_CONFIG;
    public static boolean useGlobalConfig;
    public static String startupConfig;
    @Comment(value="Whether EMI is enabled and visible.")
    @ConfigValue(value="general.enabled")
    public static boolean enabled;
    @Comment(value="Whether cheating in items is enabled.")
    @ConfigValue(value="general.cheat-mode")
    public static boolean cheatMode;
    @Comment(value="How much EMI should use tooltips and popups to show controls and information.")
    @ConfigValue(value="general.help-level")
    public static HelpLevel helpLevel;
    @Comment(value="Where EMI should pull stacks from to populate the index.")
    @ConfigValue(value="general.index-source")
    public static IndexSource indexSource;
    @ConfigGroup(value="general.search")
    @Comment(value="Whether normal search queries should include the tooltip.")
    @ConfigValue(value="general.search-tooltip-by-default")
    public static boolean searchTooltipByDefault;
    @Comment(value="Whether normal search queries should include the mod name.")
    @ConfigValue(value="general.search-mod-name-by-default")
    public static boolean searchModNameByDefault;
    @ConfigGroupEnd
    @Comment(value="Whether normal search queries should include the stack's tags.")
    @ConfigValue(value="general.search-tags-by-default")
    public static boolean searchTagsByDefault;
    @Comment(value="Which action should be performed when clicking the recipe book.")
    @ConfigValue(value="ui.recipe-book-action")
    public static RecipeBookAction recipeBookAction;
    @Comment(value="Where to display status effects in the inventory.")
    @ConfigValue(value="ui.effect-location")
    public static EffectLocation effectLocation;
    @Comment(value="Whether to display a gray overlay when hovering over a stack.")
    @ConfigValue(value="ui.show-hover-overlay")
    public static boolean showHoverOverlay;
    @ConfigGroup(value="ui.mod-id")
    @Comment(value="Whether to add mod name to tooltips")
    @ConfigValue(value="ui.append-mod-id")
    public static boolean appendModId;
    @ConfigGroupEnd
    @Comment(value="Whether to add mod name to item tooltips, in case another mod provides behavior")
    @ConfigValue(value="ui.append-item-mod-id")
    public static boolean appendItemModId;
    @Comment(value="Prevents recipes being quick crafted from shifting around under the cursor.")
    @ConfigValue(value="ui.miscraft-prevention")
    public static boolean miscraftPrevention;
    @Comment(value="The unit to display fluids as.")
    @ConfigValue(value="ui.fluid-unit")
    public static FluidUnit fluidUnit;
    @Comment(value="Whether to use the batched render system. Batching is faster, but may have incompatibilities with shaders or other mods.")
    @ConfigValue(value="ui.use-batched-renderer")
    public static boolean useBatchedRenderer;
    @Comment(value="Whether to have the search bar in the center of the screen, instead of to the side.")
    @ConfigValue(value="ui.center-search-bar")
    public static boolean centerSearchBar;
    @ConfigFilter(value="ui.search-sidebar-focus")
    private static Predicate<SidebarType> searchSidebarFocusFilter;
    @Comment(value="Which sidebar type to switch to when searching.")
    @ConfigValue(value="ui.search-sidebar-focus")
    public static SidebarType searchSidebarFocus;
    @ConfigFilter(value="ui.empty-search-sidebar-focus")
    private static Predicate<SidebarType> emptySearchSidebarFocusFilter;
    @Comment(value="Which sidebar type to focus when the search is empty.")
    @ConfigValue(value="ui.empty-search-sidebar-focus")
    public static SidebarType emptySearchSidebarFocus;
    @ConfigGroup(value="ui.recipe-screen")
    @Comment(value="The maximum height the recipe screen will grow to be if space is available in pixels.")
    @ConfigValue(value="ui.maximum-recipe-screen-height")
    public static int maximumRecipeScreenHeight;
    @Comment(value="The minimum width of the recipe screen in pixels. Controls how many tabs there can be, and where the page switching buttons go. The default is 176, the width of most screens.")
    @ConfigValue(value="ui.minimum-recipe-screen-width")
    public static int minimumRecipeScreenWidth;
    @Comment(value="The amount of vertical margin to give in the recipe screen.")
    @ConfigValue(value="ui.vertical-margin")
    public static int verticalMargin;
    @ConfigFilter(value="ui.workstation-location")
    private static Predicate<SidebarSide> workstationLocationFilter;
    @Comment(value="Where to show workstations in the recipe screen")
    @ConfigValue(value="ui.workstation-location")
    public static SidebarSide workstationLocation;
    @ConfigGroupEnd
    @Comment(value="Display cost per batch when hovering a recipe output")
    @ConfigValue(value="ui.show-cost-per-batch")
    public static boolean showCostPerBatch;
    @ConfigGroup(value="ui.recipe-buttons")
    @Comment(value="Whether recipes should have a button to set as default.")
    @ConfigValue(value="ui.recipe-default-button")
    public static boolean recipeDefaultButton;
    @Comment(value="Whether recipes should have a button to show the recipe tree.")
    @ConfigValue(value="ui.recipe-tree-button")
    public static boolean recipeTreeButton;
    @Comment(value="Whether recipes should have a button to fill the ingredients in a handler.")
    @ConfigValue(value="ui.recipe-fill-button")
    public static boolean recipeFillButton;
    @Comment(value="Whether recipes should have a button to take a screenshot of the recipe.")
    @ConfigValue(value="ui.recipe-screenshot-button")
    public static boolean recipeScreenshotButton;
    @ConfigGroupEnd
    @Comment(value="The GUI scale at which recipe screenshots are saved. Use 0 to use the current GUI scale.")
    @ConfigValue(value="ui.recipe-screenshot-scale")
    public static int recipeScreenshotScale;
    @ConfigGroup(value="ui.left-sidebar")
    @Comment(value="The pages in the left sidebar")
    @ConfigValue(value="ui.left-sidebar-pages")
    public static SidebarPages leftSidebarPages;
    @Comment(value="The subpanels in the left sidebar")
    @ConfigValue(value="ui.left-sidebar-subpanels")
    public static SidebarSubpanels leftSidebarSubpanels;
    @Comment(value="How many columns and rows of ingredients to limit the left sidebar to")
    @ConfigValue(value="ui.left-sidebar-size")
    public static IntGroup leftSidebarSize;
    @Comment(value="How much space to maintain between the left sidebar and obstructions, in pixels")
    @ConfigValue(value="ui.left-sidebar-margins")
    public static Margins leftSidebarMargins;
    @Comment(value="Where to position the left sidebar")
    @ConfigValue(value="ui.left-sidebar-align")
    public static ScreenAlign leftSidebarAlign;
    @Comment(value="Whether to render the header buttons and page count for the left sidebar")
    @ConfigValue(value="ui.left-sidebar-header")
    public static HeaderType leftSidebarHeader;
    @ConfigGroupEnd
    @Comment(value="Which theme to use for the left sidebar")
    @ConfigValue(value="ui.left-sidebar-theme")
    public static SidebarTheme leftSidebarTheme;
    @ConfigGroup(value="ui.right-sidebar")
    @Comment(value="The pages in the right sidebar")
    @ConfigValue(value="ui.right-sidebar-pages")
    public static SidebarPages rightSidebarPages;
    @Comment(value="The subpanels in the right sidebar")
    @ConfigValue(value="ui.right-sidebar-subpanels")
    public static SidebarSubpanels rightSidebarSubpanels;
    @Comment(value="How many columns and rows of ingredients to limit the right sidebar to")
    @ConfigValue(value="ui.right-sidebar-size")
    public static IntGroup rightSidebarSize;
    @Comment(value="How much space to maintain between the right sidebar and obstructions, in pixels")
    @ConfigValue(value="ui.right-sidebar-margins")
    public static Margins rightSidebarMargins;
    @Comment(value="Where to position the right sidebar")
    @ConfigValue(value="ui.right-sidebar-align")
    public static ScreenAlign rightSidebarAlign;
    @Comment(value="Whether to render the header buttons and page count for the right sidebar")
    @ConfigValue(value="ui.right-sidebar-header")
    public static HeaderType rightSidebarHeader;
    @ConfigGroupEnd
    @Comment(value="Which theme to use for the right sidebar")
    @ConfigValue(value="ui.right-sidebar-theme")
    public static SidebarTheme rightSidebarTheme;
    @ConfigGroup(value="ui.top-sidebar")
    @Comment(value="The pages in the top sidebar")
    @ConfigValue(value="ui.top-sidebar-pages")
    public static SidebarPages topSidebarPages;
    @Comment(value="The subpanels in the top sidebar")
    @ConfigValue(value="ui.top-sidebar-subpanels")
    public static SidebarSubpanels topSidebarSubpanels;
    @Comment(value="How many columns and rows of ingredients to limit the top sidebar to")
    @ConfigValue(value="ui.top-sidebar-size")
    public static IntGroup topSidebarSize;
    @Comment(value="How much space to maintain between the top sidebar and obstructions, in pixels")
    @ConfigValue(value="ui.top-sidebar-margins")
    public static Margins topSidebarMargins;
    @Comment(value="Where to position the top sidebar")
    @ConfigValue(value="ui.top-sidebar-align")
    public static ScreenAlign topSidebarAlign;
    @Comment(value="Whether to render the header buttons and page count for the top sidebar")
    @ConfigValue(value="ui.top-sidebar-header")
    public static HeaderType topSidebarHeader;
    @ConfigGroupEnd
    @Comment(value="Which theme to use for the top sidebar")
    @ConfigValue(value="ui.top-sidebar-theme")
    public static SidebarTheme topSidebarTheme;
    @ConfigGroup(value="ui.bottom-sidebar")
    @Comment(value="The pages in the bottom sidebar")
    @ConfigValue(value="ui.bottom-sidebar-pages")
    public static SidebarPages bottomSidebarPages;
    @Comment(value="The subpanels in the bottom sidebar")
    @ConfigValue(value="ui.bottom-sidebar-subpanels")
    public static SidebarSubpanels bottomSidebarSubpanels;
    @Comment(value="How many columns and rows of ingredients to limit the bottom sidebar to")
    @ConfigValue(value="ui.bottom-sidebar-size")
    public static IntGroup bottomSidebarSize;
    @Comment(value="How much space to maintain between the bottom sidebar and obstructions, in pixels")
    @ConfigValue(value="ui.bottom-sidebar-margins")
    public static Margins bottomSidebarMargins;
    @Comment(value="Where to position the bottom sidebar")
    @ConfigValue(value="ui.bottom-sidebar-align")
    public static ScreenAlign bottomSidebarAlign;
    @Comment(value="Whether to render the header buttons and page count for the bottom sidebar")
    @ConfigValue(value="ui.bottom-sidebar-header")
    public static HeaderType bottomSidebarHeader;
    @ConfigGroupEnd
    @Comment(value="Which theme to use for the bottom sidebar")
    @ConfigValue(value="ui.bottom-sidebar-theme")
    public static SidebarTheme bottomSidebarTheme;
    @Comment(value="Toggle the visibility of EMI.")
    @ConfigValue(value="binds.toggle-visibility")
    public static EmiBind toggleVisibility;
    @Comment(value="Focuses the search bar.")
    @ConfigValue(value="binds.focus-search")
    public static EmiBind focusSearch;
    @Comment(value="Clears the search bar.")
    @ConfigValue(value="binds.clear-search")
    public static EmiBind clearSearch;
    @Comment(value="Display the recipes for creating a stack.")
    @ConfigValue(value="binds.view-recipes")
    public static EmiBind viewRecipes;
    @Comment(value="Display the recipes that can be created using a stack.")
    @ConfigValue(value="binds.view-uses")
    public static EmiBind viewUses;
    @Comment(value="Favorite the item to display on the side of the screen opposite of recipies for quick access.")
    @ConfigValue(value="binds.favorite")
    public static EmiBind favorite;
    @Comment(value="Set the default recipe for a given stack in the output of a recipe to that recipe.")
    @ConfigValue(value="binds.default-stack")
    public static EmiBind defaultStack;
    @Comment(value="Display the recipe tree for a given stack.")
    @ConfigValue(value="binds.view-stack-tree")
    public static EmiBind viewStackTree;
    @Comment(value="Display the recipe tree.")
    @ConfigValue(value="binds.view-tree")
    public static EmiBind viewTree;
    @Comment(value="Return to the previous page in EMI.")
    @ConfigValue(value="binds.back")
    public static EmiBind back;
    @Comment(value="Return to the next page in EMI after going back.")
    @ConfigValue(value="binds.forward")
    public static EmiBind forward;
    @ConfigGroup(value="binds.crafts")
    @Comment(value="When on a stack with an associated recipe:\nMove ingredients for a single result.")
    @ConfigValue(value="binds.craft-one")
    public static EmiBind craftOne;
    @Comment(value="When on a stack with an associated recipe:\nMove ingredients for as many results as possible.")
    @ConfigValue(value="binds.craft-all")
    public static EmiBind craftAll;
    @Comment(value="When on a stack with an associated recipe:\nMove ingredients for a single result and put in inventory if possible.")
    @ConfigValue(value="binds.craft-one-to-inventory")
    public static EmiBind craftOneToInventory;
    @Comment(value="When on a stack with an associated recipe:\nMove ingredients for as many results as possible and put in inventory if possible.")
    @ConfigValue(value="binds.craft-all-to-inventory")
    public static EmiBind craftAllToInventory;
    @Comment(value="When on a stack with an associated recipe:\nMove ingredients for a single result and put in cursor if possible.")
    @ConfigValue(value="binds.craft-one-to-cursor")
    public static EmiBind craftOneToCursor;
    @ConfigGroupEnd
    @Comment(value="Display the recipe that will be used to craft on a stack with no recipe context.")
    @ConfigValue(value="binds.show-craft")
    public static EmiBind showCraft;
    @ConfigGroup(value="binds.cheats")
    @Comment(value="Cheat in one of an item into the inventory.")
    @ConfigValue(value="binds.cheat-one-to-inventory")
    public static EmiBind cheatOneToInventory;
    @Comment(value="Cheat in a stack of an item into the inventory.")
    @ConfigValue(value="binds.cheat-stack-to-inventory")
    public static EmiBind cheatStackToInventory;
    @Comment(value="Cheat in one of an item into the cursor.")
    @ConfigValue(value="binds.cheat-one-to-cursor")
    public static EmiBind cheatOneToCursor;
    @Comment(value="Cheat in a stack of an item into the cursor.")
    @ConfigValue(value="binds.cheat-stack-to-cursor")
    public static EmiBind cheatStackToCursor;
    @ConfigGroupEnd
    @Comment(value="Delete the stack in the cursor when hovering the index")
    @ConfigValue(value="binds.delete-cursor-stack")
    public static EmiBind deleteCursorStack;
    @Comment(value="Copies the hovered recipe's ID to the clipboard")
    @ConfigValue(value="binds.copy-recipe-id")
    public static EmiBind copyId;
    @Comment(value="In edit mode, hide the hovered stack")
    @ConfigValue(value="binds.hide-stack")
    public static EmiBind hideStack;
    @Comment(value="In edit mode, hide stacks with the hovered stack's id")
    @ConfigValue(value="binds.hide-stack-by-id")
    public static EmiBind hideStackById;
    @Comment(value="Whether development functions should be enabled. Not recommended for general play.")
    @ConfigValue(value="dev.dev-mode")
    public static boolean devMode;
    @Comment(value="Whether editing the index is enabled")
    @ConfigValue(value="dev.edit-mode")
    public static boolean editMode;
    @Comment(value="Whether to log untranslated tags as warnings.")
    @ConfigValue(value="dev.log-untranslated-tags")
    public static boolean logUntranslatedTags;
    @Comment(value="Whether to log ingredients that don't have a representative tag as warnings.")
    @ConfigValue(value="dev.log-non-tag-ingredients")
    public static boolean logNonTagIngredients;
    @Comment(value="Whether hovering the output of a recipe should show the recipe's EMI ID.")
    @ConfigValue(value="dev.show-recipe-ids")
    public static boolean showRecipeIds;
    @Comment(value="Whether to display additional widgets added to recipes from other mods.\nThese are typically developer facing and compatibility related, and not useful for players.")
    @ConfigValue(value="dev.show-recipe-decorators")
    public static boolean showRecipeDecorators;
    @Comment(value="Whether stacks in the index should display a highlight if they have a recipe default.")
    @ConfigValue(value="dev.highlight-defaulted")
    public static boolean highlightDefaulted;
    @Comment(value="Whether to display exclusion areas")
    @ConfigValue(value="dev.highlight-exclusion-areas")
    public static boolean highlightExclusionAreas;

    public static void loadConfig() {
        try {
            File config;
            QDCSS css;
            File global = new File(EmiConfig.getGlobalFolder(), "global.css");
            if (global.exists() && global.isFile() && (css = QDCSS.load(global)).containsKey("global.use-global") && css.get("global.use-global").get().equals("true")) {
                useGlobalConfig = true;
            }
            if ((config = EmiConfig.getConfigFile()).exists() && config.isFile()) {
                QDCSS css2 = QDCSS.load(config);
                EmiConfig.loadConfig(css2);
            } else {
                File defaultConfig = new File(EmiAgnos.getConfigDirectory().getParent().toFile(), "defaultconfigs/emi.css");
                if (defaultConfig.exists() && defaultConfig.isFile()) {
                    QDCSS css3 = QDCSS.load(defaultConfig);
                    EmiConfig.loadConfig(css3);
                }
            }
            if (startupConfig == null) {
                startupConfig = EmiConfig.getSavedConfig();
            }
            EmiConfig.writeConfig();
        }
        catch (Exception e) {
            EmiLog.error("Error reading config");
            e.printStackTrace();
        }
    }

    public static void setGlobalState(boolean useGlobal) {
        try {
            File folder = EmiConfig.getGlobalFolder();
            folder.mkdirs();
            File global = new File(folder, "global.css");
            FileWriter writer = new FileWriter(global);
            writer.write("#global {\n\tuse-global: " + useGlobal + ";\n}\n");
            writer.close();
            useGlobalConfig = useGlobal;
            File emi = EmiConfig.getConfigFile();
            if (!emi.exists()) {
                emi.createNewFile();
                EmiConfig.writeConfig();
            } else {
                EmiConfig.loadConfig();
            }
        }
        catch (Exception e) {
            EmiLog.error("Error writing global config");
            e.printStackTrace();
        }
    }

    public static void loadConfig(QDCSS css) {
        try {
            HashSet consumed = Sets.newHashSet();
            for (Field field : EmiConfig.class.getFields()) {
                ConfigValue annot = field.getAnnotation(ConfigValue.class);
                if (annot == null || !css.containsKey(annot.value())) continue;
                consumed.add(annot.value());
                EmiConfig.assignField(css, annot.value(), field);
            }
            for (String key : css.keySet()) {
                if (consumed.contains(key)) continue;
                unparsed.put(key, css.getAll(key));
            }
        }
        catch (Exception e) {
            EmiLog.error("Error reading config");
            e.printStackTrace();
        }
    }

    public static void writeConfig() {
        try {
            FileWriter writer = new FileWriter(EmiConfig.getConfigFile());
            writer.write(EmiConfig.getSavedConfig());
            writer.close();
        }
        catch (Exception e) {
            EmiLog.error("Error writing config");
            e.printStackTrace();
        }
    }

    public static String getSavedConfig() {
        LinkedHashMap unparsed = Maps.newLinkedHashMap();
        class_5225 wrapper = new class_5225((point, style) -> 1.0f);
        for (Field field : EmiConfig.class.getFields()) {
            ConfigValue annot = field.getAnnotation(ConfigValue.class);
            if (annot == null) continue;
            String[] parts = annot.value().split("\\.");
            String group = parts[0];
            String key = parts[1];
            Comment comment = field.getAnnotation(Comment.class);
            Object commentText = "";
            if (comment != null) {
                commentText = (String)commentText + "\t/**\n";
                for (class_5348 line : wrapper.method_27498(comment.value(), 80, class_2583.field_24360)) {
                    commentText = (String)commentText + "\t * ";
                    commentText = (String)commentText + line.getString();
                    commentText = (String)commentText + "\n";
                }
                commentText = (String)commentText + "\t */\n";
            }
            Object text = commentText;
            try {
                text = (String)text + EmiConfig.writeField(key, field);
            }
            catch (Exception e) {
                EmiLog.error("Error serializing config");
                e.printStackTrace();
            }
            unparsed.computeIfAbsent(group, g -> Lists.newArrayList()).add(text);
        }
        for (Map.Entry entry : EmiConfig.unparsed.entrySet()) {
            String[] parts = ((String)entry.getKey()).split("\\.");
            String group = parts[0];
            String key = parts[1];
            for (String value : (List)entry.getValue()) {
                unparsed.computeIfAbsent(group, g -> Lists.newArrayList()).add("\t/** unparsed */\n\t" + key + ": " + value + ";\n");
            }
        }
        Object ret = "";
        ret = (String)ret + "/** EMI Config */\n\n";
        boolean bl = true;
        for (Map.Entry category : unparsed.entrySet()) {
            boolean bl2;
            if (!bl2) {
                ret = (String)ret + "\n";
            }
            bl2 = false;
            ret = (String)ret + "#" + (String)category.getKey() + " {\n";
            ret = (String)ret + Strings.join((Iterable)((Iterable)category.getValue()), (String)"\n");
            ret = (String)ret + "}\n";
        }
        return ret;
    }

    private static File getConfigFile() {
        String s = System.getProperty("emi.config");
        if (s != null) {
            File f = new File(s);
            if (f.exists() && f.isFile()) {
                return f;
            }
            EmiLog.error("System property 'emi.config' set to '" + s + "' but does not point to real file, using default config.");
        }
        if (useGlobalConfig) {
            return new File(EmiConfig.getGlobalFolder(), "emi.css");
        }
        return new File(EmiAgnos.getConfigDirectory().toFile(), "emi.css");
    }

    private static File getGlobalFolder() {
        String s = switch (class_156.method_668()) {
            case class_156.class_158.field_1133 -> System.getenv("APPDATA") + "/.minecraft";
            case class_156.class_158.field_1137 -> System.getProperty("user.home") + "/Library/Application Support/minecraft";
            default -> System.getProperty("user.home") + "/.minecraft";
        };
        return new File(s + "/global/emi");
    }

    private static void assignField(QDCSS css, String annot, Field field) throws IllegalAccessException {
        Class<?> type = field.getType();
        Setter setter = SETTERS.get(type);
        if (setter != null) {
            setter.setValue(css, annot, field);
        } else if (ConfigEnum.class.isAssignableFrom(type)) {
            SETTERS.get(ConfigEnum.class).setValue(css, annot, field);
        } else {
            throw new RuntimeException("[emi] Unknown parsing type: " + type);
        }
    }

    private static String writeField(String key, Field field) throws IllegalAccessException {
        Object text = "";
        Class<?> type = field.getType();
        if (MULTI_WRITERS.containsKey(type)) {
            for (String line : MULTI_WRITERS.get(type).writeValue(field.get(null))) {
                text = (String)text + "\t" + key + ": " + line + ";\n";
            }
        } else if (WRITERS.containsKey(type)) {
            text = (String)text + "\t" + key + ": " + WRITERS.get(type).writeValue(field.get(null)) + ";\n";
        } else if (ConfigEnum.class.isAssignableFrom(type)) {
            text = (String)text + "\t" + key + ": " + WRITERS.get(ConfigEnum.class).writeValue(field.get(null)) + ";\n";
        }
        return text;
    }

    private static void defineType(Class<?> clazz, Setter setter, Writer<?> writer) {
        SETTERS.put(clazz, setter);
        WRITERS.put(clazz, writer);
    }

    private static void defineType(Class<?> clazz, Setter setter) {
        EmiConfig.defineType(clazz, setter, field -> field.toString());
    }

    private static void defineMultiType(Class<?> clazz, Setter setter, MultiWriter<?> writer) {
        SETTERS.put(clazz, setter);
        MULTI_WRITERS.put(clazz, writer);
    }

    static {
        useGlobalConfig = false;
        enabled = true;
        cheatMode = false;
        helpLevel = HelpLevel.NORMAL;
        indexSource = IndexSource.CREATIVE;
        searchTooltipByDefault = true;
        searchModNameByDefault = false;
        searchTagsByDefault = false;
        recipeBookAction = RecipeBookAction.TOGGLE_CRAFTABLES;
        effectLocation = EffectLocation.TOP;
        showHoverOverlay = true;
        appendModId = true;
        appendItemModId = true;
        miscraftPrevention = true;
        fluidUnit = EmiAgnos.isForge() ? FluidUnit.MILLIBUCKETS : FluidUnit.LITERS;
        useBatchedRenderer = true;
        centerSearchBar = true;
        searchSidebarFocusFilter = type -> type != SidebarType.CHESS;
        searchSidebarFocus = SidebarType.INDEX;
        emptySearchSidebarFocusFilter = type -> type != SidebarType.CHESS;
        emptySearchSidebarFocus = SidebarType.NONE;
        maximumRecipeScreenHeight = 256;
        minimumRecipeScreenWidth = 176;
        verticalMargin = 20;
        workstationLocationFilter = side -> side != SidebarSide.TOP;
        workstationLocation = SidebarSide.BOTTOM;
        showCostPerBatch = true;
        recipeDefaultButton = true;
        recipeTreeButton = true;
        recipeFillButton = true;
        recipeScreenshotButton = false;
        recipeScreenshotScale = 0;
        leftSidebarPages = new SidebarPages(List.of(new SidebarPages.SidebarPage(SidebarType.FAVORITES)), SidebarSettings.LEFT);
        leftSidebarSubpanels = new SidebarSubpanels(List.of(), SidebarSettings.LEFT);
        leftSidebarSize = new IntGroup("emi.sidebar.size.", List.of("columns", "rows"), IntList.of((int)12, (int)100));
        leftSidebarMargins = new Margins(2, 2, 2, 2);
        leftSidebarAlign = new ScreenAlign(ScreenAlign.Horizontal.LEFT, ScreenAlign.Vertical.TOP);
        leftSidebarHeader = HeaderType.VISIBLE;
        leftSidebarTheme = SidebarTheme.TRANSPARENT;
        rightSidebarPages = new SidebarPages(List.of(new SidebarPages.SidebarPage(SidebarType.INDEX), new SidebarPages.SidebarPage(SidebarType.CRAFTABLES)), SidebarSettings.RIGHT);
        rightSidebarSubpanels = new SidebarSubpanels(List.of(), SidebarSettings.RIGHT);
        rightSidebarSize = new IntGroup("emi.sidebar.size.", List.of("columns", "rows"), IntList.of((int)12, (int)100));
        rightSidebarMargins = new Margins(2, 2, 2, 2);
        rightSidebarAlign = new ScreenAlign(ScreenAlign.Horizontal.RIGHT, ScreenAlign.Vertical.TOP);
        rightSidebarHeader = HeaderType.VISIBLE;
        rightSidebarTheme = SidebarTheme.TRANSPARENT;
        topSidebarPages = new SidebarPages(List.of(), SidebarSettings.TOP);
        topSidebarSubpanels = new SidebarSubpanels(List.of(), SidebarSettings.TOP);
        topSidebarSize = new IntGroup("emi.sidebar.size.", List.of("columns", "rows"), IntList.of((int)9, (int)9));
        topSidebarMargins = new Margins(2, 2, 2, 2);
        topSidebarAlign = new ScreenAlign(ScreenAlign.Horizontal.CENTER, ScreenAlign.Vertical.CENTER);
        topSidebarHeader = HeaderType.VISIBLE;
        topSidebarTheme = SidebarTheme.TRANSPARENT;
        bottomSidebarPages = new SidebarPages(List.of(), SidebarSettings.BOTTOM);
        bottomSidebarSubpanels = new SidebarSubpanels(List.of(), SidebarSettings.BOTTOM);
        bottomSidebarSize = new IntGroup("emi.sidebar.size.", List.of("columns", "rows"), IntList.of((int)9, (int)9));
        bottomSidebarMargins = new Margins(2, 2, 2, 2);
        bottomSidebarAlign = new ScreenAlign(ScreenAlign.Horizontal.CENTER, ScreenAlign.Vertical.CENTER);
        bottomSidebarHeader = HeaderType.VISIBLE;
        bottomSidebarTheme = SidebarTheme.TRANSPARENT;
        toggleVisibility = new EmiBind("key.emi.toggle_visibility", 1, 79);
        focusSearch = new EmiBind("key.emi.focus_search", 1, 70);
        clearSearch = new EmiBind("key.emi.clear_search", class_3675.field_16237.method_1444());
        viewRecipes = new EmiBind("key.emi.view_recipes", new EmiBind.ModifiedKey(class_3675.class_307.field_1668.method_1447(82), 0), new EmiBind.ModifiedKey(class_3675.class_307.field_1672.method_1447(0), 0));
        viewUses = new EmiBind("key.emi.view_uses", new EmiBind.ModifiedKey(class_3675.class_307.field_1668.method_1447(85), 0), new EmiBind.ModifiedKey(class_3675.class_307.field_1672.method_1447(1), 0));
        favorite = new EmiBind("key.emi.favorite", 65);
        defaultStack = new EmiBind("key.emi.default_stack", new EmiBind.ModifiedKey(class_3675.class_307.field_1672.method_1447(0), 1));
        viewStackTree = new EmiBind("key.emi.view_stack_tree", class_3675.field_16237.method_1444());
        viewTree = new EmiBind("key.emi.view_tree", class_3675.field_16237.method_1444());
        back = new EmiBind("key.emi.back", 259);
        forward = new EmiBind("key.emi.forward", class_3675.field_16237.method_1444());
        craftOne = new EmiBind("key.emi.craft_one", new EmiBind.ModifiedKey(class_3675.class_307.field_1672.method_1447(0), 0));
        craftAll = new EmiBind("key.emi.craft_all", new EmiBind.ModifiedKey(class_3675.class_307.field_1672.method_1447(0), 4));
        craftOneToInventory = new EmiBind("key.emi.craft_one_to_inventory", class_3675.field_16237.method_1444());
        craftAllToInventory = new EmiBind("key.emi.craft_all_to_inventory", class_3675.field_16237.method_1444());
        craftOneToCursor = new EmiBind("key.emi.craft_one_to_cursor", new EmiBind.ModifiedKey(class_3675.class_307.field_1672.method_1447(0), 1));
        showCraft = new EmiBind("key.emi.show_craft", 340);
        cheatOneToInventory = new EmiBind("key.emi.cheat_one_to_inventory", new EmiBind.ModifiedKey(class_3675.class_307.field_1672.method_1447(1), 1));
        cheatStackToInventory = new EmiBind("key.emi.cheat_stack_to_inventory", new EmiBind.ModifiedKey(class_3675.class_307.field_1672.method_1447(0), 1));
        cheatOneToCursor = new EmiBind("key.emi.cheat_one_to_cursor", new EmiBind.ModifiedKey(class_3675.class_307.field_1672.method_1447(2), 1));
        cheatStackToCursor = new EmiBind("key.emi.cheat_stack_to_cursor", class_3675.field_16237.method_1444());
        deleteCursorStack = new EmiBind("key.emi.delete_cursor_stack", new EmiBind.ModifiedKey(class_3675.class_307.field_1672.method_1447(0), 0));
        copyId = new EmiBind("key.emi.copy_recipe_id", class_3675.field_16237.method_1444());
        hideStack = new EmiBind("key.emi.hide_stack", new EmiBind.ModifiedKey(class_3675.class_307.field_1672.method_1447(0), 1));
        hideStackById = new EmiBind("key.emi.hide_stack_by_id", new EmiBind.ModifiedKey(class_3675.class_307.field_1672.method_1447(0), 5));
        devMode = EmiAgnos.isDevelopmentEnvironment();
        editMode = false;
        logUntranslatedTags = EmiAgnos.isDevelopmentEnvironment();
        logNonTagIngredients = false;
        showRecipeIds = false;
        showRecipeDecorators = EmiAgnos.isDevelopmentEnvironment();
        highlightDefaulted = false;
        highlightExclusionAreas = false;
        EmiConfig.defineType(Boolean.TYPE, (css, annot, field) -> field.setBoolean(null, css.getBoolean(annot).get()));
        EmiConfig.defineType(Integer.TYPE, (css, annot, field) -> field.setInt(null, css.getInt(annot).get()));
        EmiConfig.defineType(Double.TYPE, (css, annot, field) -> field.setDouble(null, css.getDouble(annot).get()));
        EmiConfig.defineType(String.class, (css, annot, field) -> {
            String s = css.get(annot).get();
            s = s.substring(1, s.length() - 1);
            field.set(null, s);
        }, field -> "\"" + field + "\"");
        EmiConfig.defineMultiType(EmiBind.class, (css, annot, field) -> {
            ArrayList strings = Lists.newArrayList(css.getAll(annot));
            for (int i = 0; i < strings.size(); ++i) {
                String s = (String)strings.get(i);
                strings.set(i, s.substring(1, s.length() - 1));
            }
            ((EmiBind)field.get(null)).setKey(strings);
        }, field -> {
            ArrayList list = Lists.newArrayList();
            for (EmiBind.ModifiedKey key : field.boundKeys) {
                if (key.isUnbound() && field.boundKeys.size() != 1) continue;
                list.add("\"" + key.toName() + "\"");
            }
            return list;
        });
        EmiConfig.defineType(ScreenAlign.class, (css, annot, field) -> {
            String[] parts = css.get(annot).get().split(",");
            if (parts.length == 2) {
                ((ScreenAlign)field.get(null)).horizontal = ScreenAlign.Horizontal.fromName(parts[0].strip());
                ((ScreenAlign)field.get(null)).vertical = ScreenAlign.Vertical.fromName(parts[1].strip());
            } else {
                ((ScreenAlign)field.get(null)).horizontal = ScreenAlign.Horizontal.CENTER;
                ((ScreenAlign)field.get(null)).vertical = ScreenAlign.Vertical.CENTER;
            }
        }, field -> field.horizontal.getName() + ", " + field.vertical.getName());
        EmiConfig.defineType(SidebarPages.class, (css, annot, field) -> {
            String[] parts = css.get(annot).get().split(",");
            SidebarPages pages = (SidebarPages)field.get(null);
            pages.pages.clear();
            for (String s : parts) {
                pages.pages.add(new SidebarPages.SidebarPage(SidebarType.fromName(s.trim().toLowerCase())));
            }
            pages.unique();
        }, field -> {
            if (field.pages.isEmpty()) {
                return "none";
            }
            return field.pages.stream().map(p -> p.type.getName()).collect(Collectors.joining(", "));
        });
        EmiConfig.defineType(SidebarSubpanels.class, (css, annot, field) -> {
            String[] parts = css.get(annot).get().split(",");
            SidebarSubpanels subpanels = (SidebarSubpanels)field.get(null);
            subpanels.subpanels.clear();
            for (String s : parts) {
                int rows;
                String[] subparts = s.trim().split("\\s+");
                SidebarType type = SidebarType.fromName(subparts[0].toLowerCase());
                int n = rows = subparts.length > 1 ? Integer.parseInt(subparts[1]) : 1;
                if (rows < 1) continue;
                subpanels.subpanels.add(new SidebarSubpanels.Subpanel(type, rows));
            }
            subpanels.unique();
        }, field -> {
            if (field.subpanels.isEmpty()) {
                return "none";
            }
            return field.subpanels.stream().map(p -> p.type.getName() + " " + p.rows).collect(Collectors.joining(", "));
        });
        EmiConfig.defineType(IntGroup.class, (css, annot, field) -> ((IntGroup)field.get(null)).deserialize(css.get(annot).get()), group -> group.serialize());
        EmiConfig.defineType(Margins.class, (css, annot, field) -> ((Margins)field.get(null)).deserialize(css.get(annot).get()), group -> group.serialize());
        EmiConfig.defineType(ConfigEnum.class, (css, annot, field) -> {
            String name = css.get(annot).get();
            for (ConfigEnum e : (ConfigEnum[])field.getType().getEnumConstants()) {
                if (!e.getName().equals(name)) continue;
                field.set(null, e);
                break;
            }
        }, c -> c.getName());
        try {
            for (Field field2 : EmiConfig.class.getDeclaredFields()) {
                ConfigFilter annot2 = field2.getAnnotation(ConfigFilter.class);
                if (annot2 == null) continue;
                Predicate predicate = (Predicate)field2.get(null);
                FILTERS.put(annot2.value(), predicate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DEFAULT_CONFIG = EmiConfig.getSavedConfig();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ConfigValue {
        public String value();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Comment {
        public String value();
    }

    private static interface Setter {
        public void setValue(QDCSS var1, String var2, Field var3) throws IllegalAccessException;
    }

    private static interface MultiWriter<T> {
        public List<String> writeValue(T var1);
    }

    private static interface Writer<T> {
        public String writeValue(T var1);
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ConfigFilter {
        public String value();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ConfigGroupEnd {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ConfigGroup {
        public String value();
    }
}

