/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.sound.OnePerPlayerSounds;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class AttachmentSound {
    public static final AttachmentSound NONE = new AttachmentSound(null, 0.0f, 0.0f, null, 0.0f, 0.0f);
    public static final AttachmentSound FILM = new AttachmentSound(Exposure.SoundEvents.FILM_ADVANCING, 0.9f, 1.0f, Exposure.SoundEvents.FILM_REMOVED, 0.7f, 1.0f);
    public static final AttachmentSound FLASH = new AttachmentSound(Exposure.SoundEvents.CAMERA_GENERIC_CLICK, 0.6f, 1.15f, Exposure.SoundEvents.CAMERA_GENERIC_CLICK, 0.35f, 0.95f);
    public static final AttachmentSound LENS = new AttachmentSound(Exposure.SoundEvents.LENS_INSERT, 1.0f, 1.0f, Exposure.SoundEvents.LENS_REMOVE, 1.0f, 1.0f);
    public static final AttachmentSound FILTER = new AttachmentSound(Exposure.SoundEvents.FILTER_INSERT, 0.8f, 1.0f, Exposure.SoundEvents.FILTER_REMOVE, 0.5f, 1.0f);
    @Nullable
    private final Supplier<class_3414> inserted;
    private final float insertedVolume;
    private final float insertedPitch;
    @Nullable
    private final Supplier<class_3414> removed;
    private final float removedVolume;
    private final float removedPitch;

    public AttachmentSound(@Nullable Supplier<class_3414> inserted, float insertedVolume, float insertedPitch, @Nullable Supplier<class_3414> removed, float removedVolume, float removedPitch) {
        this.inserted = inserted;
        this.insertedVolume = insertedVolume;
        this.insertedPitch = insertedPitch;
        this.removed = removed;
        this.removedVolume = removedVolume;
        this.removedPitch = removedPitch;
    }

    public AttachmentSound(@Nullable Supplier<class_3414> inserted, float insertedVolume, float insertedPitch) {
        this.inserted = inserted;
        this.insertedVolume = insertedVolume;
        this.insertedPitch = insertedPitch;
        this.removed = null;
        this.removedVolume = 1.0f;
        this.removedPitch = 1.0f;
    }

    public void playOnePerPlayer(class_1657 player, boolean isRemoved) {
        Supplier<class_3414> sound;
        Supplier<class_3414> supplier = sound = isRemoved ? this.getRemoved() : this.getInserted();
        if (sound != null) {
            OnePerPlayerSounds.play(player, sound.get(), class_3419.field_15248, isRemoved ? this.getRemovedVolume() : this.getInsertedVolume(), isRemoved ? this.getRemovedPitch() : this.getInsertedPitch());
        }
    }

    @Nullable
    public Supplier<class_3414> getInserted() {
        return this.inserted;
    }

    public float getInsertedVolume() {
        return this.insertedVolume;
    }

    public float getInsertedPitch() {
        return this.insertedPitch;
    }

    @Nullable
    public Supplier<class_3414> getRemoved() {
        return this.removed;
    }

    public float getRemovedVolume() {
        return this.removedVolume;
    }

    public float getRemovedPitch() {
        return this.removedPitch;
    }
}

