/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.recipe.AbstractNbtTransferringRecipe;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;

public class FilmDevelopingRecipe
extends AbstractNbtTransferringRecipe {
    public FilmDevelopingRecipe(class_2960 id, class_1856 filmIngredient, class_2371<class_1856> ingredients, class_1799 result) {
        super(id, filmIngredient, ingredients, result);
    }

    @NotNull
    public class_1865<?> method_8119() {
        return Exposure.RecipeSerializers.FILM_DEVELOPING.get();
    }

    @NotNull
    public class_2371<class_1799> getRemainingItems(@NotNull class_8566 container) {
        class_2371 remainingItems = super.method_8111((class_1263)container);
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 item = container.method_5438(i);
            if (item.method_7909() instanceof class_1812) {
                remainingItems.set(i, (Object)new class_1799((class_1935)class_1802.field_8469));
                continue;
            }
            if (!item.method_7909().method_7857()) continue;
            remainingItems.set(i, (Object)new class_1799((class_1935)Objects.requireNonNull(item.method_7909().method_7858())));
        }
        return remainingItems;
    }

    public static class Serializer
    implements class_1865<FilmDevelopingRecipe> {
        @NotNull
        public FilmDevelopingRecipe fromJson(class_2960 recipeId, JsonObject serializedRecipe) {
            class_1856 filmIngredient = class_1856.method_52177((JsonElement)class_3518.method_52226((JsonObject)serializedRecipe, (String)"film"));
            class_2371<class_1856> ingredients = this.getIngredients(class_3518.method_15261((JsonObject)serializedRecipe, (String)"ingredients"));
            class_1799 result = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)serializedRecipe, (String)"result"));
            if (filmIngredient.method_8103()) {
                throw new JsonParseException("Recipe should have 'film' ingredient.");
            }
            return new FilmDevelopingRecipe(recipeId, filmIngredient, ingredients, result);
        }

        @NotNull
        public FilmDevelopingRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            class_1856 transferredIngredient = class_1856.method_8086((class_2540)buffer);
            int ingredientsCount = buffer.method_10816();
            class_2371 ingredients = class_2371.method_10213((int)ingredientsCount, (Object)class_1856.field_9017);
            ingredients.replaceAll(ignored -> class_1856.method_8086((class_2540)buffer));
            class_1799 result = buffer.method_10819();
            return new FilmDevelopingRecipe(recipeId, transferredIngredient, (class_2371<class_1856>)ingredients, result);
        }

        public void toNetwork(class_2540 buffer, FilmDevelopingRecipe recipe) {
            recipe.getTransferIngredient().method_8088(buffer);
            buffer.method_10804(recipe.method_8117().size());
            for (class_1856 ingredient : recipe.method_8117()) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(recipe.getResult());
        }

        private class_2371<class_1856> getIngredients(JsonArray jsonArray) {
            class_2371 ingredients = class_2371.method_10211();
            for (int i = 0; i < jsonArray.size(); ++i) {
                class_1856 ingredient = class_1856.method_52177((JsonElement)jsonArray.get(i));
                if (ingredient.method_8103()) continue;
                ingredients.add((Object)ingredient);
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for a recipe.");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for a recipe. The maximum is 9.");
            }
            return ingredients;
        }
    }
}

