/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.client;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.platform.Services;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1074;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModVersionPlaceholder
extends Placeholder {
    public ModVersionPlaceholder() {
        super("modversion");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        if (!dps.values.containsKey("modid")) {
            return null;
        }
        return this.getModVersion(dps.values.get("modid"));
    }

    private String getModVersion(String modid) {
        return Services.PLATFORM.getModVersion(modid);
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("modid");
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"fancymenu.editor.dynamicvariabletextfield.variables.modversion", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.dynamicvariabletextfield.variables.modversion.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662((String)"fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.client", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("modid", "some_mod_id");
        return DeserializedPlaceholderString.build(this.getIdentifier(), m);
    }
}

