/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry;

import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import java.awt.Color;
import net.minecraft.class_1144;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import org.jetbrains.annotations.NotNull;

public abstract class ScrollAreaEntry
extends UIBase
implements class_4068 {
    public ScrollArea parent;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    public AdvancedButton buttonBase;
    protected Color backgroundColorIdle;
    protected Color backgroundColorHover;
    protected boolean selectable;
    protected boolean selected;
    protected boolean playClickSound;
    public boolean deselectOtherEntriesOnSelect;
    public boolean selectOnClick;
    public int index;

    public ScrollAreaEntry(ScrollArea parent, int width, int height) {
        this.backgroundColorIdle = UIBase.getUIColorTheme().area_background_color.getColor();
        this.backgroundColorHover = UIBase.getUIColorTheme().list_entry_color_selected_hovered.getColor();
        this.selectable = true;
        this.selected = false;
        this.playClickSound = true;
        this.deselectOtherEntriesOnSelect = true;
        this.selectOnClick = true;
        this.index = 0;
        this.parent = parent;
        this.width = width;
        this.height = height;
        this.buttonBase = new AdvancedButton(0, 0, 0, 0, "", true, button -> {
            if (this.selectOnClick) {
                this.setSelected(true);
            }
            this.onClick(this);
        }){

            public void method_25354(@NotNull class_1144 p_93665_) {
                if (ScrollAreaEntry.this.playClickSound) {
                    super.method_25354(p_93665_);
                }
            }

            public void method_25394(@NotNull class_332 graphics, int p_93658_, int p_93659_, float p_93660_) {
                if (ScrollAreaEntry.this.parent.isMouseInteractingWithGrabbers() || !ScrollAreaEntry.this.parent.isMouseInsideArea()) {
                    this.field_22762 = false;
                }
                super.method_25394(graphics, p_93658_, p_93659_, p_93660_);
            }

            public boolean method_25367() {
                if (ScrollAreaEntry.this.parent.isMouseInteractingWithGrabbers() || !ScrollAreaEntry.this.parent.isMouseInsideArea()) {
                    return false;
                }
                return super.method_25367();
            }

            public void method_25348(double p_93371_, double p_93372_) {
                if (ScrollAreaEntry.this.parent.isMouseInteractingWithGrabbers() || !ScrollAreaEntry.this.parent.isMouseInsideArea()) {
                    return;
                }
                super.method_25348(p_93371_, p_93372_);
            }
        };
        this.updateEntry();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partial) {
        this.updateEntry();
        this.buttonBase.method_25394(graphics, mouseX, mouseY, partial);
    }

    public abstract void onClick(ScrollAreaEntry var1);

    public void updateEntry() {
        this.buttonBase.method_46421(this.x);
        this.buttonBase.method_46419(this.y);
        this.buttonBase.method_25358(this.width);
        ((IMixinAbstractWidget)this.buttonBase).setHeightFancyMenu(this.height);
        if (!this.isSelected()) {
            this.buttonBase.setBackgroundColor(this.backgroundColorIdle, this.backgroundColorHover, this.backgroundColorIdle, this.backgroundColorHover, 1);
        } else {
            this.buttonBase.setBackgroundColor(this.backgroundColorHover, this.backgroundColorHover, this.backgroundColorHover, this.backgroundColorHover, 1);
        }
    }

    public void setX(int x) {
        this.x = x;
        this.updateEntry();
    }

    public int getX() {
        return this.x;
    }

    public void setY(int y) {
        this.y = y;
        this.updateEntry();
    }

    public int getY() {
        return this.y;
    }

    public void setWidth(int width) {
        this.width = width;
        this.updateEntry();
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
        this.updateEntry();
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isHovered() {
        return this.buttonBase.method_49606();
    }

    public boolean isSelected() {
        return this.selectable && this.selected;
    }

    public void setSelected(boolean selected) {
        if (this.selectable) {
            this.selected = selected;
            this.updateEntry();
            if (selected && this.deselectOtherEntriesOnSelect) {
                for (ScrollAreaEntry e : this.parent.getEntries()) {
                    if (e == this) continue;
                    e.setSelected(false);
                }
            }
        }
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
        if (!selectable) {
            this.selected = false;
        }
    }

    public void setPlayClickSound(boolean playClickSound) {
        this.playClickSound = playClickSound;
    }

    public boolean isPlayClickSound() {
        return this.playClickSound;
    }

    public Color getBackgroundColorIdle() {
        return this.backgroundColorIdle;
    }

    public void setBackgroundColorIdle(Color backgroundColorIdle) {
        this.backgroundColorIdle = backgroundColorIdle;
        this.updateEntry();
    }

    public Color getBackgroundColorHover() {
        return this.backgroundColorHover;
    }

    public void setBackgroundColorHover(Color backgroundColorHover) {
        this.backgroundColorHover = backgroundColorHover;
        this.updateEntry();
    }

    public void setTooltip(String ... tooltipLines) {
        this.buttonBase.setDescription(tooltipLines);
    }
}

