/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.network.message.handshake;

import com.mrcrayfish.framework.Constants;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.HandshakeMessage;
import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.mrcrayfish.framework.entity.sync.SyncedEntityData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;

public class S2CSyncedEntityData
extends HandshakeMessage<S2CSyncedEntityData> {
    private Map<class_2960, List<Pair<class_2960, Integer>>> keyMap;

    public S2CSyncedEntityData() {
    }

    private S2CSyncedEntityData(Map<class_2960, List<Pair<class_2960, Integer>>> keyMap) {
        this.keyMap = keyMap;
    }

    @Override
    public void encode(S2CSyncedEntityData message, class_2540 buffer) {
        Set<SyncedDataKey<?, ?>> keys = SyncedEntityData.instance().getKeys();
        buffer.writeInt(keys.size());
        keys.forEach(key -> {
            int id = SyncedEntityData.instance().getInternalId((SyncedDataKey<?, ?>)key);
            buffer.method_10812(key.classKey().id());
            buffer.method_10812(key.id());
            buffer.method_10804(id);
        });
    }

    @Override
    public S2CSyncedEntityData decode(class_2540 buffer) {
        int size = buffer.readInt();
        HashMap<class_2960, List<Pair<class_2960, Integer>>> keyMap = new HashMap<class_2960, List<Pair<class_2960, Integer>>>();
        for (int i = 0; i < size; ++i) {
            class_2960 classId = buffer.method_10810();
            class_2960 keyId = buffer.method_10810();
            int id = buffer.method_10816();
            keyMap.computeIfAbsent(classId, c -> new ArrayList()).add(Pair.of((Object)keyId, (Object)id));
        }
        return new S2CSyncedEntityData(keyMap);
    }

    @Override
    public void handle(S2CSyncedEntityData message, MessageContext context) {
        Constants.LOG.debug(HANDSHAKE, "Received synced key mappings from server");
        CountDownLatch block = new CountDownLatch(1);
        context.execute(() -> {
            if (!SyncedEntityData.instance().updateMappings(message)) {
                context.getNetworkManager().method_10747((class_2561)class_2561.method_43470((String)"Connection closed - [Framework] Received unknown synced data keys. See logs for more details."));
            }
            block.countDown();
        });
        try {
            block.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        context.setHandled(true);
        context.reply(new HandshakeMessage.Acknowledge());
    }

    public Map<class_2960, List<Pair<class_2960, Integer>>> getKeyMap() {
        return this.keyMap;
    }
}

