/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.mixin;

import com.faboslav.friendsandfoes.common.client.render.entity.renderer.PlayerIllusionEntityRenderer;
import com.faboslav.friendsandfoes.common.entity.PlayerIllusionEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_898.class})
public abstract class EntityRenderDispatcherMixin {
    private static final Map<String, class_5617<PlayerIllusionEntity>> PLAYER_ILLUSION_RENDERER_FACTORIES = ImmutableMap.of((Object)"default", context -> new PlayerIllusionEntityRenderer(context, false), (Object)"slim", context -> new PlayerIllusionEntityRenderer(context, true));
    @Unique
    private Map<String, class_897<? extends PlayerIllusionEntity>> illusionModelRenderers = ImmutableMap.of();

    @Inject(method={"getRenderer"}, at={@At(value="HEAD")}, cancellable=true)
    public <T extends class_1297> void friendsandfoes_getRenderer(T entity, CallbackInfoReturnable<class_897<? super T>> cir) {
        if (entity instanceof PlayerIllusionEntity) {
            String string = ((PlayerIllusionEntity)entity).getModel();
            class_897<? extends PlayerIllusionEntity> entityRenderer = this.illusionModelRenderers.get(string);
            entityRenderer = entityRenderer != null ? entityRenderer : this.illusionModelRenderers.get("default");
            cir.setReturnValue(entityRenderer);
        }
    }

    @ModifyVariable(method={"reload"}, ordinal=0, at=@At(value="LOAD"))
    public class_5617.class_5618 friendsandfoes_reload(class_5617.class_5618 context) {
        this.illusionModelRenderers = EntityRenderDispatcherMixin.friendsandfoes_reloadPlayerIllusionRenderers(context);
        return context;
    }

    private static Map<String, class_897<? extends PlayerIllusionEntity>> friendsandfoes_reloadPlayerIllusionRenderers(class_5617.class_5618 ctx) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        PLAYER_ILLUSION_RENDERER_FACTORIES.forEach((type, factory) -> {
            try {
                builder.put(type, (Object)factory.create(ctx));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to create player illusion model for " + type, exception);
            }
        });
        return builder.build();
    }
}

