/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.integration.item_filtering;

import dev.ftb.mods.ftbquests.api.ItemFilterAdapter;
import dev.ftb.mods.ftbquests.integration.item_filtering.DisplayStacksCache;
import dev.ftb.mods.ftbquests.util.NBTUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1799;
import net.minecraft.class_2520;

public enum ItemMatchingSystem {
    INSTANCE;

    private final List<ItemFilterAdapter> adapters = new CopyOnWriteArrayList<ItemFilterAdapter>();

    public void registerFilterAdapter(ItemFilterAdapter adapter) {
        this.adapters.add(adapter);
    }

    public boolean isItemFilter(class_1799 stack) {
        return this.getFilterAdapter(stack).isPresent();
    }

    public Optional<ItemFilterAdapter> getFilterAdapter(class_1799 stack) {
        return this.adapters.stream().filter(adapter -> adapter.isFilterStack(stack)).findFirst();
    }

    public boolean doesItemMatch(class_1799 filterStack, class_1799 toCheck, boolean matchNBT, boolean fuzzyNBT) {
        return this.getFilterAdapter(filterStack).map(adapter -> adapter.doesItemMatch(filterStack, toCheck)).orElse(this.areItemStacksEqual(filterStack, toCheck, matchNBT, fuzzyNBT));
    }

    public List<class_1799> getAllMatchingStacks(class_1799 filterStack) {
        ArrayList res = new ArrayList();
        this.adapters.forEach(adapter -> {
            if (adapter.isFilterStack(filterStack)) {
                res.addAll(DisplayStacksCache.getCachedDisplayStacks(filterStack, adapter));
            }
        });
        return res.isEmpty() ? List.of(filterStack) : res;
    }

    private boolean areItemStacksEqual(class_1799 stackA, class_1799 stackB, boolean matchNBT, boolean fuzzyNBT) {
        if (stackA == stackB) {
            return true;
        }
        if (stackA.method_7909() != stackB.method_7909()) {
            return false;
        }
        if (!stackA.method_7985() && !stackB.method_7985()) {
            return true;
        }
        return !matchNBT || NBTUtils.compareNbt((class_2520)stackA.method_7969(), (class_2520)stackB.method_7969(), fuzzyNBT, true);
    }

    public Collection<ItemFilterAdapter> adapters() {
        return Collections.unmodifiableCollection(this.adapters);
    }
}

