/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class CommandReward
extends Reward {
    private static final String DEFAULT_COMMAND = "/say Hi, @p!";
    private String command = "/say Hi, @p!";
    private boolean elevatePerms;
    private boolean silent;

    public CommandReward(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.COMMAND;
    }

    @Override
    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10582("command", this.command);
        if (this.elevatePerms) {
            nbt.method_10556("elevate_perms", true);
        }
        if (this.silent) {
            nbt.method_10556("silent", true);
        }
    }

    @Override
    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.command = nbt.method_10558("command");
        this.elevatePerms = nbt.method_10577("elevate_perms");
        this.silent = nbt.method_10577("silent");
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10788(this.command, Short.MAX_VALUE);
        buffer.writeBoolean(this.elevatePerms);
        buffer.writeBoolean(this.silent);
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.command = buffer.method_10800(Short.MAX_VALUE);
        this.elevatePerms = buffer.readBoolean();
        this.silent = buffer.readBoolean();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("command", this.command, v -> {
            this.command = v;
        }, DEFAULT_COMMAND).setNameKey("ftbquests.reward.ftbquests.command");
        config.addBool("elevate", this.elevatePerms, v -> {
            this.elevatePerms = v;
        }, false);
        config.addBool("silent", this.silent, v -> {
            this.silent = v;
        }, false);
    }

    @Override
    public void claim(class_3222 player, boolean notify) {
        HashMap<String, Object> overrides = new HashMap<String, Object>();
        overrides.put("p", player.method_7334().getName());
        class_2338 pos = player.method_24515();
        overrides.put("x", pos.method_10263());
        overrides.put("y", pos.method_10264());
        overrides.put("z", pos.method_10260());
        if (this.getQuestChapter() != null) {
            overrides.put("chapter", this.getQuestChapter());
        }
        overrides.put("quest", this.quest);
        overrides.put("team", FTBTeamsAPI.api().getManager().getTeamForPlayer(player).map(team -> team.getName().getString()).orElse(player.method_7334().getName()));
        String cmd = this.command;
        for (Map.Entry entry : overrides.entrySet()) {
            if (entry.getValue() == null) continue;
            cmd = cmd.replace("{" + (String)entry.getKey() + "}", entry.getValue().toString());
        }
        class_2168 source = player.method_5671();
        if (this.elevatePerms) {
            source = source.method_9206(2);
        }
        if (this.silent) {
            source = source.method_9217();
        }
        player.field_13995.method_3734().method_44252(source, cmd);
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return class_2561.method_43471((String)"ftbquests.reward.ftbquests.command").method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)this.command).method_27692(class_124.field_1061));
    }
}

