/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.architectury.hooks.item.ItemStackHooks;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import dev.ftb.mods.ftbquests.net.DisplayItemRewardToastMessage;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.util.NBTUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class ItemReward
extends Reward {
    private class_1799 item;
    private int count;
    private int randomBonus;
    private boolean onlyOne;

    public ItemReward(long id, Quest quest, class_1799 is) {
        this(id, quest, is, 1);
    }

    public ItemReward(long id, Quest quest, class_1799 is, int count) {
        super(id, quest);
        this.item = is;
        this.count = count;
        this.randomBonus = 0;
        this.onlyOne = false;
    }

    public ItemReward(long id, Quest quest) {
        this(id, quest, new class_1799((class_1935)class_1802.field_8279));
    }

    public class_1799 getItem() {
        return this.item;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public RewardType getType() {
        return RewardTypes.ITEM;
    }

    @Override
    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        NBTUtils.write(nbt, "item", this.item);
        if (this.count > 1) {
            nbt.method_10569("count", this.count);
        }
        if (this.randomBonus > 0) {
            nbt.method_10569("random_bonus", this.randomBonus);
        }
        if (this.onlyOne) {
            nbt.method_10556("only_one", true);
        }
    }

    @Override
    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.item = NBTUtils.read(nbt, "item");
        this.count = nbt.method_10550("count");
        if (this.count == 0) {
            this.count = this.item.method_7947();
            this.item.method_7939(1);
        }
        this.randomBonus = nbt.method_10550("random_bonus");
        this.onlyOne = nbt.method_10577("only_one");
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        FTBQuestsNetHandler.writeItemType(buffer, this.item);
        buffer.method_10804(this.count);
        buffer.method_10804(this.randomBonus);
        buffer.writeBoolean(this.onlyOne);
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.item = FTBQuestsNetHandler.readItemType(buffer);
        this.count = buffer.method_10816();
        this.randomBonus = buffer.method_10816();
        this.onlyOne = buffer.readBoolean();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addItemStack("item", this.item, v -> {
            this.item = v;
        }, class_1799.field_8037, true, false).setNameKey("ftbquests.reward.ftbquests.item");
        config.addInt("count", this.count, v -> {
            this.count = v;
        }, 1, 1, 8192);
        config.addInt("random_bonus", this.randomBonus, v -> {
            this.randomBonus = v;
        }, 0, 0, 8192).setNameKey("ftbquests.reward.random_bonus");
        config.addBool("only_one", this.onlyOne, v -> {
            this.onlyOne = v;
        }, false);
    }

    @Override
    public void claim(class_3222 player, boolean notify) {
        int size;
        int s;
        if (this.onlyOne && player.method_31548().method_7379(this.item)) {
            return;
        }
        for (size = this.count + player.method_37908().field_9229.method_43048(this.randomBonus + 1); size > 0; size -= s) {
            s = Math.min(size, this.item.method_7914());
            ItemStackHooks.giveItem((class_3222)player, (class_1799)ItemStackHooks.copyWithCount((class_1799)this.item, (int)s));
        }
        if (notify) {
            new DisplayItemRewardToastMessage(this.item, size).sendTo(player);
        }
    }

    @Override
    public boolean automatedClaimPre(class_2586 blockEntity, List<class_1799> items, class_5819 random, UUID playerId, @Nullable class_3222 player) {
        int s;
        for (int size = this.count + random.method_43048(this.randomBonus + 1); size > 0; size -= s) {
            s = Math.min(size, this.item.method_7914());
            items.add(ItemStackHooks.copyWithCount((class_1799)this.item, (int)s));
        }
        return true;
    }

    @Override
    public void automatedClaimPost(class_2586 blockEntity, UUID playerId, @Nullable class_3222 player) {
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return class_2561.method_43470((String)(this.count > 1 ? (this.randomBonus > 0 ? this.count + "-" + (this.count + this.randomBonus) + "x " : this.count + "x ") : "")).method_10852(this.item.method_7964());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        return this.item.method_7960() ? super.getAltIcon() : ItemIcon.getItemIcon((class_1799)ItemStackHooks.copyWithCount((class_1799)this.item, (int)1));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Optional<PositionedIngredient> getIngredient(Widget widget) {
        return PositionedIngredient.of((Object)this.item, (Widget)widget, (boolean)true);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public String getButtonText() {
        return this.randomBonus > 0 ? this.count + "-" + (this.count + this.randomBonus) : Integer.toString(this.count);
    }
}

