/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.registry;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.fzzyhmstrs.fzzy_config.FC;
import me.fzzyhmstrs.fzzy_config.annotations.Action;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.config.ConfigContext;
import me.fzzyhmstrs.fzzy_config.event.impl.EventApiImpl;
import me.fzzyhmstrs.fzzy_config.impl.ConfigApiImpl;
import me.fzzyhmstrs.fzzy_config.impl.ConfigSet;
import me.fzzyhmstrs.fzzy_config.registry.SyncedConfigRegistry;
import me.fzzyhmstrs.fzzy_config.screen.internal.ConfigScreenManager;
import me.fzzyhmstrs.fzzy_config.updates.UpdateManager;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import me.fzzyhmstrs.fzzy_config.util.PlatformUtils;
import me.fzzyhmstrs.fzzy_config.util.ValidationResult;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001LB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ+\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u000eH\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J+\u0010\u0019\u001a\u00020\n2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0016\u001a\u00020\u0015H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001aH\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\u0006\u0010\u001e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010%\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b#\u0010$J\u0019\u0010)\u001a\u0004\u0018\u00010&2\u0006\u0010\"\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b'\u0010(J'\u0010,\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u000e0\u000eH\u0000\u00a2\u0006\u0004\b*\u0010+J+\u0010.\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u000eH\u0000\u00a2\u0006\u0004\b-\u0010\u0012J/\u00104\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u0002002\u0006\u0010\"\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b2\u00103J\u0019\u00105\u001a\u0004\u0018\u00010\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b5\u00106J\u001f\u0010<\u001a\u00020\n2\u0006\u00108\u001a\u0002072\u0006\u00109\u001a\u000207H\u0000\u00a2\u0006\u0004\b:\u0010;R \u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020>0=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010@R \u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020A0=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010@R,\u0010C\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u000e0=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bC\u0010@R\u001c\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00040D8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bE\u0010FR\"\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040G8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bH\u0010IR\u0016\u0010J\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010K\u00a8\u0006M"}, d2={"Lme/fzzyhmstrs/fzzy_config/registry/ClientConfigRegistry;", "", "<init>", "()V", "", "id", "configString", "Ljava/util/function/Consumer;", "Lnet/minecraft/class_2561;", "disconnector", "", "receiveSync$fzzy_config", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/function/Consumer;)V", "receiveSync", "", "", "perms", "receivePerms$fzzy_config", "(Ljava/lang/String;Ljava/util/Map;)V", "receivePerms", "serializedConfigs", "Lnet/minecraft/class_1657;", "player", "receiveUpdate$fzzy_config", "(Ljava/util/Map;Lnet/minecraft/class_1657;)V", "receiveUpdate", "", "getScreenScopes$fzzy_config", "()Ljava/util/Set;", "getScreenScopes", "parentScope", "getSubScreenScopes$fzzy_config", "(Ljava/lang/String;)Ljava/util/Set;", "getSubScreenScopes", "scope", "openScreen$fzzy_config", "(Ljava/lang/String;)V", "openScreen", "Lnet/minecraft/class_437;", "provideScreen$fzzy_config", "(Ljava/lang/String;)Lnet/minecraft/class_437;", "provideScreen", "getPerms$fzzy_config", "()Ljava/util/Map;", "getPerms", "updatePerms$fzzy_config", "updatePerms", "update", "Ljava/util/UUID;", "summary", "handleForwardedUpdate$fzzy_config", "(Ljava/lang/String;Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;)V", "handleForwardedUpdate", "getValidScope", "(Ljava/lang/String;)Ljava/lang/String;", "Lme/fzzyhmstrs/fzzy_config/config/Config;", "config", "baseConfig", "registerConfig$fzzy_config", "(Lme/fzzyhmstrs/fzzy_config/config/Config;Lme/fzzyhmstrs/fzzy_config/config/Config;)V", "registerConfig", "", "Lme/fzzyhmstrs/fzzy_config/registry/ClientConfigRegistry$ConfigPair;", "clientConfigs", "Ljava/util/Map;", "Lme/fzzyhmstrs/fzzy_config/screen/internal/ConfigScreenManager;", "configScreenManagers", "customPermissions", "", "validScopes", "Ljava/util/Set;", "Lcom/google/common/collect/HashMultimap;", "validSubScopes", "Lcom/google/common/collect/HashMultimap;", "hasScrapedMetadata", "Z", "ConfigPair", "fzzy_config"})
@SourceDebugExtension(value={"SMAP\nClientConfigRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientConfigRegistry.kt\nme/fzzyhmstrs/fzzy_config/registry/ClientConfigRegistry\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,218:1\n37#2,2:219\n1755#3,3:221\n487#4,7:224\n487#4,7:235\n126#5:231\n153#5,3:232\n126#5:242\n153#5,3:243\n*S KotlinDebug\n*F\n+ 1 ClientConfigRegistry.kt\nme/fzzyhmstrs/fzzy_config/registry/ClientConfigRegistry\n*L\n127#1:219,2\n59#1:221,3\n153#1:224,7\n168#1:235,7\n153#1:231\n153#1:232,3\n168#1:242\n168#1:243,3\n*E\n"})
public final class ClientConfigRegistry {
    @NotNull
    public static final ClientConfigRegistry INSTANCE = new ClientConfigRegistry();
    @NotNull
    private static final Map<String, ConfigPair> clientConfigs = new LinkedHashMap();
    @NotNull
    private static final Map<String, ConfigScreenManager> configScreenManagers = new LinkedHashMap();
    @NotNull
    private static final Map<String, Map<String, Boolean>> customPermissions = new LinkedHashMap();
    @NotNull
    private static Set<String> validScopes = new LinkedHashSet();
    @NotNull
    private static HashMultimap<String, String> validSubScopes;
    private static boolean hasScrapedMetadata;

    private ClientConfigRegistry() {
    }

    public final void receiveSync$fzzy_config(@NotNull String id, @NotNull String configString, @NotNull Consumer<class_2561> disconnector) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)configString, (String)"configString");
        Intrinsics.checkNotNullParameter(disconnector, (String)"disconnector");
        if (SyncedConfigRegistry.INSTANCE.syncedConfigs$fzzy_config().containsKey(id)) {
            Config config = SyncedConfigRegistry.INSTANCE.syncedConfigs$fzzy_config().get(id);
            if (config == null) {
                return;
            }
            Config config2 = config;
            List errors = new ArrayList();
            ValidationResult<ConfigContext<Config>> result = ConfigApi.deserializeConfig(config2, configString, errors, (byte)10);
            Set actions = result.get().getOrDefault(ConfigContext.Keys.getACTIONS(), SetsKt.emptySet());
            result.writeError(errors);
            class_310.method_1551().execute(() -> ClientConfigRegistry.receiveSync$lambda$1(result, actions, disconnector, config2, id));
        }
    }

    public final void receivePerms$fzzy_config(@NotNull String id, @NotNull Map<String, Boolean> perms) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(perms, (String)"perms");
        this.updatePerms$fzzy_config(id, perms);
    }

    public final void receiveUpdate$fzzy_config(@NotNull Map<String, String> serializedConfigs, @NotNull class_1657 player) {
        Intrinsics.checkNotNullParameter(serializedConfigs, (String)"serializedConfigs");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        for (Map.Entry<String, String> entry : serializedConfigs.entrySet()) {
            Config config;
            String id = entry.getKey();
            String configString = entry.getValue();
            if (!SyncedConfigRegistry.INSTANCE.syncedConfigs$fzzy_config().containsKey(id)) continue;
            if (SyncedConfigRegistry.INSTANCE.syncedConfigs$fzzy_config().get(id) == null) {
                return;
            }
            List errors = new ArrayList();
            ValidationResult<ConfigContext<Config>> result = ConfigApiImpl.INSTANCE.deserializeUpdate$fzzy_config(config, configString, errors, (byte)2);
            Set actions = result.get().getOrDefault(ConfigContext.Keys.getACTIONS(), SetsKt.emptySet());
            result.writeError(errors);
            class_310.method_1551().execute(() -> ClientConfigRegistry.receiveUpdate$lambda$2(result, actions, player, config, id));
        }
    }

    @NotNull
    public final Set<String> getScreenScopes$fzzy_config() {
        if (!hasScrapedMetadata) {
            Collection $this$toTypedArray$iv = validScopes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            Set set = SetsKt.mutableSetOf((Object[])Arrays.copyOf(stringArray, stringArray.length));
            for (String scope : PlatformUtils.INSTANCE.customScopes()) {
                set.add(scope);
            }
            hasScrapedMetadata = true;
            return CollectionsKt.toSet((Iterable)set);
        }
        return validScopes;
    }

    @NotNull
    public final Set<String> getSubScreenScopes$fzzy_config(@NotNull String parentScope) {
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Set set = validSubScopes.get((Object)parentScope);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"get(...)");
        return set;
    }

    public final void openScreen$fzzy_config(@NotNull String scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        String namespaceScope = this.getValidScope(scope);
        if (namespaceScope == null) {
            FC.INSTANCE.getLOGGER$fzzy_config().error("Failed to open a FzzyConfig screen. Invalid scope provided: [" + scope + "]");
            return;
        }
        ConfigScreenManager configScreenManager = configScreenManagers.computeIfAbsent(namespaceScope, arg_0 -> ClientConfigRegistry.openScreen$lambda$6(arg_0 -> ClientConfigRegistry.openScreen$lambda$5(namespaceScope, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)configScreenManager, (String)"computeIfAbsent(...)");
        ConfigScreenManager manager = configScreenManager;
        manager.openScreen$fzzy_config(scope);
    }

    @Nullable
    public final class_437 provideScreen$fzzy_config(@NotNull String scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        String namespaceScope = this.getValidScope(scope);
        if (namespaceScope == null) {
            FC.INSTANCE.getLOGGER$fzzy_config().error("Failed to open a FzzyConfig screen. Invalid scope provided: [" + scope + "]");
            return null;
        }
        ConfigScreenManager configScreenManager = configScreenManagers.computeIfAbsent(namespaceScope, arg_0 -> ClientConfigRegistry.provideScreen$lambda$10(arg_0 -> ClientConfigRegistry.provideScreen$lambda$9(namespaceScope, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)configScreenManager, (String)"computeIfAbsent(...)");
        ConfigScreenManager manager = configScreenManager;
        return manager.provideScreen$fzzy_config(scope);
    }

    @NotNull
    public final Map<String, Map<String, Boolean>> getPerms$fzzy_config() {
        return new HashMap<String, Map<String, Boolean>>(customPermissions);
    }

    public final void updatePerms$fzzy_config(@NotNull String id, @NotNull Map<String, Boolean> perms) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(perms, (String)"perms");
        customPermissions.put(id, perms);
    }

    public final void handleForwardedUpdate$fzzy_config(@NotNull String update, @NotNull UUID player, @NotNull String scope, @NotNull String summary) {
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)summary, (String)"summary");
        String namespaceScope = this.getValidScope(scope);
        if (namespaceScope == null) {
            FC.INSTANCE.getLOGGER$fzzy_config().error("Failed to handle a forwarded setting. Invalid scope provided: [" + scope + "]");
            return;
        }
        ConfigScreenManager manager = configScreenManagers.get(namespaceScope);
        if (manager == null) {
            FC.INSTANCE.getLOGGER$fzzy_config().error("Failed to handle a forwarded setting. Unknown scope provided: [" + scope + "]");
            return;
        }
        manager.receiveForwardedUpdate$fzzy_config(update, player, scope, summary);
    }

    private final String getValidScope(String scope) {
        if (validScopes.contains(scope)) {
            return scope;
        }
        String validScopeTry = StringsKt.substringBeforeLast$default((String)scope, (char)'.', null, (int)2, null);
        if (Intrinsics.areEqual((Object)validScopeTry, (Object)scope)) {
            return null;
        }
        while (!validScopes.contains(validScopeTry) && StringsKt.contains$default((CharSequence)validScopeTry, (char)'.', (boolean)false, (int)2, null)) {
            validScopeTry = StringsKt.substringBeforeLast$default((String)validScopeTry, (char)'.', null, (int)2, null);
        }
        return validScopes.contains(validScopeTry) ? validScopeTry : null;
    }

    public final void registerConfig$fzzy_config(@NotNull Config config, @NotNull Config baseConfig) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)baseConfig, (String)"baseConfig");
        String string = config.getId().method_12836();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNamespace(...)");
        validScopes.add(string);
        validSubScopes.put((Object)config.getId().method_12836(), (Object)config.getId().method_12832());
        UpdateManager.Base.applyKeys(config);
        clientConfigs.put(config.getId().method_42094(), new ConfigPair(config, baseConfig));
    }

    private static final void receiveSync$lambda$1(ValidationResult $result, Set $actions, Consumer $disconnector, Config $config, String $id) {
        boolean bl;
        block11: {
            ((Config)((ConfigContext)$result.get()).getConfig()).save();
            Iterable $this$any$iv = $actions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Action it = (Action)((Object)element$iv);
                    boolean bl2 = false;
                    if (!it.getRestartPrompt()) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            Set<String> records = ((ConfigContext)$result.get()).get(ConfigContext.Keys.getRESTART_RECORDS());
            Collection collection = records;
            if (!(collection == null || collection.isEmpty())) {
                FC.INSTANCE.getLOGGER$fzzy_config().info("Client prompted for a restart due to received config updates");
                FC.INSTANCE.getLOGGER$fzzy_config().info("Restart-prompting updates:");
                for (String record : records) {
                    FC.INSTANCE.getLOGGER$fzzy_config().info(record);
                }
            }
            $disconnector.accept(FcText.INSTANCE.translatable("fc.networking.restart", new Object[0]));
            ConfigApiImpl.INSTANCE.openRestartScreen$fzzy_config();
        } else {
            try {
                $config.onSyncClient();
            }
            catch (Throwable e) {
                FC.INSTANCE.getLOGGER$fzzy_config().error("Error encountered with onSyncClient method of config " + $id + "!");
                e.printStackTrace();
            }
            try {
                EventApiImpl.INSTANCE.fireOnSyncClient$fzzy_config(((Config)((ConfigContext)$result.get()).getConfig()).getId(), (Config)((ConfigContext)$result.get()).getConfig());
            }
            catch (Throwable e) {
                FC.INSTANCE.getLOGGER$fzzy_config().error("Error encountered while running onSyncClient event for config " + $id + "!");
                e.printStackTrace();
            }
        }
    }

    private static final void receiveUpdate$lambda$2(ValidationResult $result, Set $actions, class_1657 $player, Config $config, String $id) {
        ((Config)((ConfigContext)$result.get()).getConfig()).save();
        for (Action action : $actions) {
            $player.method_43496(action.getClientPrompt());
        }
        try {
            $config.onUpdateClient();
        }
        catch (Throwable e) {
            FC.INSTANCE.getLOGGER$fzzy_config().error("Error encountered with onUpdateClient method of config " + $id + " while receiving an update from the server!");
            e.printStackTrace();
        }
        try {
            EventApiImpl.INSTANCE.fireOnUpdateClient$fzzy_config(((Config)((ConfigContext)$result.get()).getConfig()).getId(), (Config)((ConfigContext)$result.get()).getConfig());
        }
        catch (Throwable e) {
            FC.INSTANCE.getLOGGER$fzzy_config().error("Error encountered while running onUpdateClient event for config " + $id + " while receiving an update from the server!");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final ConfigScreenManager openScreen$lambda$5(String $namespaceScope, String it) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map $this$filterKeys$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Map<String, ConfigPair> map = clientConfigs;
        String string = $namespaceScope;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String s = (String)entry$iv.getKey();
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)s, (String)$namespaceScope, (boolean)false, (int)2, null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterKeys$iv = result$iv;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ConfigSet(((ConfigPair)it2.getValue()).getActive(), ((ConfigPair)it2.getValue()).getBase(), !SyncedConfigRegistry.INSTANCE.hasConfig$fzzy_config((String)it2.getKey())));
        }
        List list = (List)destination$iv$iv;
        String string2 = string;
        return new ConfigScreenManager(string2, list);
    }

    private static final ConfigScreenManager openScreen$lambda$6(Function1 $tmp0, Object p0) {
        return (ConfigScreenManager)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final ConfigScreenManager provideScreen$lambda$9(String $namespaceScope, String it) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map $this$filterKeys$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Map<String, ConfigPair> map = clientConfigs;
        String string = $namespaceScope;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String s = (String)entry$iv.getKey();
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)s, (String)$namespaceScope, (boolean)false, (int)2, null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterKeys$iv = result$iv;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ConfigSet(((ConfigPair)it2.getValue()).getActive(), ((ConfigPair)it2.getValue()).getBase(), !SyncedConfigRegistry.INSTANCE.hasConfig$fzzy_config((String)it2.getKey())));
        }
        List list = (List)destination$iv$iv;
        String string2 = string;
        return new ConfigScreenManager(string2, list);
    }

    private static final ConfigScreenManager provideScreen$lambda$10(Function1 $tmp0, Object p0) {
        return (ConfigScreenManager)$tmp0.invoke(p0);
    }

    static {
        HashMultimap hashMultimap = HashMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashMultimap, (String)"create(...)");
        validSubScopes = hashMultimap;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0007\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0007\u001a\u0004\b\n\u0010\t\u00a8\u0006\u000b"}, d2={"Lme/fzzyhmstrs/fzzy_config/registry/ClientConfigRegistry$ConfigPair;", "", "Lme/fzzyhmstrs/fzzy_config/config/Config;", "active", "base", "<init>", "(Lme/fzzyhmstrs/fzzy_config/config/Config;Lme/fzzyhmstrs/fzzy_config/config/Config;)V", "Lme/fzzyhmstrs/fzzy_config/config/Config;", "getActive", "()Lme/fzzyhmstrs/fzzy_config/config/Config;", "getBase", "fzzy_config"})
    private static final class ConfigPair {
        @NotNull
        private final Config active;
        @NotNull
        private final Config base;

        public ConfigPair(@NotNull Config active, @NotNull Config base) {
            Intrinsics.checkNotNullParameter((Object)active, (String)"active");
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            this.active = active;
            this.base = base;
        }

        @NotNull
        public final Config getActive() {
            return this.active;
        }

        @NotNull
        public final Config getBase() {
            return this.base;
        }
    }
}

