/*
 * Decompiled with CFR 0.152.
 */
package draylar.gofish.loot.biome;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class BiomeTagPredicate {
    public static final BiomeTagPredicate EMPTY = new BiomeTagPredicate(Collections.emptyList());
    private static final String VALID_KEY = "valid";
    private final List<class_6862<class_1959>> valid;

    public BiomeTagPredicate(List<class_6862<class_1959>> valid) {
        this.valid = valid;
    }

    public BiomeTagPredicate(Builder builder) {
        this.valid = builder.valid;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<class_6862<class_1959>> getValid() {
        return this.valid;
    }

    public boolean test(class_6880<class_1959> biome) {
        for (class_6862<class_1959> tag : this.valid) {
            if (!biome.method_40220(tag)) continue;
            return true;
        }
        return false;
    }

    public JsonElement toJson() {
        JsonObject obj = new JsonObject();
        JsonArray arr = new JsonArray();
        for (class_6862<class_1959> tag : this.valid) {
            arr.add(tag.comp_327().toString());
        }
        obj.add(VALID_KEY, (JsonElement)arr);
        return obj;
    }

    public static BiomeTagPredicate fromJson(JsonElement element) {
        JsonObject obj = class_3518.method_15295((JsonElement)element, (String)VALID_KEY);
        JsonArray arr = obj.getAsJsonArray(VALID_KEY);
        ArrayList<String> sArr = new ArrayList<String>();
        for (int i = 0; i < arr.size(); ++i) {
            sArr.add(arr.get(i).getAsString());
        }
        return BiomeTagPredicate.builder().setValidByString(sArr).build();
    }

    public static class Builder {
        private List<class_6862<class_1959>> valid = new ArrayList<class_6862<class_1959>>();

        private Builder() {
        }

        public Builder setValid(List<class_6862<class_1959>> valid) {
            this.valid = valid;
            return this;
        }

        public Builder setValidByString(List<String> valid) {
            ArrayList<class_6862<class_1959>> tagKeys = new ArrayList<class_6862<class_1959>>();
            for (String str : valid) {
                tagKeys.add((class_6862<class_1959>)class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960(str)));
            }
            return this.setValid(tagKeys);
        }

        public Builder add(String tag) {
            if (!tag.isEmpty()) {
                this.valid.add((class_6862<class_1959>)class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960(tag)));
            }
            return this;
        }

        public Builder of(BiomeTagPredicate biomePredicate) {
            this.valid = biomePredicate.valid;
            return this;
        }

        public BiomeTagPredicate build() {
            return new BiomeTagPredicate(this);
        }
    }
}

