/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.network;

import java.util.List;
import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class RescueMessage {
    private final boolean active;

    public RescueMessage(boolean active) {
        this.active = active;
    }

    public static void encode(RescueMessage message, class_2540 buf) {
        buf.writeBoolean(message.active);
    }

    public static RescueMessage decode(class_2540 buf) {
        boolean active = buf.readBoolean();
        return new RescueMessage(active);
    }

    private static boolean isLookingTowards(class_1657 player, class_1297 candidate) {
        double dz;
        double dy;
        double dx = candidate.method_23317() - player.method_23317();
        double dotProduct = player.method_5720().field_1352 * dx + player.method_5720().field_1351 * (dy = candidate.method_23318() - 1.0 - player.method_23318()) + player.method_5720().field_1350 * (dz = candidate.method_23321() - player.method_23321());
        return dotProduct > 0.0 && Math.abs(Math.acos(dotProduct / Math.sqrt(dx * dx + dy * dy + dz * dz))) < 1.0471975511965976;
    }

    public static void handle(class_3222 player, RescueMessage message) {
        if (player == null || !player.method_5805() || player.method_7325() || HardcoreRevival.getRevivalData((class_1297)player).isKnockedOut()) {
            return;
        }
        if (message.active) {
            double range = HardcoreRevivalConfig.getActive().rescueDistance;
            List candidates = player.method_37908().method_8390(class_1657.class, player.method_5829().method_1014(range), p -> {
                if (p == null || !HardcoreRevival.getRevivalData((class_1297)p).isKnockedOut()) {
                    return false;
                }
                if (!player.method_6057((class_1297)p)) {
                    return false;
                }
                return RescueMessage.isLookingTowards((class_1657)player, (class_1297)p);
            });
            float minDist = Float.MAX_VALUE;
            class_1657 target = null;
            for (class_1657 candidate : candidates) {
                float dist = candidate.method_5739((class_1297)player);
                if (!(dist < minDist)) continue;
                target = candidate;
                minDist = dist;
            }
            if (target != null) {
                HardcoreRevival.getManager().startRescue((class_1657)player, target);
            }
        } else {
            HardcoreRevival.getManager().abortRescue((class_1657)player);
        }
    }
}

