/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.irisflw.compiler;

import com.jozufozu.flywheel.backend.gl.shader.GlProgram;
import com.jozufozu.flywheel.core.compile.ProgramContext;
import com.jozufozu.flywheel.core.compile.Template;
import com.jozufozu.flywheel.core.compile.VertexData;
import com.jozufozu.flywheel.core.shader.WorldProgram;
import com.jozufozu.flywheel.core.source.FileResolution;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.gl.blending.AlphaTest;
import net.irisshaders.iris.gl.blending.AlphaTestFunction;
import net.irisshaders.iris.gl.blending.BlendModeOverride;
import net.irisshaders.iris.gl.shader.StandardMacros;
import net.irisshaders.iris.helpers.StringPair;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.shaderpack.loading.ProgramId;
import net.irisshaders.iris.shaderpack.preprocessor.JcppProcessor;
import net.irisshaders.iris.shaderpack.programs.ProgramFallbackResolver;
import net.irisshaders.iris.shaderpack.programs.ProgramSet;
import net.irisshaders.iris.shaderpack.programs.ProgramSource;
import net.irisshaders.iris.shaderpack.properties.ShaderProperties;
import net.minecraft.class_2960;
import top.leonx.irisflw.accessors.IrisRenderingPipelineAccessor;
import top.leonx.irisflw.accessors.ProgramDirectivesAccessor;
import top.leonx.irisflw.accessors.ProgramSourceAccessor;
import top.leonx.irisflw.compiler.IrisProgramCompilerBase;
import top.leonx.irisflw.transformer.ShaderPatcherBase;

public class NewProgramCompiler<TP extends ShaderPatcherBase, P extends WorldProgram>
extends IrisProgramCompilerBase<P> {
    private final Map<ProgramSet, ProgramFallbackResolver> resolvers = new HashMap<ProgramSet, ProgramFallbackResolver>();
    private final Iterable<StringPair> environmentDefines;
    private final TP patcher;

    public NewProgramCompiler(GlProgram.Factory<P> factory, Template<? extends VertexData> template, FileResolution header, Class<TP> patcherClass) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        super(factory, template, header);
        Method method = StandardMacros.class.getMethod("createStandardEnvironmentDefines", new Class[0]);
        this.environmentDefines = (Iterable)method.invoke(null, new Object[0]);
        this.patcher = (ShaderPatcherBase)patcherClass.getDeclaredConstructor(Template.class, FileResolution.class).newInstance(template, header);
    }

    @Override
    P createIrisShaderProgram(ProgramContext ctx, boolean isShadow) {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline instanceof IrisRenderingPipeline) {
            IrisRenderingPipeline newPipeline = (IrisRenderingPipeline)pipeline;
            ProgramSet programSet = ((IrisRenderingPipelineAccessor)newPipeline).getProgramSet();
            Optional<ProgramSource> sourceReferenceOpt = this.getProgramSourceReference(programSet, ctx.spec.name, isShadow);
            if (sourceReferenceOpt.isEmpty()) {
                return null;
            }
            ProgramSource sourceRef = sourceReferenceOpt.get();
            if (sourceRef.getVertexSource().isEmpty()) {
                return null;
            }
            String vertexSource = (String)sourceRef.getVertexSource().get();
            String newVertexSource = ((ShaderPatcherBase)this.patcher).patch(vertexSource, new ShaderPatcherBase.Context(ctx.spec.getVertexFile(), ctx.ctx, ctx.vertexType));
            newVertexSource = JcppProcessor.glslPreprocessSource((String)newVertexSource, this.environmentDefines);
            ProgramSource newProgramSource = this.programSourceOverrideVertexSource(ctx, programSet, sourceRef, newVertexSource);
            ((ProgramDirectivesAccessor)newProgramSource.getDirectives()).setFlwAlphaTestOverride(new AlphaTest(AlphaTestFunction.GREATER, ctx.alphaDiscard));
            return this.createWorldProgramBySource(ctx, isShadow, (IrisRenderingPipelineAccessor)newPipeline, newProgramSource);
        }
        return null;
    }

    protected Optional<ProgramSource> getProgramSourceReference(ProgramSet programSet, class_2960 flwShaderName, boolean isShadow) {
        ProgramSource refProgram;
        ProgramFallbackResolver resolver = this.resolvers.computeIfAbsent(programSet, ProgramFallbackResolver::new);
        if (isShadow) {
            ProgramSource shadow = resolver.resolve(ProgramId.Shadow).orElse(null);
            if (shadow == null) {
                return Optional.empty();
            }
            ShaderProperties properties = ((ProgramSourceAccessor)shadow).getShaderProperties();
            BlendModeOverride blendModeOverride = ((ProgramSourceAccessor)shadow).getBlendModeOverride();
            return Optional.of(new ProgramSource("shadow_flw", (String)shadow.getVertexSource().orElseThrow(), (String)shadow.getGeometrySource().orElse(null), null, null, (String)shadow.getFragmentSource().orElseThrow(), programSet, properties, blendModeOverride));
        }
        ProgramId refProgramId = ProgramId.Block;
        if (Objects.equals(flwShaderName.method_12836(), "flywheel") && Objects.equals(flwShaderName.method_12832(), "passthru")) {
            refProgramId = ProgramId.Terrain;
        }
        if ((refProgram = (ProgramSource)resolver.resolve(refProgramId).orElse(null)) == null) {
            return Optional.empty();
        }
        ShaderProperties properties = ((ProgramSourceAccessor)refProgram).getShaderProperties();
        BlendModeOverride blendModeOverride = ((ProgramSourceAccessor)refProgram).getBlendModeOverride();
        return Optional.of(new ProgramSource("gbuffer_flw", (String)refProgram.getVertexSource().orElseThrow(), (String)refProgram.getGeometrySource().orElse(null), null, null, (String)refProgram.getFragmentSource().orElseThrow(), programSet, properties, blendModeOverride));
    }

    @Override
    public void clear() {
        super.clear();
        this.resolvers.clear();
    }
}

