/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.jumpoverfences;

import com.kreezcraft.jumpoverfences.CommonClass;
import com.kreezcraft.jumpoverfences.Constants;
import com.kreezcraft.jumpoverfences.callback.PlayerJumpCallback;
import com.kreezcraft.jumpoverfences.config.FabricFencesConfig;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_1269;
import net.minecraft.class_1309;

public class JumpOverFencesFabric
implements ClientModInitializer {
    private Thread watchThread = null;
    public static FabricFencesConfig config;

    public void onInitializeClient() {
        ConfigHolder holder = AutoConfig.register(FabricFencesConfig.class, Toml4jConfigSerializer::new);
        config = (FabricFencesConfig)holder.getConfig();
        try {
            WatchService watchService = FileSystems.getDefault().newWatchService();
            Paths.get("config", new String[0]).register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            this.watchThread = new Thread(() -> {
                try {
                    WatchKey key;
                    while ((key = watchService.take()) != null) {
                        if (Thread.currentThread().isInterrupted()) {
                            watchService.close();
                            break;
                        }
                        for (WatchEvent<?> event : key.pollEvents()) {
                            if (event.kind() == StandardWatchEventKinds.OVERFLOW || !((Path)event.context()).endsWith("jumpoverfences.toml")) continue;
                            Constants.LOG.info("Reloading Jump Over Fences' config");
                            if (!holder.load()) continue;
                            config = (FabricFencesConfig)holder.getConfig();
                        }
                        key.reset();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IOException e) {
                    Constants.LOG.error("Failed to close filesystem watcher", (Throwable)e);
                }
            }, "Jump Over Fences Config Watcher");
            this.watchThread.start();
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to create filesystem watcher for configs", (Throwable)e);
        }
        PlayerJumpCallback.EVENT.register(player -> {
            CommonClass.onJump((class_1309)player);
            return class_1269.field_5811;
        });
    }
}

