/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.wispforest.lavender.book.Book;
import io.wispforest.lavender.book.BookLoader;
import io.wispforest.lavender.book.LavenderBookItem;
import io.wispforest.lavender.client.StructureOverlayRenderer;
import io.wispforest.lavender.structure.LavenderStructures;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7157;

public class LavenderCommands {
    private static final SimpleCommandExceptionType NO_SUCH_BOOK = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"No such book is loaded"));
    private static final SuggestionProvider<class_2168> LOADED_BOOKS = (context, builder) -> class_2172.method_9257(BookLoader.loadedBooks().stream().map(Book::id), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 access, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"get-lavender-book").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"book_id", (ArgumentType)class_2232.method_9441()).suggests(LOADED_BOOKS).executes(context -> LavenderCommands.executeGetLavenderBook((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"force_dynamic_book", (ArgumentType)BoolArgumentType.bool()).executes(context -> LavenderCommands.executeGetLavenderBook((CommandContext<class_2168>)context, BoolArgumentType.getBool((CommandContext)context, (String)"force_dynamic_book"))))));
    }

    private static int executeGetLavenderBook(CommandContext<class_2168> context, boolean forceDynamicBook) throws CommandSyntaxException {
        Book book = BookLoader.get(class_2232.method_9443(context, (String)"book_id"));
        if (book == null) {
            throw NO_SUCH_BOOK.create();
        }
        ((class_2168)context.getSource()).method_44023().method_31548().method_7398(forceDynamicBook ? LavenderBookItem.createDynamic(book) : LavenderBookItem.itemOf(book));
        return 0;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        private static final SimpleCommandExceptionType NO_SUCH_STRUCTURE = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"No such structure is loaded"));
        private static final SuggestionProvider<FabricClientCommandSource> STRUCTURE_INFO = (context, builder) -> class_2172.method_9264(LavenderStructures.loadedStructures().stream().map(class_2960::toString), (SuggestionsBuilder)builder);

        public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 access) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"structure-overlay").then(ClientCommandManager.literal((String)"clear-all").executes(context -> {
                StructureOverlayRenderer.clearOverlays();
                return 0;
            }))).then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"structure", (ArgumentType)class_2232.method_9441()).suggests(STRUCTURE_INFO).executes(context -> {
                class_2960 structureId = (class_2960)context.getArgument("structure", class_2960.class);
                if (LavenderStructures.get(structureId) == null) {
                    throw NO_SUCH_STRUCTURE.create();
                }
                StructureOverlayRenderer.addPendingOverlay(structureId);
                return 0;
            }))));
        }
    }
}

