/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.structure;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import io.wispforest.lavender.structure.BlockStatePredicate;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_638;
import net.minecraft.class_6539;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class StructureTemplate {
    private final BlockStatePredicate[][][] predicates;
    private final EnumMap<BlockStatePredicate.MatchCategory, MutableInt> predicateCountByType;
    public final int xSize;
    public final int ySize;
    public final int zSize;
    public final class_2382 anchor;
    public final class_2960 id;

    public StructureTemplate(class_2960 id, BlockStatePredicate[][][] predicates, int xSize, int ySize, int zSize, @Nullable class_2382 anchor) {
        this.id = id;
        this.predicates = predicates;
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        this.anchor = anchor != null ? anchor : new class_2382(this.xSize / 2, 0, this.ySize / 2);
        this.predicateCountByType = new EnumMap(BlockStatePredicate.MatchCategory.class);
        for (BlockStatePredicate.MatchCategory type : BlockStatePredicate.MatchCategory.values()) {
            this.forEachPredicate((blockPos, predicate) -> {
                if (!predicate.isOf(type)) {
                    return;
                }
                this.predicateCountByType.computeIfAbsent(type, $ -> new MutableInt()).increment();
            });
        }
    }

    public int predicatesOfType(BlockStatePredicate.MatchCategory type) {
        return this.predicateCountByType.get((Object)type).intValue();
    }

    public class_2382 anchor() {
        return this.anchor;
    }

    public void forEachPredicate(BiConsumer<class_2338, BlockStatePredicate> action) {
        this.forEachPredicate(action, class_2470.field_11467);
    }

    public void forEachPredicate(BiConsumer<class_2338, BlockStatePredicate> action, class_2470 rotation) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int x = 0; x < this.predicates.length; ++x) {
            for (int y = 0; y < this.predicates[x].length; ++y) {
                for (int z = 0; z < this.predicates[x][y].length; ++z) {
                    switch (rotation) {
                        case field_11463: {
                            mutable.method_10103(this.zSize - z - 1, y, x);
                            break;
                        }
                        case field_11465: {
                            mutable.method_10103(z, y, this.xSize - x - 1);
                            break;
                        }
                        case field_11464: {
                            mutable.method_10103(this.xSize - x - 1, y, this.zSize - z - 1);
                            break;
                        }
                        default: {
                            mutable.method_10103(x, y, z);
                        }
                    }
                    action.accept((class_2338)mutable, this.predicates[x][y][z]);
                }
            }
        }
    }

    public boolean validate(class_1937 world, class_2338 anchor) {
        return this.validate(world, anchor, class_2470.field_11467);
    }

    public boolean validate(class_1937 world, class_2338 anchor, class_2470 rotation) {
        return this.countValidStates(world, anchor, rotation) == this.predicatesOfType(BlockStatePredicate.MatchCategory.NON_NULL);
    }

    public int countValidStates(class_1937 world, class_2338 anchor) {
        return this.countValidStates(world, anchor, class_2470.field_11467, BlockStatePredicate.MatchCategory.NON_NULL);
    }

    public int countValidStates(class_1937 world, class_2338 anchor, class_2470 rotation) {
        return this.countValidStates(world, anchor, rotation, BlockStatePredicate.MatchCategory.NON_NULL);
    }

    public int countValidStates(class_1937 world, class_2338 anchor, class_2470 rotation, BlockStatePredicate.MatchCategory predicateFilter) {
        MutableInt validStates = new MutableInt();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        this.forEachPredicate((pos, predicate) -> {
            if (!predicate.isOf(predicateFilter)) {
                return;
            }
            if (predicate.matches(world.method_8320((class_2338)mutable.method_10101((class_2382)pos).method_30927((class_2382)anchor)).method_26186(StructureTemplate.inverse(rotation)))) {
                validStates.increment();
            }
        }, rotation);
        return validStates.intValue();
    }

    public class_1920 asBlockRenderView() {
        final class_638 world = class_310.method_1551().field_1687;
        return new class_1920(){

            public float method_24852(class_2350 direction, boolean shaded) {
                return 1.0f;
            }

            public class_3568 method_22336() {
                return world.method_22336();
            }

            public int method_23752(class_2338 pos, class_6539 colorResolver) {
                return colorResolver.getColor((class_1959)world.method_23753(pos).comp_349(), (double)pos.method_10263(), (double)pos.method_10260());
            }

            @Nullable
            public class_2586 method_8321(class_2338 pos) {
                return null;
            }

            public class_2680 method_8320(class_2338 pos) {
                if (pos.method_10263() < 0 || pos.method_10263() >= StructureTemplate.this.xSize || pos.method_10264() < 0 || pos.method_10264() >= StructureTemplate.this.ySize || pos.method_10260() < 0 || pos.method_10260() >= StructureTemplate.this.zSize) {
                    return class_2246.field_10124.method_9564();
                }
                return StructureTemplate.this.predicates[pos.method_10263()][pos.method_10264()][pos.method_10260()].preview();
            }

            public class_3610 method_8316(class_2338 pos) {
                return class_3612.field_15906.method_15785();
            }

            public int method_31605() {
                return world.method_31605();
            }

            public int method_31607() {
                return world.method_31607();
            }
        };
    }

    public static class_2470 inverse(class_2470 rotation) {
        return switch (rotation) {
            default -> throw new IncompatibleClassChangeError();
            case class_2470.field_11467 -> class_2470.field_11467;
            case class_2470.field_11463 -> class_2470.field_11465;
            case class_2470.field_11465 -> class_2470.field_11463;
            case class_2470.field_11464 -> class_2470.field_11464;
        };
    }

    public static StructureTemplate parse(class_2960 resourceId, JsonObject json) {
        JsonObject keyObject = class_3518.method_15296((JsonObject)json, (String)"keys");
        Char2ObjectOpenHashMap keys = new Char2ObjectOpenHashMap();
        class_2382 anchor = null;
        for (Map.Entry entry : keyObject.entrySet()) {
            char key;
            if (((String)entry.getKey()).length() == 1) {
                key = ((String)entry.getKey()).charAt(0);
                if (key == '#') {
                    throw new JsonParseException("Key '#' is reserved for 'anchor' declarations");
                }
            } else {
                if (!((String)entry.getKey()).equals("anchor")) continue;
                key = '#';
            }
            try {
                Iterator predicate;
                Either result = class_2259.method_41962((class_7225)class_7923.field_41175.method_46771(), (String)((JsonElement)entry.getValue()).getAsString(), (boolean)false);
                if (result.left().isPresent()) {
                    predicate = (class_2259.class_7211)result.left().get();
                    keys.put(key, (Object)new BlockStatePredicate((class_2259.class_7211)predicate){
                        final /* synthetic */ class_2259.class_7211 val$predicate;
                        {
                            this.val$predicate = class_72112;
                        }

                        @Override
                        public class_2680 preview() {
                            return this.val$predicate.comp_622();
                        }

                        @Override
                        public BlockStatePredicate.Result test(class_2680 state) {
                            if (state.method_26204() != this.val$predicate.comp_622().method_26204()) {
                                return BlockStatePredicate.Result.NO_MATCH;
                            }
                            for (Map.Entry propAndValue : this.val$predicate.comp_623().entrySet()) {
                                if (state.method_11654((class_2769)propAndValue.getKey()).equals(propAndValue.getValue())) continue;
                                return BlockStatePredicate.Result.BLOCK_MATCH;
                            }
                            return BlockStatePredicate.Result.STATE_MATCH;
                        }
                    });
                    continue;
                }
                predicate = (class_2259.class_7212)result.right().get();
                final ArrayList previewStates = new ArrayList();
                predicate.comp_625().forEach(arg_0 -> StructureTemplate.lambda$parse$3((class_2259.class_7212)predicate, previewStates, arg_0));
                keys.put(key, (Object)new BlockStatePredicate(){
                    final /* synthetic */ class_2259.class_7212 val$predicate;
                    {
                        this.val$predicate = class_72122;
                    }

                    @Override
                    public class_2680 preview() {
                        if (previewStates.isEmpty()) {
                            return class_2246.field_10124.method_9564();
                        }
                        return (class_2680)previewStates.get((int)(System.currentTimeMillis() / 1000L % (long)previewStates.size()));
                    }

                    @Override
                    public BlockStatePredicate.Result test(class_2680 state) {
                        if (!state.method_40143(this.val$predicate.comp_625())) {
                            return BlockStatePredicate.Result.NO_MATCH;
                        }
                        for (Map.Entry propAndValue : this.val$predicate.comp_626().entrySet()) {
                            class_2769 prop = state.method_26204().method_9595().method_11663((String)propAndValue.getKey());
                            if (prop == null) {
                                return BlockStatePredicate.Result.BLOCK_MATCH;
                            }
                            Optional expected = prop.method_11900((String)propAndValue.getValue());
                            if (expected.isEmpty()) {
                                return BlockStatePredicate.Result.BLOCK_MATCH;
                            }
                            if (state.method_11654(prop).equals(expected.get())) continue;
                            return BlockStatePredicate.Result.BLOCK_MATCH;
                        }
                        return BlockStatePredicate.Result.STATE_MATCH;
                    }
                });
            }
            catch (CommandSyntaxException e) {
                throw new JsonParseException("Failed to parse block state predicate", (Throwable)e);
            }
        }
        JsonArray layersArray = class_3518.method_15261((JsonObject)json, (String)"layers");
        int xSize = 0;
        int ySize = layersArray.size();
        int zSize = 0;
        for (JsonElement element : layersArray) {
            if (!(element instanceof JsonArray)) {
                throw new JsonParseException("Every element in the 'layers' array must itself be an array");
            }
            JsonArray layer = (JsonArray)element;
            if (zSize == 0) {
                zSize = layer.size();
            } else if (zSize != layer.size()) {
                throw new JsonParseException("Every layer must have the same amount of rows");
            }
            for (JsonElement rowElement : layer) {
                if (!rowElement.isJsonPrimitive()) {
                    throw new JsonParseException("Every element in a row must be a primitive");
                }
                if (xSize == 0) {
                    xSize = rowElement.getAsString().length();
                    continue;
                }
                if (xSize == rowElement.getAsString().length()) continue;
                throw new JsonParseException("Every row must have the same length");
            }
        }
        BlockStatePredicate[][][] result = new BlockStatePredicate[xSize][][];
        for (int x = 0; x < xSize; ++x) {
            result[x] = new BlockStatePredicate[ySize][];
            for (int y = 0; y < ySize; ++y) {
                result[x][y] = new BlockStatePredicate[zSize];
            }
        }
        for (int y = 0; y < layersArray.size(); ++y) {
            JsonArray layer = (JsonArray)layersArray.get(y);
            for (int z = 0; z < layer.size(); ++z) {
                String row = layer.get(z).getAsString();
                for (int x = 0; x < row.length(); ++x) {
                    BlockStatePredicate predicate;
                    char key = row.charAt(x);
                    if (keys.containsKey(key)) {
                        predicate = (BlockStatePredicate)keys.get(key);
                        if (key == '#') {
                            if (anchor != null) {
                                throw new JsonParseException("Anchor key '#' cannot be used twice within the same structure");
                            }
                            anchor = new class_2382(x, y, z);
                        }
                    } else if (key == ' ') {
                        predicate = BlockStatePredicate.NULL_PREDICATE;
                    } else if (key == '_') {
                        predicate = BlockStatePredicate.AIR_PREDICATE;
                    } else {
                        throw new JsonParseException("Unknown key '" + key + "'");
                    }
                    result[x][y][z] = predicate;
                }
            }
        }
        return new StructureTemplate(resourceId, result, xSize, ySize, zSize, anchor);
    }

    private static /* synthetic */ void lambda$parse$3(class_2259.class_7212 predicate, ArrayList previewStates, class_6880 registryEntry) {
        class_2248 block = (class_2248)registryEntry.comp_349();
        class_2680 state = block.method_9564();
        for (Map.Entry propAndValue : predicate.comp_626().entrySet()) {
            class_2769 prop = block.method_9595().method_11663((String)propAndValue.getKey());
            if (prop == null) {
                return;
            }
            Optional value = prop.method_11900((String)propAndValue.getValue());
            if (value.isEmpty()) {
                return;
            }
            state = (class_2680)state.method_11657(prop, (Comparable)value.get());
        }
        previewStates.add(state);
    }
}

