/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.compat.jei.category;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.satisfy.bakery.client.gui.StoveGui;
import net.satisfy.bakery.compat.jei.BakeryJEIPlugin;
import net.satisfy.bakery.recipe.StoveRecipe;
import net.satisfy.bakery.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class StoveCategory
implements IRecipeCategory<StoveRecipe> {
    public static final RecipeType<StoveRecipe> STOVE = RecipeType.create((String)"bakery", (String)"stove", StoveRecipe.class);
    public static final int WIDTH = 124;
    public static final int HEIGHT = 60;
    public static final int WIDTH_OF = 26;
    public static final int HEIGHT_OF = 13;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable burnIcon;
    private final IDrawableAnimated arrow;
    private final class_2561 localizedName;

    public StoveCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(StoveGui.BG, 26, 13, 124, 60);
        this.arrow = helper.drawableBuilder(StoveGui.BG, 178, 20, 18, 25).buildAnimated(240, IDrawableAnimated.StartDirection.LEFT, false);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((class_2248)ObjectRegistry.BRICK_STOVE.get()).method_8389().method_7854());
        this.burnIcon = helper.createDrawable(StoveGui.BG, 176, 0, 17, 15);
        this.localizedName = class_2561.method_43471((String)"rei.bakery.stove_category");
    }

    public void setRecipe(IRecipeLayoutBuilder builder, StoveRecipe recipe, IFocusGroup focuses) {
        class_2371<class_1856> ingredients = recipe.method_8117();
        BakeryJEIPlugin.addSlot(builder, 3, 5, (class_1856)ingredients.get(0));
        BakeryJEIPlugin.addSlot(builder, 21, 5, (class_1856)ingredients.get(1));
        BakeryJEIPlugin.addSlot(builder, 39, 5, (class_1856)ingredients.get(2));
        assert (class_310.method_1551().field_1687 != null);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 100, 29).addItemStack(recipe.method_8110(class_310.method_1551().field_1687.method_30349()));
    }

    public void draw(StoveRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 67, 19);
        this.burnIcon.draw(guiGraphics, 36, 36);
        this.drawExperience(recipe, guiGraphics);
    }

    protected void drawExperience(StoveRecipe recipe, class_332 guiGraphics) {
        float experience = recipe.getExperience();
        if (experience > 0.0f) {
            class_5250 experienceString = class_2561.method_43469((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            class_310 minecraft = class_310.method_1551();
            class_327 fontRenderer = minecraft.field_1772;
            int stringWidth = fontRenderer.method_27525((class_5348)experienceString);
            guiGraphics.method_51439(fontRenderer, (class_2561)experienceString, this.getWidth() - stringWidth, 0, -8355712, false);
        }
    }

    @NotNull
    public RecipeType<StoveRecipe> getRecipeType() {
        return STOVE;
    }

    @NotNull
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }
}

