/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.block.entity;

import com.mojang.datafixers.util.Pair;
import de.cristelknight.doapi.common.world.ImplementedInventory;
import java.util.Objects;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5558;
import net.satisfy.bakery.block.SmallCookingPotBlock;
import net.satisfy.bakery.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.client.gui.handler.CookingPotGuiHandler;
import net.satisfy.farm_and_charm.item.food.EffectFood;
import net.satisfy.farm_and_charm.item.food.EffectFoodHelper;
import net.satisfy.farm_and_charm.recipe.CookingPotRecipe;
import net.satisfy.farm_and_charm.registry.RecipeTypeRegistry;
import net.satisfy.farm_and_charm.registry.TagRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmallCookingPotBlockEntity
extends class_2586
implements class_5558<SmallCookingPotBlockEntity>,
ImplementedInventory,
class_3908 {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)8, (Object)class_1799.field_8037);
    private static final int MAX_CAPACITY = 8;
    private static final int CONTAINER_SLOT = 6;
    private static final int OUTPUT_SLOT = 7;
    private static final int INGREDIENTS_AREA = 6;
    private static final int[] SLOTS_FOR_UP = new int[]{0, 1, 2, 3, 4, 5, 6};
    private int cookingTime;
    private boolean isBeingBurned;
    private static final int MAX_COOKING_TIME = 300;
    private final class_3913 delegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> SmallCookingPotBlockEntity.this.cookingTime;
                case 1 -> {
                    if (SmallCookingPotBlockEntity.this.isBeingBurned) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    SmallCookingPotBlockEntity.this.cookingTime = value;
                    break;
                }
                case 1: {
                    SmallCookingPotBlockEntity.this.isBeingBurned = value != 0;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public SmallCookingPotBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)EntityTypeRegistry.SMALL_COOKING_POT_BLOCK_ENTITY.get(), pos, state);
    }

    public int @NotNull [] method_5494(class_2350 side) {
        int[] nArray;
        switch (side) {
            case field_11036: {
                nArray = SLOTS_FOR_UP;
                break;
            }
            case field_11033: {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 7;
                break;
            }
            default: {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = 6;
            }
        }
        return nArray;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.cookingTime = nbt.method_10550("CookingTime");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("CookingTime", this.cookingTime);
    }

    public boolean isBeingBurned() {
        if (this.field_11863 == null) {
            throw new IllegalStateException("Null world not allowed");
        }
        class_2680 belowState = this.field_11863.method_8320(this.field_11867.method_10074());
        return belowState.method_26164(TagRegistry.ALLOWS_COOKING);
    }

    private boolean canCraft(class_1860<?> recipe, class_5455 access) {
        if (recipe == null || recipe.method_8110(access).method_7960()) {
            return false;
        }
        if (recipe instanceof CookingPotRecipe) {
            CookingPotRecipe cookingRecipe = (CookingPotRecipe)recipe;
            class_1799 outputSlotStack = this.method_5438(7);
            class_1799 containerSlotStack = this.method_5438(6);
            boolean isContainerCorrect = containerSlotStack.method_31574(cookingRecipe.getContainer().method_7909());
            boolean isOutputSlotCompatible = outputSlotStack.method_7960() || class_1799.method_31577((class_1799)outputSlotStack, (class_1799)this.generateOutputItem(recipe, access)) && outputSlotStack.method_7947() < outputSlotStack.method_7914();
            return isContainerCorrect && isOutputSlotCompatible;
        }
        return false;
    }

    private void craft(class_1860<?> recipe, class_5455 access) {
        if (!this.canCraft(recipe, access)) {
            return;
        }
        class_1799 recipeOutput = this.generateOutputItem(recipe, access);
        class_1799 outputSlotStack = this.method_5438(7);
        if (outputSlotStack.method_7960()) {
            this.method_5447(7, recipeOutput);
        } else {
            outputSlotStack.method_7933(recipeOutput.method_7947());
        }
        recipe.method_8117().forEach(ingredient -> {
            for (int slot = 0; slot < 6; ++slot) {
                class_1799 stack = this.method_5438(slot);
                if (!ingredient.method_8093(stack)) continue;
                class_1799 remainderStack = stack.method_7909().method_7857() ? new class_1799((class_1935)Objects.requireNonNull(stack.method_7909().method_7858())) : class_1799.field_8037;
                stack.method_7934(1);
                if (remainderStack.method_7960()) break;
                this.method_5447(slot, remainderStack);
                break;
            }
        });
        class_1799 containerSlotStack = this.method_5438(6);
        if (!containerSlotStack.method_7960()) {
            containerSlotStack.method_7934(1);
            if (containerSlotStack.method_7960()) {
                this.method_5447(6, class_1799.field_8037);
            }
        }
    }

    private class_1799 generateOutputItem(class_1860<?> recipe, class_5455 access) {
        class_1799 outputStack = recipe.method_8110(access).method_7972();
        outputStack.method_7939(1);
        if (outputStack.method_7909() instanceof EffectFood) {
            recipe.method_8117().forEach(ingredient -> {
                for (int slot = 0; slot < 6; ++slot) {
                    class_1799 stack = this.method_5438(slot);
                    if (!ingredient.method_8093(stack)) continue;
                    EffectFoodHelper.getEffects((class_1799)stack).forEach(effect -> EffectFoodHelper.addEffect((class_1799)outputStack, (Pair)effect));
                    break;
                }
            });
        }
        return outputStack;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, SmallCookingPotBlockEntity blockEntity) {
        if (world.method_8608()) {
            return;
        }
        boolean wasBeingBurned = this.isBeingBurned;
        this.isBeingBurned = this.isBeingBurned();
        if (wasBeingBurned != this.isBeingBurned || (Boolean)state.method_11654((class_2769)SmallCookingPotBlock.LIT) != this.isBeingBurned) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)SmallCookingPotBlock.LIT, (Comparable)Boolean.valueOf(this.isBeingBurned)), 3);
        }
        if (!this.isBeingBurned) {
            return;
        }
        class_1860 recipe = world.method_8433().method_8132((class_3956)RecipeTypeRegistry.COOKING_POT_RECIPE_TYPE.get(), (class_1263)this, world).orElse(null);
        if (this.field_11863 == null) {
            throw new IllegalStateException("Null world not allowed");
        }
        class_5455 access = this.field_11863.method_30349();
        if (this.canCraft(recipe, access)) {
            if (++this.cookingTime >= 300) {
                this.cookingTime = 0;
                this.craft(recipe, access);
            }
            if (!((Boolean)state.method_11654((class_2769)SmallCookingPotBlock.COOKING)).booleanValue()) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)SmallCookingPotBlock.COOKING, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else {
            this.cookingTime = 0;
            if (((Boolean)state.method_11654((class_2769)SmallCookingPotBlock.COOKING)).booleanValue()) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)SmallCookingPotBlock.COOKING, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863 == null || this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new CookingPotGuiHandler(syncId, inv, (class_1263)this, this.delegate);
    }
}

