/*
 * Decompiled with CFR 0.152.
 */
package satisfy.beachparty.item;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import satisfy.beachparty.registry.ArmorMaterialRegistry;

public interface IBeachpartyArmorSet {
    public static final Map<class_1741, class_1293> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)ArmorMaterialRegistry.BIKINI, (Object)new class_1293(class_1294.field_5900, 280, 1)).put((Object)ArmorMaterialRegistry.TRUNKS, (Object)new class_1293(class_1294.field_5900, 280, 1)).put((Object)ArmorMaterialRegistry.SWIM_WINGS, (Object)new class_1293(class_1294.field_5900, 280, 0)).put((Object)ArmorMaterialRegistry.RING, (Object)new class_1293(class_1294.field_5900, 280, 1)).build();

    default public boolean hasSwimwearSet(class_1657 player) {
        return IBeachpartyArmorSet.hasSwimearBoots(player) && IBeachpartyArmorSet.hasSwimearLeggings(player) && IBeachpartyArmorSet.hasSwimwearBreastplate(player) && IBeachpartyArmorSet.hasSwimearHelmet(player);
    }

    default public void checkForSet(class_1657 player) {
        if (this.hasSwimwearSet(player)) {
            this.addStatusEffectForMaterial(player, new class_1293(class_1294.field_5900, 280, 2));
            this.addStatusEffectForMaterial(player, new class_1293(class_1294.field_5923, 280, 0));
        }
        this.hasSwimwear(player);
    }

    default public void hasSwimwear(class_1657 player) {
        for (Map.Entry<class_1741, class_1293> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            class_1741 mapArmorMaterial = entry.getKey();
            class_1293 mapStatusEffect = entry.getValue();
            if (!this.hasCorrectSwimWear(mapArmorMaterial, player)) continue;
            this.addStatusEffectForMaterial(player, mapStatusEffect);
        }
    }

    private boolean hasCorrectSwimWear(class_1741 material, class_1657 player) {
        if (material.equals((Object)ArmorMaterialRegistry.BIKINI) || material.equals((Object)ArmorMaterialRegistry.TRUNKS)) {
            int slot = 1;
            if (!player.method_31548().method_7372(slot).method_7960()) {
                class_1738 armor = (class_1738)player.method_31548().method_7372(slot).method_7909();
                return armor.method_7686() == material;
            }
            return false;
        }
        if (material.equals((Object)ArmorMaterialRegistry.SWIM_WINGS) || material.equals((Object)ArmorMaterialRegistry.RING)) {
            class_1792 class_17922;
            int slot = 2;
            if (!player.method_31548().method_7372(slot).method_7960() && (class_17922 = player.method_31548().method_7372(slot).method_7909()) instanceof class_1738) {
                class_1738 armor = (class_1738)class_17922;
                return armor.method_7686() == material;
            }
            return false;
        }
        return false;
    }

    default public void addStatusEffectForMaterial(class_1657 player, class_1293 mapStatusEffect) {
        boolean hasPlayerEffect = player.method_6059(mapStatusEffect.method_5579());
        if (!hasPlayerEffect || Objects.requireNonNull(player.method_6112(mapStatusEffect.method_5579())).method_5584() < 220) {
            player.method_6092(new class_1293(mapStatusEffect.method_5579(), mapStatusEffect.method_5584(), mapStatusEffect.method_5578(), true, false, true));
        }
    }

    public static boolean hasSwimearBoots(class_1657 player) {
        if (player.method_31548().method_7372(0).method_7960()) {
            return false;
        }
        class_1792 item = player.method_31548().method_7372(0).method_7909();
        if (item instanceof class_1738) {
            class_1738 armorItem = (class_1738)item;
            return IBeachpartyArmorSet.isSwimwearBoots(armorItem);
        }
        return false;
    }

    private static boolean isSwimwearBoots(class_1738 armorItem) {
        return armorItem.method_7686() == ArmorMaterialRegistry.CROCS;
    }

    public static boolean hasSwimearLeggings(class_1657 player) {
        if (player.method_31548().method_7372(1).method_7960()) {
            return false;
        }
        class_1792 item = player.method_31548().method_7372(1).method_7909();
        if (item instanceof class_1738) {
            class_1738 armorItem = (class_1738)item;
            return IBeachpartyArmorSet.isSwimwearLeggings(armorItem);
        }
        return false;
    }

    private static boolean isSwimwearLeggings(class_1738 armorItem) {
        return armorItem.method_7686() == ArmorMaterialRegistry.TRUNKS || armorItem.method_7686() == ArmorMaterialRegistry.BIKINI;
    }

    public static boolean hasSwimwearBreastplate(class_1657 player) {
        if (player.method_31548().method_7372(2).method_7960()) {
            return false;
        }
        class_1792 item = player.method_31548().method_7372(2).method_7909();
        if (item instanceof class_1738) {
            class_1738 armorItem = (class_1738)item;
            return IBeachpartyArmorSet.isSwimwearBreastplate(armorItem);
        }
        return false;
    }

    private static boolean isSwimwearBreastplate(class_1738 armorItem) {
        return armorItem.method_7686() == ArmorMaterialRegistry.RING || armorItem.method_7686() == ArmorMaterialRegistry.SWIM_WINGS;
    }

    public static boolean hasSwimearHelmet(class_1657 player) {
        if (player.method_31548().method_7372(3).method_7960()) {
            return false;
        }
        class_1792 item = player.method_31548().method_7372(3).method_7909();
        if (item instanceof class_1738) {
            class_1738 armorItem = (class_1738)item;
            return IBeachpartyArmorSet.isSwimwearHelmet(armorItem);
        }
        return false;
    }

    private static boolean isSwimwearHelmet(class_1738 armorItem) {
        return armorItem.method_7686() == ArmorMaterialRegistry.BEACH_HAT || armorItem.method_7686() == ArmorMaterialRegistry.SUNGLASSES;
    }
}

