/*
 * Decompiled with CFR 0.152.
 */
package satisfy.beachparty.util;

import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import org.apache.commons.compress.utils.Lists;
import satisfy.beachparty.registry.SoundEventRegistry;

@Environment(value=EnvType.CLIENT)
public class RadioHelper {
    private static final Map<class_2338, List<class_1109>> soundInstances = new HashMap<class_2338, List<class_1109>>();

    public static void setPlaying(class_2338 pos, int channel, boolean play, int delay) {
        if (play) {
            if (!soundInstances.containsKey(pos)) {
                RadioHelper.addSounds(pos);
            }
            RadioHelper.playSound(pos, channel, delay);
        } else {
            RadioHelper.stopSounds(pos);
        }
    }

    public static void tune(class_2338 pos, int channel) {
        class_310.method_1551().method_1483().method_4873((class_1113)new class_1109((class_3414)SoundEventRegistry.RADIO_TUNE.get(), class_3419.field_15247, 1.0f, 1.0f, class_5819.method_43047(), pos));
        RadioHelper.stopSounds(pos);
        if (!soundInstances.containsKey(pos)) {
            RadioHelper.addSounds(pos);
        }
        RadioHelper.playSound(pos, channel, 40);
    }

    private static void playSound(class_2338 pos, int channel, int delay) {
        class_1109 soundInstance = RadioHelper.getSound(pos, channel);
        if (soundInstance != null) {
            class_310.method_1551().method_1483().method_4872((class_1113)soundInstance, delay);
        }
    }

    private static void stopSounds(class_2338 pos) {
        if (soundInstances.containsKey(pos)) {
            for (class_1109 soundInstance : soundInstances.get(pos)) {
                class_310.method_1551().method_1483().method_4870((class_1113)soundInstance);
            }
        }
    }

    private static void addSounds(class_2338 blockPos) {
        ArrayList soundInstance = Lists.newArrayList();
        for (RegistrySupplier<class_3414> sound : SoundEventRegistry.RADIO_SOUNDS) {
            soundInstance.add(new class_1109(((class_3414)sound.get()).method_14833(), class_3419.field_15247, 1.0f, 1.0f, class_5819.method_43047(), true, 0, class_1113.class_1114.field_5476, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), false));
            soundInstances.put(blockPos, soundInstance);
        }
    }

    public static class_1109 getSound(class_2338 pos, int channel) {
        return soundInstances.get(pos).get(channel);
    }
}

