/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.entity.rope;

import dev.architectury.extensions.network.EntitySpawnExtension;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.satisfy.brewery.block.HopsCropBlock;
import net.satisfy.brewery.entity.rope.IRopeEntity;
import net.satisfy.brewery.networking.BreweryNetworking;
import net.satisfy.brewery.registry.EntityRegistry;
import net.satisfy.brewery.registry.ObjectRegistry;
import net.satisfy.brewery.util.rope.RopeConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HangingRopeEntity
extends class_1297
implements IRopeEntity,
EntitySpawnExtension {
    public static final int MAX_LENGTH = 8;
    @Nullable
    private RopeConnection connection;
    private boolean active;
    @Environment(value=EnvType.CLIENT)
    private int length;
    private int checkTimer = 50;

    public HangingRopeEntity(class_1299<? extends HangingRopeEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    private HangingRopeEntity(class_1937 level, double x, double y, double z, @NotNull RopeConnection connection, boolean active) {
        this((class_1299<? extends HangingRopeEntity>)((class_1299)EntityRegistry.HANGING_ROPE.get()), level);
        this.connection = connection;
        this.active = active;
        this.method_5814(x, y, z);
    }

    public static HangingRopeEntity create(class_1937 level, double x, double y, double z, RopeConnection connection) {
        return HangingRopeEntity.create(level, x, y, z, connection, true);
    }

    public static HangingRopeEntity create(class_1937 level, double x, double y, double z, RopeConnection connection, boolean active) {
        return new HangingRopeEntity(level, x, y, z, connection, active);
    }

    @Environment(value=EnvType.CLIENT)
    public class_243 getRopeVec() {
        return new class_243(0.0, (double)(-this.length), 0.0);
    }

    public boolean active() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void method_5773() {
        if (this.method_37908().method_8608()) {
            if (this.checkTimer++ >= 50) {
                this.checkTimer = 0;
                this.checkLength();
            }
            return;
        }
        if (this.connection != null && this.connection.needsBeDestroyed()) {
            this.connection.destroy(true);
        }
        if (this.connection == null || this.connection.dead()) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void checkLength() {
        int length;
        class_2338 blockPos = this.method_24515();
        for (length = 0; !this.method_37908().method_8320(blockPos.method_10087(length + 1)).method_51367() && length < 8; ++length) {
        }
        this.length = length;
    }

    @NotNull
    public class_1269 method_5688(class_1657 player, class_1268 interactionHand) {
        boolean changed;
        class_1799 itemStack = player.method_5998(interactionHand);
        boolean bl = changed = !this.active && itemStack.method_31574((class_1792)ObjectRegistry.ROPE.get()) || this.active && IRopeEntity.canDestroyWith(itemStack);
        if (changed) {
            class_1937 class_19372;
            boolean bl2 = this.active = !this.active;
            if (this.connection != null && !player.method_37908().field_9236) {
                this.connection.setActive(this.active, this.method_5628());
            }
            if ((class_19372 = player.method_37908()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                this.sendChangePacket(serverLevel);
                if (!this.active) {
                    HangingRopeEntity.notifyBlock(this.method_24515(), serverLevel, HopsCropBlock.getHeadBlock());
                }
            }
            player.method_5783(this.active ? class_3417.field_15062 : class_3417.field_15184, 0.5f, 1.0f);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static void notifyBlock(class_2338 blockPos, class_3218 serverLevel, class_2248 block) {
        for (int below = 0; below < 8; ++below) {
            class_2338 belowPos = blockPos.method_10087(below);
            class_2680 blockState = serverLevel.method_8320(belowPos);
            if (!blockState.method_27852(block)) continue;
            serverLevel.method_39279(belowPos, blockState.method_26204(), 1);
            return;
        }
    }

    private void sendChangePacket(class_3218 serverLevel) {
        List trackingPlayers = serverLevel.method_18456();
        for (class_3222 serverPlayer : trackingPlayers) {
            class_2540 buf = BreweryNetworking.createPacketBuf();
            buf.writeInt(this.method_5628());
            buf.writeBoolean(this.active);
            NetworkManager.sendToPlayer((class_3222)serverPlayer, (class_2960)BreweryNetworking.CHANGE_HANGING_ROPE_S2C_ID, (class_2540)buf);
        }
    }

    public boolean method_5698(class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            this.method_5643(this.method_48923().method_48802(player), 0.0f);
        } else {
            this.method_5783(class_3417.field_14628, 0.5f, 1.0f);
        }
        return true;
    }

    public boolean method_5643(class_1282 damageSource, float f) {
        class_1269 result = IRopeEntity.onDamageFrom(this, damageSource);
        if (result.method_23665()) {
            this.destroyConnections(result == class_1269.field_5812);
            return true;
        }
        return false;
    }

    public void method_5814(double x, double y, double z) {
        super.method_5814((double)class_3532.method_15357((double)x) + 0.5, y, (double)class_3532.method_15357((double)z) + 0.5);
    }

    @NotNull
    public class_243 method_29919() {
        return new class_243(0.0, (double)((class_1299)EntityRegistry.HANGING_ROPE.get()).method_17686(), 0.0);
    }

    @Environment(value=EnvType.CLIENT)
    @NotNull
    public class_243 method_30951(float f) {
        return this.method_30950(f).method_1019(this.method_29919());
    }

    protected float method_18378(class_4050 pose, class_4048 dimensions) {
        return ((class_1299)EntityRegistry.HANGING_ROPE.get()).method_17686() / 2.0f;
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_30948() {
        return false;
    }

    @Override
    public void destroyConnections(boolean mayDrop) {
        if (this.connection != null) {
            this.connection.destroy(mayDrop);
        }
    }

    protected void method_5693() {
    }

    protected void method_5652(class_2487 compoundTag) {
    }

    protected void method_5749(class_2487 compoundTag) {
    }

    public class_2596<class_2602> method_18002() {
        return NetworkManager.createAddEntityPacket((class_1297)this);
    }

    public void saveAdditionalSpawnData(class_2540 buf) {
        buf.writeBoolean(this.active);
    }

    public void loadAdditionalSpawnData(class_2540 buf) {
        this.active = buf.readBoolean();
    }
}

