/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_1263;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.satisfy.brewery.block.property.BrewMaterial;
import net.satisfy.brewery.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class BrewingRecipe
implements class_1860<class_1263> {
    private final class_2960 identifier;
    private final class_2371<class_1856> ingredients;
    private final class_1799 output;
    private final BrewMaterial material;

    public BrewingRecipe(class_2960 identifier, class_2371<class_1856> ingredients, class_1799 output, BrewMaterial material) {
        this.identifier = identifier;
        this.ingredients = ingredients;
        this.output = output;
        this.material = material;
    }

    public BrewMaterial getMaterial() {
        return this.material;
    }

    public boolean method_8115(class_1263 inventory, class_1937 world) {
        class_1662 recipeMatcher = new class_1662();
        int matchingStacks = 0;
        for (int i = 0; i < 3; ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            ++matchingStacks;
            recipeMatcher.method_20478(itemStack, 1);
        }
        return matchingStacks == this.ingredients.size() && recipeMatcher.method_7402((class_1860)this, null);
    }

    @NotNull
    public class_1799 method_8116(class_1263 container, class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    @NotNull
    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    @NotNull
    public class_1799 method_8110(class_5455 registryAccess) {
        return this.output.method_7972();
    }

    @NotNull
    public class_2960 method_8114() {
        return this.identifier;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return (class_1865)RecipeTypeRegistry.BREWING_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public class_3956<?> method_17716() {
        return (class_3956)RecipeTypeRegistry.BREWING_RECIPE_TYPE.get();
    }

    public boolean method_8118() {
        return true;
    }

    public static class Serializer
    implements class_1865<BrewingRecipe> {
        @NotNull
        public BrewingRecipe fromJson(class_2960 resourceLocation, JsonObject jsonObject) {
            class_2371<class_1856> ingredients = Serializer.deserializeIngredients(class_3518.method_15261((JsonObject)jsonObject, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for Brewing");
            }
            if (ingredients.size() > 3) {
                throw new JsonParseException("Too many ingredients for Brewing");
            }
            BrewMaterial brewMaterial = BrewMaterial.valueOf(jsonObject.get("material").getAsString());
            return new BrewingRecipe(resourceLocation, ingredients, class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"result")), brewMaterial);
        }

        public static class_2371<class_1856> deserializeIngredients(JsonArray json) {
            class_2371 ingredients = class_2371.method_10211();
            for (int i = 0; i < json.size(); ++i) {
                class_1856 ingredient = class_1856.method_52177((JsonElement)json.get(i));
                if (ingredient.method_8103()) continue;
                ingredients.add((Object)ingredient);
            }
            return ingredients;
        }

        @NotNull
        public BrewingRecipe fromNetwork(class_2960 id, class_2540 buf) {
            class_2371 ingredients = class_2371.method_10213((int)buf.method_10816(), (Object)class_1856.field_9017);
            ingredients.replaceAll(ignored -> class_1856.method_8086((class_2540)buf));
            return new BrewingRecipe(id, (class_2371<class_1856>)ingredients, buf.method_10819(), (BrewMaterial)buf.method_10818(BrewMaterial.class));
        }

        public void toNetwork(class_2540 buf, BrewingRecipe recipe) {
            buf.method_10804(recipe.ingredients.size());
            for (class_1856 ingredient : recipe.ingredients) {
                ingredient.method_8088(buf);
            }
            buf.method_10793(recipe.output);
            buf.method_10817((Enum)recipe.material);
        }
    }
}

