/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery;

import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.PlayerEvent;
import net.satisfy.brewery.block.brew_event.BrewEvents;
import net.satisfy.brewery.event.BlockClickEvent;
import net.satisfy.brewery.event.CommonEvents;
import net.satisfy.brewery.event.PartyStarterEvent;
import net.satisfy.brewery.event.PlayerCloneEvent;
import net.satisfy.brewery.event.PlayerRespawnEvent;
import net.satisfy.brewery.networking.BreweryNetworking;
import net.satisfy.brewery.registry.BlockEntityRegistry;
import net.satisfy.brewery.registry.DataFixerRegistry;
import net.satisfy.brewery.registry.EntityRegistry;
import net.satisfy.brewery.registry.MobEffectRegistry;
import net.satisfy.brewery.registry.ObjectRegistry;
import net.satisfy.brewery.registry.RecipeTypeRegistry;
import net.satisfy.brewery.registry.TabRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Brewery {
    public static final String MOD_ID = "brewery";
    public static final Logger LOGGER = LogManager.getLogger((String)"brewery");

    public static void init() {
        LOGGER.debug("Initiate brewery");
        DataFixerRegistry.init();
        ObjectRegistry.init();
        TabRegistry.init();
        BlockEntityRegistry.init();
        EntityRegistry.init();
        MobEffectRegistry.init();
        BrewEvents.loadClass();
        CommonEvents.init();
        BreweryNetworking.registerC2SPackets();
        RecipeTypeRegistry.init();
        Brewery.registerEvents();
    }

    private static void registerEvents() {
        PartyStarterEvent partyStarterEvent = new PartyStarterEvent();
        PlayerEvent.PLAYER_RESPAWN.register((Object)new PlayerRespawnEvent());
        PlayerEvent.ATTACK_ENTITY.register((Object)partyStarterEvent);
        PlayerEvent.PLAYER_CLONE.register((Object)new PlayerCloneEvent());
        InteractionEvent.RIGHT_CLICK_BLOCK.register((Object)new BlockClickEvent());
    }
}

