/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.block;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.satisfy.brewery.block.HopsCropBodyBlock;
import net.satisfy.brewery.block.HopsCropHeadBlock;
import net.satisfy.brewery.block.entity.rope.HangingRopeEntity;
import net.satisfy.brewery.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.registry.TagRegistry;
import org.jetbrains.annotations.NotNull;

public abstract class HopsCropBlock
extends class_2248 {
    public static final class_2758 AGE = class_2741.field_12497;
    private static final int MAX_AGE = 3;
    protected final class_265 shape;

    protected HopsCropBlock(class_4970.class_2251 arg, class_265 shape) {
        super(arg);
        this.shape = shape;
    }

    public static HopsCropHeadBlock getHeadBlock() {
        return (HopsCropHeadBlock)((Object)ObjectRegistry.HOPS_CROP.get());
    }

    public static HopsCropBodyBlock getBodyBlock() {
        return (HopsCropBodyBlock)((Object)ObjectRegistry.HOPS_CROP_BODY.get());
    }

    protected static boolean isRopeAbove(class_1936 levelAccessor, class_2338 blockPos) {
        List results = levelAccessor.method_18467(HangingRopeEntity.class, new class_238(blockPos.method_10084(), blockPos.method_10084().method_10069(1, 8, 1)));
        for (HangingRopeEntity hangingRope : results) {
            if (!hangingRope.active()) continue;
            return true;
        }
        return false;
    }

    protected static int getHeight(class_2338 blockPos, class_1936 levelAccessor) {
        int height = 0;
        while (levelAccessor.method_8320(blockPos.method_10087(height)).method_26204() instanceof HopsCropBlock) {
            ++height;
        }
        return height;
    }

    @NotNull
    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        return this.shape;
    }

    public class_2680 method_9605(class_1750 context) {
        class_2680 blockState = context.method_8045().method_8320(context.method_8037().method_10084());
        return !blockState.method_27852((class_2248)HopsCropBlock.getHeadBlock()) && !blockState.method_27852((class_2248)HopsCropBlock.getBodyBlock()) ? this.method_9564() : HopsCropBlock.getBodyBlock().method_9564();
    }

    @NotNull
    public class_2680 getStateForAge(int age) {
        return (class_2680)this.method_9564().method_11657((class_2769)AGE, (Comparable)Integer.valueOf(Math.min(age, 3)));
    }

    public boolean method_9558(class_2680 blockState, class_4538 levelReader, class_2338 blockPos) {
        class_2338 belowPos = blockPos.method_10093(class_2350.field_11033);
        class_2680 belowState = levelReader.method_8320(belowPos);
        return this.mayPlaceOn(belowState) || belowState.method_27852((class_2248)HopsCropBlock.getHeadBlock()) || belowState.method_27852((class_2248)HopsCropBlock.getBodyBlock());
    }

    protected boolean mayPlaceOn(class_2680 blockState) {
        return blockState.method_26164(TagRegistry.FARMLAND);
    }

    protected boolean canGrow(class_2680 blockState) {
        return (Integer)blockState.method_11654((class_2769)AGE) < 3;
    }

    @NotNull
    public class_1269 method_9534(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        if (player.method_5998(interactionHand).method_31574(class_1802.field_8324)) {
            return class_1269.field_5811;
        }
        int age = (Integer)blockState.method_11654((class_2769)AGE);
        if (age > 1) {
            this.dropHops(level, blockPos, blockState);
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return super.method_9534(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    protected void dropHops(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        int age = (Integer)blockState.method_11654((class_2769)AGE);
        int amount = level.method_8409().method_43048(2);
        HopsCropBlock.method_9577((class_1937)level, (class_2338)blockPos, (class_1799)new class_1799((class_1935)ObjectRegistry.HOPS.get(), amount + (age >= 3 ? 1 : 0)));
        level.method_8396(null, blockPos, class_3417.field_17617, class_3419.field_15245, 1.0f, 0.8f + level.field_9229.method_43057() * 0.4f);
        level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(1)), 2);
    }

    public void method_9588(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        if (!blockState.method_26184((class_4538)serverLevel, blockPos)) {
            serverLevel.method_22352(blockPos, true);
        }
    }

    public boolean method_9542(class_2680 blockState) {
        return this.canGrow(blockState);
    }

    public void method_9514(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        int age;
        if (serverLevel.method_22335(blockPos, 0) >= 9 && (age = ((Integer)blockState.method_11654((class_2769)AGE)).intValue()) < 3 && (double)randomSource.method_43057() < 0.2) {
            serverLevel.method_8652(blockPos, this.getStateForAge(age + 1), 2);
        }
    }

    public boolean method_9579(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos) {
        return blockState.method_26227().method_15769();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AGE});
    }
}

