/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.client.render;

import de.cristelknight.doapi.client.ClientUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import net.satisfy.brewery.block.brewingstation.BrewingstationBlock;
import net.satisfy.brewery.block.entity.BrewstationBlockEntity;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class BrewingstationRenderer
implements class_827<BrewstationBlockEntity> {
    public BrewingstationRenderer(class_5614.class_5615 ctx) {
    }

    public void render(BrewstationBlockEntity entity, float partialTicks, class_4587 matrixStack, class_4597 bufferSource, int combinedLight, int combinedOverlay) {
        if (!entity.method_11002() || !(entity.method_11010().method_26204() instanceof BrewingstationBlock)) {
            return;
        }
        List<class_1799> ingredients = entity.getIngredient();
        if (ingredients.isEmpty()) {
            return;
        }
        matrixStack.method_22903();
        this.setupInitialTransform(matrixStack, entity);
        Random random = new Random(entity.method_11016().hashCode());
        float angleOffset = 360.0f / (float)ingredients.size();
        for (int index = 0; index < ingredients.size(); ++index) {
            class_1799 stack = ingredients.get(index);
            matrixStack.method_22903();
            Vector3f position = this.calculateItemPosition(index, angleOffset, ingredients.size());
            this.applyItemTransform(matrixStack, position, angleOffset * (float)index);
            this.renderItems(matrixStack, bufferSource, entity, stack, random);
            matrixStack.method_22909();
        }
        matrixStack.method_22909();
    }

    private void setupInitialTransform(class_4587 matrixStack, BrewstationBlockEntity entity) {
        matrixStack.method_22905(0.5f, 0.5f, 0.5f);
        matrixStack.method_46416(1.0f, 0.3f, 1.0f);
    }

    private Vector3f calculateItemPosition(int index, float angleOffset, int itemCount) {
        if (itemCount == 1) {
            return new Vector3f(0.0f, 0.3f, 0.0f);
        }
        double angleRad = Math.toRadians(angleOffset * (float)index);
        return new Vector3f((float)(0.125 * Math.cos(angleRad)), 0.3f, (float)(0.125 * Math.sin(angleRad)));
    }

    private void applyItemTransform(class_4587 matrixStack, Vector3f position, float angle) {
        Quaternionf rotation = new Quaternionf().rotateY(angle + 35.0f).rotateX(65.0f);
        matrixStack.method_46416(position.x, position.y, position.z);
        matrixStack.method_22907(rotation);
    }

    private void renderItems(class_4587 matrixStack, class_4597 bufferSource, BrewstationBlockEntity entity, class_1799 stack, Random random) {
        for (int i = 0; i <= stack.method_7947() / 8; ++i) {
            matrixStack.method_22903();
            Vector3f offset = this.offsetRandomly(random);
            matrixStack.method_46416(offset.x, offset.y, offset.z);
            ClientUtil.renderItem((class_1799)stack, (class_4587)matrixStack, (class_4597)bufferSource, (class_2586)entity);
            matrixStack.method_22909();
        }
    }

    private Vector3f offsetRandomly(Random random) {
        return new Vector3f((random.nextFloat() - 0.5f) * 2.0f * 0.0625f, (random.nextFloat() - 0.5f) * 2.0f * 0.0625f, (random.nextFloat() - 0.5f) * 2.0f * 0.0625f);
    }
}

