/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.client.render;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.satisfy.brewery.client.model.RopeModel;
import net.satisfy.brewery.util.rope.RopeHelper;
import net.satisfy.brewery.util.rope.UVCord;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RopeRender {
    private static final float SCALE = 1.0f;
    private static final float QUALITY = 4.0f;
    private static final int MAX_SEGMENTS = 2048;
    private static final class_243 POSITIVE_Y = new class_243(0.0, 1.0, 0.0);
    private static final class_243 NEGATIVE_Y = new class_243(0.0, -1.0, 0.0);
    private final Map<Integer, RopeModel> models = new HashMap<Integer, RopeModel>(256);

    public void render(class_4588 vertexConsumer, class_4587 poseStack, class_243 ropeVec, int entityId, int blockLight0, int blockLight1, int skyLight0, int skyLight1) {
        RopeModel model;
        int hash = this.getVectorHash(ropeVec, entityId);
        if (this.models.containsKey(hash)) {
            model = this.models.get(hash);
        } else {
            model = this.buildModel(ropeVec);
            this.models.put(hash, model);
        }
        model.render(vertexConsumer, poseStack, blockLight0, blockLight1, skyLight0, skyLight1);
    }

    private RopeModel buildModel(class_243 ropeVec) {
        float desiredSegmentLength = 0.25f;
        int initialCapacity = (int)(2.0 * ropeVec.method_1027() / (double)desiredSegmentLength);
        RopeModel.Builder builder = RopeModel.builder(initialCapacity);
        this.createModel(builder, ropeVec, 45, UVCord.DEFAULT_ROPE_H);
        this.createModel(builder, ropeVec, -45, UVCord.DEFAULT_ROPE_V);
        return builder.build();
    }

    private void createModel(RopeModel.Builder builder, class_243 ropeVec, int degrees, UVCord uv) {
        float length = (float)ropeVec.method_1033();
        class_243 ropeNormal = ropeVec.method_1029();
        Quaternionf quaternion = new Quaternionf().rotateAxis((float)Math.toRadians(degrees), (float)ropeNormal.method_10216(), (float)ropeNormal.method_10214(), (float)ropeNormal.method_10215());
        Vector3f crossVec = ropeNormal.equals((Object)POSITIVE_Y) || ropeNormal.equals((Object)NEGATIVE_Y) ? new Vector3f(1.0f, 0.0f, 0.0f) : new Vector3f((float)ropeNormal.method_1036((class_243)RopeRender.POSITIVE_Y).method_1029().field_1352, (float)ropeNormal.method_1036((class_243)RopeRender.POSITIVE_Y).method_1029().field_1351, (float)ropeNormal.method_1036((class_243)RopeRender.POSITIVE_Y).method_1029().field_1350);
        crossVec.rotate((Quaternionfc)quaternion);
        crossVec.mul((uv.x1() - uv.x0()) / 16.0f * 1.0f);
        crossVec.mul(0.5f);
        float uvEnd = 0.0f;
        double segmentLength = Math.min(length, 0.25f);
        Vector3f currentPos = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f lastPos = new Vector3f();
        Vector3f segmentVector = new Vector3f((float)ropeNormal.method_18805((double)segmentLength, (double)segmentLength, (double)segmentLength).field_1352, (float)ropeNormal.method_18805((double)segmentLength, (double)segmentLength, (double)segmentLength).field_1351, (float)ropeNormal.method_18805((double)segmentLength, (double)segmentLength, (double)segmentLength).field_1350);
        Vector3f segmentPos = new Vector3f(0.0f, 0.0f, 0.0f);
        boolean lastIter = false;
        boolean straight = ropeVec.field_1352 == 0.0 && ropeVec.field_1350 == 0.0;
        for (int segment = 0; segment < 2048; ++segment) {
            block6: {
                block5: {
                    lastPos.set((Vector3fc)currentPos);
                    segmentPos.add((Vector3fc)segmentVector);
                    if (straight) break block5;
                    class_243 class_2432 = new class_243(segmentPos);
                    if (!(class_2432.method_1033() > (double)length)) break block6;
                }
                lastIter = true;
                segmentPos.set((float)ropeVec.field_1352, (float)ropeVec.field_1351, (float)ropeVec.field_1350);
            }
            currentPos.set((Vector3fc)segmentPos);
            if (!straight) {
                currentPos.add(0.0f, (float)RopeHelper.getYHanging(new class_243(segmentPos).method_1033(), ropeVec), 0.0f);
            }
            double actuallySegmentLength = new class_243(currentPos).method_1022(new class_243(lastPos));
            float uvStart = uvEnd;
            builder.vertex(lastPos.x() - crossVec.x(), lastPos.y() - crossVec.y(), lastPos.z() - crossVec.z()).uv(uv.x0() / 16.0f, uvStart).next();
            builder.vertex(lastPos.x() + crossVec.x(), lastPos.y() + crossVec.y(), lastPos.z() + crossVec.z()).uv(uv.x1() / 16.0f, uvStart).next();
            builder.vertex(currentPos.x() + crossVec.x(), currentPos.y() + crossVec.y(), currentPos.z() + crossVec.z()).uv(uv.x1() / 16.0f, uvEnd += (float)(actuallySegmentLength / 1.0)).next();
            builder.vertex(currentPos.x() - crossVec.x(), currentPos.y() - crossVec.y(), currentPos.z() - crossVec.z()).uv(uv.x0() / 16.0f, uvEnd).next();
            if (lastIter) break;
        }
    }

    private int getVectorHash(class_243 ropeVec, int id) {
        return Objects.hash(id, ropeVec.field_1352, ropeVec.field_1351, ropeVec.field_1350);
    }
}

