/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2960;
import net.minecraft.class_4081;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.satisfy.brewery.Brewery;
import net.satisfy.brewery.effect.BlackoutEffect;
import net.satisfy.brewery.effect.CombustionEffect;
import net.satisfy.brewery.effect.DrunkEffect;
import net.satisfy.brewery.effect.ExplosionEffect;
import net.satisfy.brewery.effect.HaleyEffect;
import net.satisfy.brewery.effect.HealingTouchEffect;
import net.satisfy.brewery.effect.LightningStrikeEffect;
import net.satisfy.brewery.effect.MiningEffect;
import net.satisfy.brewery.effect.PacifyEffect;
import net.satisfy.brewery.effect.PartystarterEffect;
import net.satisfy.brewery.effect.PintCharismaEffect;
import net.satisfy.brewery.effect.ProtectiveTouchEffect;
import net.satisfy.brewery.effect.RenewingTouchEffect;
import net.satisfy.brewery.effect.RepulsionEffect;
import net.satisfy.brewery.effect.SnowWhiteEffect;
import net.satisfy.brewery.effect.ToxicTouchEffect;
import net.satisfy.brewery.util.BreweryIdentifier;

public class MobEffectRegistry {
    public static final RegistrySupplier<class_1291> DRUNK;
    public static final RegistrySupplier<class_1291> BLACKOUT;
    public static final RegistrySupplier<class_1291> RENEWINGTOUCH;
    public static final RegistrySupplier<class_1291> TOXICTOUCH;
    public static final RegistrySupplier<class_1291> HEALINGTOUCH;
    public static final RegistrySupplier<class_1291> PROTECTIVETOUCH;
    public static final RegistrySupplier<class_1291> PARTYSTARTER;
    public static final RegistrySupplier<class_1291> SNOWWHITE;
    public static final RegistrySupplier<class_1291> PINTCHARISMA;
    public static final RegistrySupplier<class_1291> HALEY;
    public static final RegistrySupplier<class_1291> MINING;
    public static final RegistrySupplier<class_1291> PACIFY;
    public static final RegistrySupplier<class_1291> COMBUSTION;
    public static final RegistrySupplier<class_1291> EXPLOSION;
    public static final RegistrySupplier<class_1291> REPULSION;
    public static final RegistrySupplier<class_1291> LIGHTNING_STRIKE;
    private static final DeferredRegister<class_1291> MOB_EFFECTS;
    private static final Registrar<class_1291> MOB_EFFECTS_REGISTRAR;

    private static RegistrySupplier<class_1291> registerEffect(String name, Supplier<class_1291> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((class_2960)new BreweryIdentifier(name), effect);
    }

    public static void init() {
        Brewery.LOGGER.debug("Mob effects");
        MOB_EFFECTS.register();
    }

    static {
        MOB_EFFECTS = DeferredRegister.create((String)"brewery", (class_5321)class_7924.field_41208);
        MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
        DRUNK = MobEffectRegistry.registerEffect("drunk", DrunkEffect::new);
        BLACKOUT = MobEffectRegistry.registerEffect("blackout", () -> new BlackoutEffect().method_42126(() -> new class_1293.class_7247(22)));
        MINING = MobEffectRegistry.registerEffect("mining", () -> new MiningEffect(class_4081.field_18271, 0));
        PACIFY = MobEffectRegistry.registerEffect("pacify", () -> new PacifyEffect(class_4081.field_18271, 0));
        REPULSION = MobEffectRegistry.registerEffect("repulsion", () -> new RepulsionEffect(class_4081.field_18271, 0));
        LIGHTNING_STRIKE = MobEffectRegistry.registerEffect("lightning_strike", () -> new LightningStrikeEffect(class_4081.field_18271, 0));
        EXPLOSION = MobEffectRegistry.registerEffect("explosion", () -> new ExplosionEffect(class_4081.field_18271, 0));
        COMBUSTION = MobEffectRegistry.registerEffect("combustion", () -> new CombustionEffect(class_4081.field_18271, 0));
        TOXICTOUCH = MobEffectRegistry.registerEffect("toxictouch", () -> new ToxicTouchEffect(class_4081.field_18271, 0));
        RENEWINGTOUCH = MobEffectRegistry.registerEffect("renewingtouch", () -> new RenewingTouchEffect(class_4081.field_18271, 0));
        HEALINGTOUCH = MobEffectRegistry.registerEffect("healingtouch", () -> new HealingTouchEffect(class_4081.field_18271, 0));
        PROTECTIVETOUCH = MobEffectRegistry.registerEffect("protectivetouch", () -> new ProtectiveTouchEffect(class_4081.field_18271, 0));
        PARTYSTARTER = MobEffectRegistry.registerEffect("partystarter", () -> new PartystarterEffect(class_4081.field_18271, 0));
        SNOWWHITE = MobEffectRegistry.registerEffect("snowwhite", () -> new SnowWhiteEffect(class_4081.field_18271, 0));
        PINTCHARISMA = MobEffectRegistry.registerEffect("pintcharisma", () -> new PintCharismaEffect(class_4081.field_18271, 0));
        HALEY = MobEffectRegistry.registerEffect("haley", () -> new HaleyEffect(class_4081.field_18271, 0));
    }
}

