/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.util;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.satisfy.brewery.block.entity.rope.RopeKnotEntity;
import net.satisfy.brewery.util.rope.RopeConnection;

public class BreweryMath {
    public static int getRandomHighNumber(class_5819 rnd, int lowerBound, int upperBound) {
        int range = upperBound - lowerBound + 1;
        return upperBound - (int)(Math.pow(rnd.method_43058(), 1.5) * (double)range);
    }

    public static class_2338 ofFloored(class_243 vec) {
        return BreweryMath.ofFloored(vec.method_10216(), vec.method_10214(), vec.method_10215());
    }

    public static class_2338 ofFloored(double x, double y, double z) {
        return new class_2338(class_3532.method_15357((double)x), class_3532.method_15357((double)y), class_3532.method_15357((double)z));
    }

    public static Set<class_2338> lineIntersection(RopeConnection connection) {
        class_1297 class_12972 = connection.to();
        if (class_12972 instanceof RopeKnotEntity) {
            RopeKnotEntity toKnot = (RopeKnotEntity)class_12972;
            class_2338 start = connection.from().method_6896();
            class_2338 end = toKnot.method_6896();
            return BreweryMath.lineIntersection(start.method_10263(), start.method_10264(), start.method_10260(), end.method_10263(), end.method_10264(), end.method_10260());
        }
        return new HashSet<class_2338>();
    }

    private static Set<class_2338> lineIntersection(int startX, int startY, int startZ, int endX, int endY, int endZ) {
        HashSet<class_2338> blockPositions = new HashSet<class_2338>();
        if (endX - startX == 0 && endZ - startZ == 0) {
            return blockPositions;
        }
        boolean switchX = false;
        if (startX > endX) {
            int temp = startX;
            startX = endX;
            endX = temp;
            switchX = true;
        }
        boolean switchY = false;
        if (startY > endY) {
            int temp = startY;
            startY = endY;
            endY = temp;
            switchY = true;
        }
        boolean switchZ = false;
        if (startZ > endZ) {
            int temp = startZ;
            startZ = endZ;
            endZ = temp;
            switchZ = true;
        }
        int dx = endX - startX;
        int dy = endY - startY;
        int dz = endZ - startZ;
        int gcd = BreweryMath.gcd(BreweryMath.gcd(dx, dy), dz);
        if (gcd == 0) {
            return blockPositions;
        }
        for (int t = 1; t < gcd; ++t) {
            int x = switchX ? endX - dx * t / gcd : startX + dx * t / gcd;
            int y = switchY ? endY - dy * t / gcd : startY + dy * t / gcd;
            int z = switchZ ? endZ - dz * t / gcd : startZ + dz * t / gcd;
            blockPositions.add(new class_2338(x, y, z));
        }
        return blockPositions;
    }

    public static int gcd(int a, int b) {
        if (b == 0) {
            return a;
        }
        return BreweryMath.gcd(b, a % b);
    }

    public static class_243 middleOf(class_243 a, class_243 b) {
        double x = (a.method_10216() - b.method_10216()) / 2.0 + b.method_10216();
        double y = (a.method_10214() - b.method_10214()) / 2.0 + b.method_10214();
        double z = (a.method_10215() - b.method_10215()) / 2.0 + b.method_10215();
        return new class_243(x, y, z);
    }
}

