/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.client.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_364;
import net.minecraft.class_3728;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5225;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_768;
import net.satisfy.candlelight.util.CandlelightIdentifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public abstract class NoteGui
extends class_437 {
    public static final class_2960 NOTE_TEXTURE = new CandlelightIdentifier("textures/gui/note_paper_gui.png");
    private static final class_2561 EDIT_TITLE_TEXT = class_2561.method_43470((String)"Enter Note Title");
    private static final class_2561 FINALIZE_WARNING_TEXT = class_2561.method_43471((String)"book.finalizeWarning");
    private static final class_5481 BLACK_CURSOR_TEXT = class_5481.method_30747((String)"_", (class_2583)class_2583.field_24360.method_10977(class_124.field_1074));
    private static final class_5481 GRAY_CURSOR_TEXT = class_5481.method_30747((String)"_", (class_2583)class_2583.field_24360.method_10977(class_124.field_1080));
    protected final class_1657 player;
    protected final class_1799 itemStack;
    private final List<String> text = Lists.newArrayList();
    private final class_2561 signedByText;
    protected boolean dirty;
    private boolean signing;
    private int frameTick;
    private String title = "";
    private final class_3728 noteTitleSelectionManager = new class_3728(() -> this.title, title -> {
        this.title = title;
    }, this::getClipboard, this::setClipboard, string -> string.length() < 16);
    private long lastClickTime;
    private int lastClickIndex = -1;
    private class_4185 doneButton;
    private class_4185 signButton;
    private class_4185 finalizeButton;
    private class_4185 cancelButton;
    @Nullable
    private DisplayCache pageContent;
    private final class_3728 currentPageSelectionManager = new class_3728(this::getCurrentDisplayCache, this::setDisplayCache, this::getClipboard, this::setClipboard, string -> string.length() < 1024 && this.field_22793.method_1713(string, 114) <= 128);

    public NoteGui(class_1657 player, class_1799 itemStack) {
        super(class_333.field_18967);
        this.pageContent = DisplayCache.EMPTY;
        this.player = player;
        this.itemStack = itemStack;
        class_2487 nbtCompound = itemStack.method_7969();
        if (nbtCompound != null) {
            List<String> string2 = this.text;
            Objects.requireNonNull(string2);
            this.loadPages(nbtCompound, string2::add);
        }
        if (this.text.isEmpty()) {
            this.text.add("");
        }
        this.signedByText = class_2561.method_43469((String)"book.byAuthor", (Object[])new Object[]{player.method_5477()}).method_27692(class_124.field_1063);
    }

    static int getLineFromOffset(int[] lineStarts, int position) {
        int i = Arrays.binarySearch(lineStarts, position);
        return i < 0 ? -(i + 2) : i;
    }

    static int findLineFromPos(int[] is, int i) {
        int j = Arrays.binarySearch(is, i);
        return j < 0 ? -(j + 2) : j;
    }

    protected void method_25426() {
        this.invalidateDisplayCache();
        this.signButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"book.signButton"), button -> {
            this.signing = true;
            this.updateButtons();
        }).method_46434(this.field_22789 / 2 - 100, 196, 98, 20).method_46431());
        this.doneButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
            assert (this.field_22787 != null);
            this.field_22787.method_1507(null);
            this.finalizeNote(false);
        }).method_46434(this.field_22789 / 2 + 2, 196, 98, 20).method_46431());
        this.finalizeButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"book.finalizeButton"), button -> {
            if (this.signing) {
                this.finalizeNote(true);
                assert (this.field_22787 != null);
                this.field_22787.method_1507(null);
            }
        }).method_46434(this.field_22789 / 2 - 100, 196, 98, 20).method_46431());
        this.cancelButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, button -> {
            if (this.signing) {
                this.signing = false;
            }
            this.updateButtons();
        }).method_46434(this.field_22789 / 2 + 2, 196, 98, 20).method_46431());
        this.updateButtons();
    }

    public void loadPages(class_2487 compoundTag, Consumer<String> consumer) {
        IntFunction<String> intFunction;
        class_2499 listTag = compoundTag.method_10554("text", 8).method_10612();
        if (class_310.method_1551().method_33883() && compoundTag.method_10573("filtered_pages", 10)) {
            class_2487 compoundTag2 = compoundTag.method_10562("filtered_pages");
            intFunction = i -> {
                String string = String.valueOf(i);
                return compoundTag2.method_10545(string) ? compoundTag2.method_10558(string) : listTag.method_10608(i);
            };
        } else {
            intFunction = arg_0 -> ((class_2499)listTag).method_10608(arg_0);
        }
        for (int i2 = 0; i2 < listTag.size(); ++i2) {
            consumer.accept(intFunction.apply(i2));
        }
    }

    protected void removeEmptyPages() {
        ListIterator<String> listIterator = this.text.listIterator(this.text.size());
        while (listIterator.hasPrevious() && listIterator.previous().isEmpty()) {
            listIterator.remove();
        }
    }

    protected abstract void finalizeNote(boolean var1);

    protected void writeNbtData(boolean signNote) {
        class_2499 nbtList = new class_2499();
        Stream<class_2519> nbts = this.text.stream().map(class_2519::method_23256);
        Objects.requireNonNull(nbtList);
        nbts.forEach(arg_0 -> nbtList.add(arg_0));
        if (!this.text.isEmpty()) {
            this.itemStack.method_7959("text", (class_2520)nbtList);
        }
        if (signNote) {
            this.itemStack.method_7959("author", (class_2520)class_2519.method_23256((String)this.player.method_7334().getName()));
            this.itemStack.method_7959("title", (class_2520)class_2519.method_23256((String)this.title.trim()));
        }
    }

    private String getClipboard() {
        return this.field_22787 != null ? class_3728.method_27556((class_310)this.field_22787) : "";
    }

    private void setClipboard(String clipboard) {
        if (this.field_22787 != null) {
            class_3728.method_27551((class_310)this.field_22787, (String)clipboard);
        }
    }

    public void method_25393() {
        super.method_25393();
        ++this.frameTick;
    }

    private void updateButtons() {
        this.doneButton.field_22764 = !this.signing;
        this.signButton.field_22764 = !this.signing;
        this.cancelButton.field_22764 = this.signing;
        this.finalizeButton.field_22764 = this.signing;
        this.finalizeButton.field_22763 = !this.title.trim().isEmpty();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.signing) {
            return this.keyPressedSignMode(keyCode);
        }
        boolean bl = this.keyPressedEditMode(keyCode);
        if (bl) {
            this.invalidateDisplayCache();
            return true;
        }
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (super.method_25400(chr, modifiers)) {
            return true;
        }
        if (this.signing) {
            boolean bl = this.noteTitleSelectionManager.method_16199(chr);
            if (bl) {
                this.updateButtons();
                this.dirty = true;
                return true;
            }
            return false;
        }
        if (class_155.method_643((char)chr)) {
            this.currentPageSelectionManager.method_16197(Character.toString(chr));
            this.invalidateDisplayCache();
            return true;
        }
        return false;
    }

    private boolean keyPressedEditMode(int keyCode) {
        if (class_437.method_25439((int)keyCode)) {
            this.currentPageSelectionManager.method_27563();
            return true;
        }
        if (class_437.method_25438((int)keyCode)) {
            this.currentPageSelectionManager.method_27559();
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            this.currentPageSelectionManager.method_27554();
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            this.currentPageSelectionManager.method_27547();
            return true;
        }
        class_3728.class_7279 selectionType = class_437.method_25441() ? class_3728.class_7279.field_38309 : class_3728.class_7279.field_38308;
        switch (keyCode) {
            case 257: 
            case 335: {
                this.currentPageSelectionManager.method_16197("\n");
                return true;
            }
            case 259: {
                this.currentPageSelectionManager.method_42574(-1, selectionType);
                return true;
            }
            case 261: {
                this.currentPageSelectionManager.method_42574(1, selectionType);
                return true;
            }
            case 262: {
                this.currentPageSelectionManager.method_42575(1, class_437.method_25442(), selectionType);
                return true;
            }
            case 263: {
                this.currentPageSelectionManager.method_42575(-1, class_437.method_25442(), selectionType);
                return true;
            }
            case 264: {
                this.keyDown();
                return true;
            }
            case 265: {
                this.keyUp();
                return true;
            }
            case 268: {
                this.moveToLineStart();
                return true;
            }
            case 269: {
                this.moveToLineEnd();
                return true;
            }
        }
        return false;
    }

    private void moveUpLine() {
        this.moveVertically(-1);
    }

    private void moveDownLine() {
        this.moveVertically(1);
    }

    private void moveVertically(int lines) {
        int i = this.currentPageSelectionManager.method_16201();
        int j = this.getDisplayCache().changeLine(i, lines);
        this.currentPageSelectionManager.method_27560(j, class_437.method_25442());
    }

    private void keyUp() {
        this.changeLine(-1);
    }

    private void keyDown() {
        this.changeLine(1);
    }

    private void changeLine(int i) {
        int j = this.currentPageSelectionManager.method_16201();
        int k = this.getDisplayCache().changeLine(j, i);
        this.currentPageSelectionManager.method_27560(k, class_437.method_25442());
    }

    private void moveToLineStart() {
        if (class_437.method_25441()) {
            this.currentPageSelectionManager.method_27553(class_437.method_25442());
        } else {
            int i = this.currentPageSelectionManager.method_16201();
            int j = this.getDisplayCache().findLineStart(i);
            this.currentPageSelectionManager.method_27560(j, class_437.method_25442());
        }
    }

    private void moveToLineEnd() {
        if (class_437.method_25441()) {
            this.currentPageSelectionManager.method_27558(class_437.method_25442());
        } else {
            DisplayCache pageContent = this.getDisplayCache();
            int i = this.currentPageSelectionManager.method_16201();
            int j = pageContent.findLineEnd(i);
            this.currentPageSelectionManager.method_27560(j, class_437.method_25442());
        }
    }

    private boolean keyPressedSignMode(int keyCode) {
        switch (keyCode) {
            case 257: 
            case 335: {
                if (!this.title.isEmpty()) {
                    this.finalizeNote(true);
                    if (this.field_22787 != null) {
                        this.field_22787.method_1507(null);
                    }
                }
                return true;
            }
            case 259: {
                this.noteTitleSelectionManager.method_27564(-1);
                this.updateButtons();
                this.dirty = true;
                return true;
            }
        }
        return false;
    }

    private String getCurrentDisplayCache() {
        return !this.text.isEmpty() ? this.text.get(0) : "";
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.method_25420(guiGraphics);
        this.method_25395(null);
        int x = (this.field_22789 - 192) / 2;
        guiGraphics.method_25302(NOTE_TEXTURE, x, 2, 0, 0, 192, 192);
        if (this.signing) {
            boolean bl = this.frameTick / 6 % 2 == 0;
            class_5481 orderedText = class_5481.method_30742((class_5481)class_5481.method_30747((String)this.title, (class_2583)class_2583.field_24360), (class_5481)(bl ? BLACK_CURSOR_TEXT : GRAY_CURSOR_TEXT));
            int k = this.field_22793.method_27525((class_5348)EDIT_TITLE_TEXT);
            guiGraphics.method_51439(this.field_22793, EDIT_TITLE_TEXT, x + 36 + (114 - k) / 2, 34, 0, false);
            int l = this.field_22793.method_30880(orderedText);
            guiGraphics.method_35720(this.field_22793, orderedText, x + 36 + (114 - l) / 2, 50, 0);
            int m = this.field_22793.method_27525((class_5348)this.signedByText);
            guiGraphics.method_27535(this.field_22793, this.signedByText, x + 36 + (114 - m) / 2, 60, 0);
            guiGraphics.method_51440(this.field_22793, (class_5348)FINALIZE_WARNING_TEXT, x + 36, 82, 114, 0);
        } else {
            DisplayCache displayCache = this.getDisplayCache();
            for (LineInfo line : displayCache.lines) {
                guiGraphics.method_51439(this.field_22793, line.asComponent, line.x, line.y, -16777216, false);
            }
            this.renderHighlight(guiGraphics, displayCache.selection);
            this.renderCursor(guiGraphics, displayCache.cursor, displayCache.cursorAtEnd);
        }
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
    }

    private void renderCursor(class_332 guiGraphics, Pos2i pos2i, boolean bl) {
        if (this.frameTick / 6 % 2 == 0) {
            pos2i = this.convertLocalToScreen(pos2i);
            if (!bl) {
                int var10001 = pos2i.x;
                int var10002 = pos2i.y - 1;
                int var10003 = pos2i.x + 1;
                int var10004 = pos2i.y;
                Objects.requireNonNull(this.field_22793);
                guiGraphics.method_25294(var10001, var10002, var10003, var10004 + 9, -16777216);
            } else {
                guiGraphics.method_51433(this.field_22793, "_", pos2i.x, pos2i.y, 0, false);
            }
        }
    }

    private void renderHighlight(class_332 guiGraphics, class_768[] rect2is) {
        int var4 = rect2is.length;
        for (class_768 rect2i : rect2is) {
            int i = rect2i.method_3321();
            int j = rect2i.method_3322();
            int k = i + rect2i.method_3319();
            int l = j + rect2i.method_3320();
            guiGraphics.method_51739(class_1921.method_51786(), i, j, k, l, -16776961);
        }
    }

    private Pos2i convertScreenToLocal(Pos2i pos2i) {
        return new Pos2i(pos2i.x - (this.field_22789 - 192) / 2 - 36, pos2i.y - 32);
    }

    private Position absolutePositionToScreenPosition(Position position) {
        return new Position(position.x + (this.field_22789 - 192) / 2 + 36, position.y + 32);
    }

    private Pos2i convertLocalToScreen(Pos2i pos2i) {
        return new Pos2i(pos2i.x + (this.field_22789 - 192) / 2 + 36, pos2i.y + 32);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!super.method_25402(mouseX, mouseY, button) && button == 0) {
            long l = class_156.method_658();
            DisplayCache pageContent = this.getDisplayCache();
            int i = pageContent.getIndexAtPosition(this.field_22793, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
            if (i >= 0) {
                if (i == this.lastClickIndex && l - this.lastClickTime < 250L) {
                    if (!this.currentPageSelectionManager.method_27568()) {
                        this.selectCurrentWord(i);
                    } else {
                        this.currentPageSelectionManager.method_27563();
                    }
                } else {
                    this.currentPageSelectionManager.method_27560(i, class_437.method_25442());
                }
                this.invalidateDisplayCache();
            }
            this.lastClickIndex = i;
            this.lastClickTime = l;
        }
        return true;
    }

    private void selectCurrentWord(int cursor) {
        String string = this.getCurrentDisplayCache();
        this.currentPageSelectionManager.method_27548(class_5225.method_27483((String)string, (int)-1, (int)cursor, (boolean)false), class_5225.method_27483((String)string, (int)1, (int)cursor, (boolean)false));
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!super.method_25403(mouseX, mouseY, button, deltaX, deltaY) && button == 0) {
            DisplayCache pageContent = this.getDisplayCache();
            int i = pageContent.getIndexAtPosition(this.field_22793, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
            this.currentPageSelectionManager.method_27560(i, true);
            this.invalidateDisplayCache();
        }
        return true;
    }

    private DisplayCache getDisplayCache() {
        if (this.pageContent == null) {
            this.pageContent = this.createDisplayCache();
        }
        return this.pageContent;
    }

    private void setDisplayCache(String newContent) {
        if (!this.text.isEmpty()) {
            this.text.set(0, newContent);
            this.dirty = true;
            this.invalidateDisplayCache();
        }
    }

    private void invalidateDisplayCache() {
        this.pageContent = null;
    }

    private DisplayCache createDisplayCache() {
        int l;
        Pos2i position;
        boolean bl;
        String string = this.getCurrentDisplayCache();
        if (string.isEmpty()) {
            return DisplayCache.EMPTY;
        }
        int i = this.currentPageSelectionManager.method_16201();
        int j = this.currentPageSelectionManager.method_16203();
        ArrayList intList = new ArrayList();
        ArrayList list = new ArrayList();
        MutableInt mutableInt = new MutableInt();
        MutableBoolean mutableBoolean = new MutableBoolean();
        class_5225 textHandler = this.field_22793.method_27527();
        textHandler.method_27485(string, 114, class_2583.field_24360, true, (style, start, end) -> {
            int h = mutableInt.getAndIncrement();
            String substring = string.substring(start, end);
            mutableBoolean.setValue(substring.endsWith("\n"));
            String string2 = StringUtils.stripEnd((String)substring, (String)" \n");
            Objects.requireNonNull(this.field_22793);
            int b = h * 9;
            Position position = this.absolutePositionToScreenPosition(new Position(0, b));
            intList.add(start);
            list.add(new LineInfo(style, string2, position.x, position.y));
        });
        int[] is = intList.stream().mapToInt(Integer::intValue).toArray();
        boolean bl2 = bl = i == string.length();
        if (bl && mutableBoolean.isTrue()) {
            int var10003 = list.size();
            Objects.requireNonNull(this.field_22793);
            position = new Pos2i(0, var10003 * 9);
        } else {
            int k = NoteGui.getLineFromOffset(is, i);
            l = this.field_22793.method_1727(string.substring(is[k], i));
            Objects.requireNonNull(this.field_22793);
            position = new Pos2i(l, k * 9);
        }
        ArrayList<class_768> list2 = new ArrayList<class_768>();
        if (i != j) {
            int o;
            l = Math.min(i, j);
            int m = Math.max(i, j);
            int n = NoteGui.getLineFromOffset(is, l);
            if (n == (o = NoteGui.getLineFromOffset(is, m))) {
                Objects.requireNonNull(this.field_22793);
                int p = n * 9;
                int q = is[n];
                list2.add(this.getLineSelectionRectangle(string, textHandler, l, m, p, q));
            } else {
                int p = n + 1 > is.length ? string.length() : is[n + 1];
                Objects.requireNonNull(this.field_22793);
                list2.add(this.getLineSelectionRectangle(string, textHandler, l, p, n * 9, is[n]));
                for (int q = n + 1; q < o; ++q) {
                    Objects.requireNonNull(this.field_22793);
                    int r = q * 9;
                    String string2 = string.substring(is[q], is[q + 1]);
                    int s = (int)textHandler.method_27482(string2);
                    Position var10002 = new Position(0, r);
                    Objects.requireNonNull(this.field_22793);
                    list2.add(this.getRectFromCorners(var10002, new Position(s, r + 9)));
                }
                int var10004 = is[o];
                Objects.requireNonNull(this.field_22793);
                list2.add(this.getLineSelectionRectangle(string, textHandler, var10004, m, o * 9, is[o]));
            }
        }
        return new DisplayCache(string, position, bl, is, list.toArray(new LineInfo[0]), list2.toArray(new class_768[0]));
    }

    private class_768 getLineSelectionRectangle(String string, class_5225 handler, int selectionStart, int selectionEnd, int lineY, int lineStart) {
        String string2 = string.substring(lineStart, selectionStart);
        String string3 = string.substring(lineStart, selectionEnd);
        Position position = new Position((int)handler.method_27482(string2), lineY);
        int var10002 = (int)handler.method_27482(string3);
        Objects.requireNonNull(this.field_22793);
        Position position2 = new Position(var10002, lineY + 9);
        return this.getRectFromCorners(position, position2);
    }

    private class_768 getRectFromCorners(Position start, Position end) {
        Position position = this.absolutePositionToScreenPosition(start);
        Position position2 = this.absolutePositionToScreenPosition(end);
        int i = Math.min(position.x, position2.x);
        int j = Math.max(position.x, position2.x);
        int k = Math.min(position.y, position2.y);
        int l = Math.max(position.y, position2.y);
        return new class_768(i, k, j - i, l - k);
    }

    @Environment(value=EnvType.CLIENT)
    static class DisplayCache {
        static final DisplayCache EMPTY = new DisplayCache("", new Pos2i(0, 0), true, new int[]{0}, new LineInfo[]{new LineInfo(class_2583.field_24360, "", 0, 0)}, new class_768[0]);
        final Pos2i cursor;
        final boolean cursorAtEnd;
        final LineInfo[] lines;
        final class_768[] selection;
        private final String fullText;
        private final int[] lineStarts;

        public DisplayCache(String string, Pos2i pos2i, boolean bl, int[] is, LineInfo[] lineInfos, class_768[] rect2is) {
            this.fullText = string;
            this.cursor = pos2i;
            this.cursorAtEnd = bl;
            this.lineStarts = is;
            this.lines = lineInfos;
            this.selection = rect2is;
        }

        public int getIndexAtPosition(class_327 font, Pos2i pos2i) {
            int var10000 = pos2i.y;
            Objects.requireNonNull(font);
            int i = var10000 / 9;
            if (i < 0) {
                return 0;
            }
            if (i >= this.lines.length) {
                return this.fullText.length();
            }
            LineInfo lineInfo = this.lines[i];
            return this.lineStarts[i] + font.method_27527().method_27484(lineInfo.contents, pos2i.x, lineInfo.style);
        }

        public int changeLine(int i, int j) {
            int o;
            int k = NoteGui.findLineFromPos(this.lineStarts, i);
            int l = k + j;
            if (l >= 0 && l < this.lineStarts.length) {
                int m = i - this.lineStarts[k];
                int n = this.lines[l].contents.length();
                o = this.lineStarts[l] + Math.min(m, n);
            } else {
                o = i;
            }
            return o;
        }

        public int findLineStart(int i) {
            int j = NoteGui.findLineFromPos(this.lineStarts, i);
            return this.lineStarts[j];
        }

        public int findLineEnd(int i) {
            int j = NoteGui.findLineFromPos(this.lineStarts, i);
            return this.lineStarts[j] + this.lines[j].contents.length();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class LineInfo {
        final class_2583 style;
        final String contents;
        final class_2561 asComponent;
        final int x;
        final int y;

        public LineInfo(class_2583 style, String string, int i, int j) {
            this.style = style;
            this.contents = string;
            this.x = i;
            this.y = j;
            this.asComponent = class_2561.method_43470((String)string).method_10862(style);
        }
    }

    @Environment(value=EnvType.CLIENT)
    static class Pos2i {
        public final int x;
        public final int y;

        Pos2i(int i, int j) {
            this.x = i;
            this.y = j;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private record Position(int x, int y) {
    }
}

