/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.client.render;

import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_827;
import net.satisfy.farm_and_charm.block.entity.WaterSprinklerBlockEntity;
import net.satisfy.farm_and_charm.client.model.WaterSprinklerModel;
import org.joml.Quaternionf;

public class WaterSprinklerRenderer
implements class_827<WaterSprinklerBlockEntity> {
    private static final class_2960 TEXTURE = new class_2960("farm_and_charm", "textures/entity/water_sprinkler.png");
    private final class_630 rotating;
    private final class_630 basin;
    private long lastRenderTime = 0L;
    private float rotationAngle = 0.0f;

    public WaterSprinklerRenderer(class_5614.class_5615 context) {
        class_630 root = context.method_32140(WaterSprinklerModel.LAYER_LOCATION);
        this.rotating = root.method_32086("rotating");
        this.basin = root.method_32086("basin");
    }

    private float updateRotationAngle(WaterSprinklerBlockEntity blockEntity) {
        class_1937 level = blockEntity.method_10997();
        assert (level != null);
        boolean isRaining = level.method_8419();
        boolean isThundering = level.method_8546();
        float rotationSpeed = isRaining || isThundering ? 2.0f : 1.0f;
        long currentTime = System.currentTimeMillis();
        if (this.lastRenderTime == 0L) {
            this.lastRenderTime = currentTime;
        }
        float deltaTime = (float)(currentTime - this.lastRenderTime) / 1000.0f;
        this.lastRenderTime = currentTime;
        this.rotationAngle += rotationSpeed * deltaTime * 40.0f;
        this.rotationAngle %= 360.0f;
        blockEntity.setRotationAngle(this.rotationAngle);
        return this.rotationAngle;
    }

    public void render(WaterSprinklerBlockEntity blockEntity, float partialTicks, class_4587 matrixStack, class_4597 bufferSource, int combinedLight, int combinedOverlay) {
        class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_23572((class_2960)TEXTURE));
        matrixStack.method_22903();
        float angle = this.updateRotationAngle(blockEntity);
        matrixStack.method_22904(0.5, 0.0, 0.5);
        matrixStack.method_22907(new Quaternionf().rotationY((float)Math.toRadians(-angle)));
        matrixStack.method_22904(-0.5, 0.0, -0.5);
        this.rotating.method_22698(matrixStack, vertexConsumer, combinedLight, class_4608.field_21444);
        matrixStack.method_22909();
        this.basin.method_22698(matrixStack, vertexConsumer, combinedLight, class_4608.field_21444);
    }
}

