/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.entity;

import de.cristelknight.doapi.common.registry.DoApiSoundEventRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5712;
import net.satisfy.farm_and_charm.entity.DrivableEntity;
import net.satisfy.farm_and_charm.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public abstract class CartEntity
extends DrivableEntity {
    private static final class_2940<Float> DATA_ID_DAMAGE = class_2945.method_12791(CartEntity.class, (class_2941)class_2943.field_13320);
    private float originalYRot = 0.0f;
    private boolean shouldResetRot = false;
    private float wheelRot;
    private int rollOut;
    private int soundCooldown = 0;
    private double lastDriverX;
    private double lastDriverY;
    private double lastDriverZ;

    protected CartEntity(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
        this.method_49477(1.0f);
    }

    protected float wheelYOffset() {
        return this.wheelRadius() / 2.0f;
    }

    protected abstract float firstPoint();

    protected abstract float lastPoint();

    protected abstract float wheelRadius();

    protected float holdOffset() {
        return 2.0f;
    }

    @NotNull
    public class_1269 method_5688(class_1657 player, class_1268 interactionHand) {
        if (this.hasDriver()) {
            this.removeDriver();
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14718, class_3419.field_15248, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        boolean added = this.addDriver((class_1297)player);
        if (added) {
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14607, class_3419.field_15248, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void method_5773() {
        super.method_5773();
        if (this.soundCooldown > 0) {
            --this.soundCooldown;
        }
        class_243 currentPos = this.method_19538();
        double distanceMoved = Math.sqrt(Math.pow(currentPos.field_1352 - this.lastDriverX, 1.5) + Math.pow(currentPos.field_1351 - this.lastDriverY, 1.5) + Math.pow(currentPos.field_1350 - this.lastDriverZ, 1.5));
        double MIN_MOVEMENT_THRESHOLD = 0.05;
        if (distanceMoved > 0.05) {
            this.spawnWheelParticles();
            this.playMovementSound();
        }
        this.lastDriverX = currentPos.field_1352;
        this.lastDriverY = currentPos.field_1351;
        this.lastDriverZ = currentPos.field_1350;
        this.setupMovement();
        this.setupWheels();
        this.setupRotation();
        if (this.shouldResetRot) {
            this.method_36456(this.originalYRot);
            this.shouldResetRot = false;
        }
    }

    private void setupMovement() {
        if (this.hasDriver()) {
            class_243 lastMoveVec = this.method_19538().method_1023(this.lastDriverX, this.lastDriverY, this.lastDriverZ).method_1021(0.5);
            assert (this.getDriver() != null);
            class_243 driverMoveVec = this.getDriver().method_19538().method_1023(this.lastDriverX, this.lastDriverY, this.lastDriverZ).method_22882().method_1021(0.5);
            class_243 newPosVec = driverMoveVec.method_1019(lastMoveVec).method_1029().method_1021((double)this.holdOffset());
            class_243 desiredPos = this.getDriver().method_19538().method_1019(newPosVec);
            class_243 movVec = desiredPos.method_1020(this.method_19538());
            if (this.method_18798().method_1033() + movVec.method_1021(0.2).method_1033() < movVec.method_1033()) {
                this.method_18799(this.method_18798().method_1019(movVec).method_1021(0.2));
            }
        }
        if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1031(0.0, -0.08, 0.0));
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
    }

    private void setupRotation() {
        if (this.hasDriver()) {
            assert (this.getDriver() != null);
            class_243 lookAtVec = this.getDriver().method_19538().method_1020(this.method_19538()).method_1029();
            double yRot = Math.atan2(-lookAtVec.field_1352, lookAtVec.field_1350);
            double xRot = Math.atan2(-lookAtVec.field_1351, Math.sqrt(lookAtVec.field_1352 * lookAtVec.field_1352 + lookAtVec.field_1350 * lookAtVec.field_1350));
            this.method_36456((float)Math.toDegrees(yRot));
            this.method_36457((float)Math.toDegrees(xRot));
        }
    }

    private void setupWheels() {
        class_243 velocity = this.method_18798();
        float xzDist = (float)Math.sqrt(velocity.field_1352 * velocity.field_1352 + velocity.field_1350 * velocity.field_1350);
        if (0.01f < xzDist && 10 >= this.rollOut) {
            float anglePerTick = xzDist / this.wheelRadius() / (float)this.rollOut;
            this.wheelRot -= anglePerTick;
            this.wheelRot %= (float)Math.PI * 2;
        }
        if (!this.method_24828()) {
            if (10 > this.rollOut) {
                ++this.rollOut;
            }
        } else {
            this.rollOut = 1;
        }
    }

    public float wheelRot() {
        return this.wheelRot;
    }

    private void playMovementSound() {
        if (this.soundCooldown <= 0) {
            class_3414 sound = (class_3414)DoApiSoundEventRegistry.CART_MOVING.get();
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), sound, class_3419.field_15254, 0.1f, 1.0f);
            this.soundCooldown = 55;
        }
    }

    private void spawnWheelParticles() {
        class_2338 blockPosUnder;
        class_3218 serverLevel;
        class_2680 blockState;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218 && !(blockState = (serverLevel = (class_3218)class_19372).method_8320(blockPosUnder = new class_2338((int)this.method_23317(), (int)(this.method_23318() - 0.5), (int)this.method_23321()))).method_26215()) {
            for (int i = 0; i < 4; ++i) {
                double wheelParticleX = this.method_23317() + (this.field_5974.method_43058() - 0.5) * (double)this.method_17681() * 0.5;
                double wheelParticleY = this.method_23318() + 0.1;
                double wheelParticleZ = this.method_23321() + (this.field_5974.method_43058() - 0.5) * (double)this.method_17681() * 0.5;
                serverLevel.method_14199((class_2394)new class_2388(class_2398.field_11217, blockState), wheelParticleX, wheelParticleY, wheelParticleZ, 1, 0.0, 0.05, 0.0, 0.1);
            }
        }
    }

    public float balance() {
        double maxFrontX = Math.sqrt(this.firstPoint() * this.firstPoint() - this.wheelYOffset() * this.wheelYOffset());
        double maxFrontSlope = Math.atan2(-this.wheelYOffset(), maxFrontX);
        if (!this.hasDriver()) {
            return (float)maxFrontSlope;
        }
        double maxBackX = Math.sqrt(this.lastPoint() * this.lastPoint() - this.wheelYOffset() * this.wheelYOffset());
        double maxBackSlope = Math.atan2(this.wheelYOffset(), maxBackX);
        double desiredXRot = Math.toRadians(-this.method_36455());
        return this.method_24828() ? (float)Math.max(Math.min(desiredXRot, maxBackSlope), maxFrontSlope) : (float)desiredXRot;
    }

    public boolean method_5643(class_1282 damageSource, float damageAmount) {
        if (this.method_5679(damageSource)) {
            return false;
        }
        if (!this.method_37908().field_9236 && !this.method_31481()) {
            this.setDamage(this.getDamage() + damageAmount);
            this.method_5785();
            this.method_32875(class_5712.field_28736, damageSource.method_5529());
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                class_2680 blockState = serverLevel.method_8320(this.method_24515().method_10074());
                serverLevel.method_14199((class_2394)new class_2388(class_2398.field_11217, blockState), this.method_23317(), this.method_23318() + 0.1, this.method_23321(), 10, 0.1, 0.1, 0.1, 0.0);
                this.originalYRot = this.method_36454();
                this.method_36456(this.originalYRot + this.field_5974.method_43057() * 10.0f - 5.0f);
                this.shouldResetRot = true;
            }
            if (this.getDamage() > 5.0f) {
                if (this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
                    this.destroy(damageSource);
                }
                this.method_31472();
            }
            return true;
        }
        return true;
    }

    protected void destroy(class_1282 damageSource) {
        this.method_5706((class_1935)ObjectRegistry.SUPPLY_CART.get());
    }

    public float getDamage() {
        return ((Float)this.field_6011.method_12789(DATA_ID_DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.field_6011.method_12778(DATA_ID_DAMAGE, (Object)Float.valueOf(Math.min(damage, 40.0f)));
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    protected void method_5693() {
        this.field_6011.method_12784(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
    }
}

