/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.satisfy.farm_and_charm.FarmAndCharm;
import net.satisfy.farm_and_charm.effect.ChickenEffect;
import net.satisfy.farm_and_charm.effect.DogFoodEffect;
import net.satisfy.farm_and_charm.effect.FarmersBlessingEffect;
import net.satisfy.farm_and_charm.effect.FeastEffect;
import net.satisfy.farm_and_charm.effect.GrandmasBlessingEffect;
import net.satisfy.farm_and_charm.effect.HorseFodderEffect;
import net.satisfy.farm_and_charm.effect.RestedEffect;
import net.satisfy.farm_and_charm.effect.SatiationEffect;
import net.satisfy.farm_and_charm.effect.SustenanceEffect;
import net.satisfy.farm_and_charm.effect.SweetsEffect;
import net.satisfy.farm_and_charm.util.FarmAndCharmIdentifier;

public class MobEffectRegistry {
    private static final DeferredRegister<class_1291> MOB_EFFECTS = DeferredRegister.create((String)"farm_and_charm", (class_5321)class_7924.field_41208);
    private static final Registrar<class_1291> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<class_1291> SWEETS = MobEffectRegistry.registerEffect("sweets", SweetsEffect::new);
    public static final RegistrySupplier<class_1291> HORSE_FODDER = MobEffectRegistry.registerEffect("horse_fodder", HorseFodderEffect::new);
    public static final RegistrySupplier<class_1291> DOG_FOOD = MobEffectRegistry.registerEffect("dog_food", DogFoodEffect::new);
    public static final RegistrySupplier<class_1291> CLUCK = MobEffectRegistry.registerEffect("cluck", ChickenEffect::new);
    public static final RegistrySupplier<class_1291> GRANDMAS_BLESSING = MobEffectRegistry.registerEffect("grandmas_blessing", GrandmasBlessingEffect::new);
    public static final RegistrySupplier<class_1291> RESTED = MobEffectRegistry.registerEffect("rested", RestedEffect::new);
    public static final RegistrySupplier<class_1291> FARMERS_BLESSING = MobEffectRegistry.registerEffect("farmers_blessing", FarmersBlessingEffect::new);
    public static final RegistrySupplier<class_1291> SUSTENANCE = MobEffectRegistry.registerEffect("sustenance", SustenanceEffect::new);
    public static final RegistrySupplier<class_1291> SATIATION = MobEffectRegistry.registerEffect("satiation", SatiationEffect::new);
    public static final RegistrySupplier<class_1291> FEAST = MobEffectRegistry.registerEffect("feast", FeastEffect::new);

    private static RegistrySupplier<class_1291> registerEffect(String name, Supplier<class_1291> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((class_2960)new FarmAndCharmIdentifier(name), effect);
    }

    public static void init() {
        FarmAndCharm.LOGGER.debug("Registering MobEffects for farm_and_charm");
        MOB_EFFECTS.register();
    }
}

