/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.block.LineConnectingBlock;
import com.berksire.furniture.util.FurnitureUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public class BenchBlock
extends LineConnectingBlock {
    public static final Map<class_2350, class_265> SHAPE;
    public static final Map<class_2350, class_265> MIDDLE_SHAPE;
    public static final Map<class_2350, class_265> LEFT_SHAPE;
    public static final Map<class_2350, class_265> RIGHT_SHAPE;
    public static final Map<class_2350, class_265> NONE_REST_SHAPE;
    public static final Map<class_2350, class_265> LEFT_REST_SHAPE;
    public static final Map<class_2350, class_265> RIGHT_REST_SHAPE;
    public static final class_2746 REST;
    private static final Supplier<class_265> noneShapeSupplier;
    private static final Supplier<class_265> noneRestShapeSupplier;
    private static final Supplier<class_265> middleShapeSupplier;
    private static final Supplier<class_265> leftShapeSupplier;
    private static final Supplier<class_265> leftRestShapeSupplier;
    private static final Supplier<class_265> rightShapeSupplier;
    private static final Supplier<class_265> rightRestShapeSupplier;

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        boolean rest = (Boolean)state.method_11654((class_2769)REST);
        return (switch ((FurnitureUtil.LineConnectingType)((Object)state.method_11654((class_2769)TYPE))) {
            case FurnitureUtil.LineConnectingType.MIDDLE -> MIDDLE_SHAPE;
            case FurnitureUtil.LineConnectingType.LEFT -> rest ? LEFT_REST_SHAPE : LEFT_SHAPE;
            case FurnitureUtil.LineConnectingType.RIGHT -> rest ? RIGHT_REST_SHAPE : RIGHT_SHAPE;
            default -> rest ? NONE_REST_SHAPE : SHAPE;
        }).get(state.method_11654((class_2769)FACING));
    }

    public BenchBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)REST, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{REST, FACING, TYPE});
    }

    @Override
    @NotNull
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (player.method_5715()) {
            return this.toggleRest(state, world, pos);
        }
        return FurnitureUtil.onUse(world, player, hand, hit, -0.1);
    }

    @NotNull
    public class_1269 toggleRest(class_2680 state, class_1937 world, class_2338 pos) {
        boolean newRestState = (Boolean)state.method_11654((class_2769)REST) == false;
        this.updateConnectedBlocks(state, world, pos, newRestState);
        return class_1269.method_29236((boolean)world.field_9236);
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        FurnitureUtil.LineConnectingType type = this.getType(state, world.method_8320(pos.method_10093(((class_2350)state.method_11654((class_2769)FACING)).method_10170())), world.method_8320(pos.method_10093(((class_2350)state.method_11654((class_2769)FACING)).method_10160())));
        if (state.method_11654((class_2769)TYPE) != type) {
            state = (class_2680)state.method_11657((class_2769)TYPE, (Comparable)((Object)type));
            world.method_8652(pos, state, 3);
        }
    }

    @Override
    public FurnitureUtil.LineConnectingType getType(class_2680 state, class_2680 clockwise, class_2680 counterClockwise) {
        boolean shape_counterClockwise_same;
        boolean shape_clockwise_same = clockwise.method_26204() == state.method_26204() && clockwise.method_11654((class_2769)FACING) == state.method_11654((class_2769)FACING) && clockwise.method_11654((class_2769)REST) == state.method_11654((class_2769)REST);
        boolean bl = shape_counterClockwise_same = counterClockwise.method_26204() == state.method_26204() && counterClockwise.method_11654((class_2769)FACING) == state.method_11654((class_2769)FACING) && counterClockwise.method_11654((class_2769)REST) == state.method_11654((class_2769)REST);
        if (shape_clockwise_same && !shape_counterClockwise_same) {
            return FurnitureUtil.LineConnectingType.RIGHT;
        }
        if (!shape_clockwise_same && shape_counterClockwise_same) {
            return FurnitureUtil.LineConnectingType.LEFT;
        }
        if (shape_clockwise_same) {
            return FurnitureUtil.LineConnectingType.MIDDLE;
        }
        return FurnitureUtil.LineConnectingType.NONE;
    }

    private void updateConnectedBlocks(class_2680 state, class_1937 world, class_2338 pos, boolean newRestState) {
        class_2350[] directions;
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)REST, (Comparable)Boolean.valueOf(newRestState)), 3);
        for (class_2350 direction : directions = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039}) {
            class_2338 neighborPos = pos.method_10093(direction);
            while (world.method_8320(neighborPos).method_26204() instanceof BenchBlock) {
                world.method_8652(neighborPos, (class_2680)world.method_8320(neighborPos).method_11657((class_2769)REST, (Comparable)Boolean.valueOf(newRestState)), 3);
                neighborPos = neighborPos.method_10093(direction);
            }
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        FurnitureUtil.onStateReplaced(world, pos);
    }

    public boolean method_9516(class_2680 state, class_1922 level, class_2338 pos, class_10 type) {
        return false;
    }

    static {
        REST = class_2746.method_11825((String)"rest");
        noneShapeSupplier = () -> {
            class_265 shape = class_259.method_1073();
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.0, (double)0.0625, (double)0.1875, (double)0.25, (double)0.1875), (class_247)class_247.field_1366);
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.8125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.25, (double)0.1875), (class_247)class_247.field_1366);
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.0, (double)0.8125, (double)0.1875, (double)0.25, (double)0.9375), (class_247)class_247.field_1366);
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.8125, (double)0.0, (double)0.8125, (double)0.9375, (double)0.25, (double)0.9375), (class_247)class_247.field_1366);
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.25, (double)0.0625, (double)0.9375, (double)0.375, (double)0.9375), (class_247)class_247.field_1366);
            return shape;
        };
        noneRestShapeSupplier = () -> {
            class_265 shape = class_259.method_1073();
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.0, (double)0.0625, (double)0.1875, (double)0.25, (double)0.1875), (class_247)class_247.field_1366);
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.8125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.25, (double)0.1875), (class_247)class_247.field_1366);
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.0, (double)0.8125, (double)0.1875, (double)0.25, (double)0.9375), (class_247)class_247.field_1366);
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.8125, (double)0.0, (double)0.8125, (double)0.9375, (double)0.25, (double)0.9375), (class_247)class_247.field_1366);
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.25, (double)0.0625, (double)0.9375, (double)0.375, (double)0.9375), (class_247)class_247.field_1366);
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.8125, (double)0.375, (double)0.8125, (double)0.9375, (double)1.0, (double)0.9375), (class_247)class_247.field_1366);
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.375, (double)0.8125, (double)0.1875, (double)1.0, (double)0.9375), (class_247)class_247.field_1366);
            return shape;
        };
        middleShapeSupplier = () -> {
            class_265 shape = class_259.method_1073();
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.25, (double)0.0625, (double)1.0, (double)0.375, (double)0.9375), (class_247)class_247.field_1366);
            return shape;
        };
        leftShapeSupplier = () -> {
            class_265 shape = class_259.method_1073();
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.0, (double)0.0625, (double)0.1875, (double)0.25, (double)0.1875), (class_247)class_247.field_1366);
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.0, (double)0.8125, (double)0.1875, (double)0.25, (double)0.9375), (class_247)class_247.field_1366);
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.25, (double)0.0625, (double)1.0, (double)0.375, (double)0.9375), (class_247)class_247.field_1366);
            return shape;
        };
        leftRestShapeSupplier = () -> {
            class_265 shape = class_259.method_1073();
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.0, (double)0.0625, (double)0.1875, (double)0.25, (double)0.1875), (class_247)class_247.field_1366);
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.0, (double)0.8125, (double)0.1875, (double)0.25, (double)0.9375), (class_247)class_247.field_1366);
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.375, (double)0.8125, (double)0.1875, (double)1.0, (double)0.9375), (class_247)class_247.field_1366);
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.25, (double)0.0625, (double)1.0, (double)0.375, (double)0.9375), (class_247)class_247.field_1366);
            return shape;
        };
        rightShapeSupplier = () -> {
            class_265 shape = class_259.method_1073();
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.8125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.25, (double)0.1875), (class_247)class_247.field_1366);
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.8125, (double)0.0, (double)0.8125, (double)0.9375, (double)0.25, (double)0.9375), (class_247)class_247.field_1366);
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.25, (double)0.0625, (double)0.9375, (double)0.375, (double)0.9375), (class_247)class_247.field_1366);
            return shape;
        };
        rightRestShapeSupplier = () -> {
            class_265 shape = class_259.method_1073();
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.8125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.25, (double)0.1875), (class_247)class_247.field_1366);
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.8125, (double)0.0, (double)0.8125, (double)0.9375, (double)0.25, (double)0.9375), (class_247)class_247.field_1366);
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.8125, (double)0.375, (double)0.8125, (double)0.9375, (double)1.0, (double)0.9375), (class_247)class_247.field_1366);
            shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.25, (double)0.0625, (double)0.9375, (double)0.375, (double)0.9375), (class_247)class_247.field_1366);
            return shape;
        };
        SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
            for (class_2350 direction : class_2350.class_2353.field_11062.method_29716().toList()) {
                map.put(direction, FurnitureUtil.rotateShape(class_2350.field_11043, direction, noneShapeSupplier.get()));
            }
        });
        MIDDLE_SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
            for (class_2350 direction : class_2350.class_2353.field_11062.method_29716().toList()) {
                map.put(direction, FurnitureUtil.rotateShape(class_2350.field_11043, direction, middleShapeSupplier.get()));
            }
        });
        LEFT_SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
            map.put(class_2350.field_11043, FurnitureUtil.rotateShape(class_2350.field_11043, class_2350.field_11043, rightShapeSupplier.get()));
            map.put(class_2350.field_11035, FurnitureUtil.rotateShape(class_2350.field_11043, class_2350.field_11035, rightShapeSupplier.get()));
            map.put(class_2350.field_11034, FurnitureUtil.rotateShape(class_2350.field_11043, class_2350.field_11034, rightShapeSupplier.get()));
            map.put(class_2350.field_11039, FurnitureUtil.rotateShape(class_2350.field_11043, class_2350.field_11039, rightShapeSupplier.get()));
        });
        RIGHT_SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
            map.put(class_2350.field_11043, FurnitureUtil.rotateShape(class_2350.field_11043, class_2350.field_11043, leftShapeSupplier.get()));
            map.put(class_2350.field_11035, FurnitureUtil.rotateShape(class_2350.field_11043, class_2350.field_11035, leftShapeSupplier.get()));
            map.put(class_2350.field_11034, FurnitureUtil.rotateShape(class_2350.field_11043, class_2350.field_11034, leftShapeSupplier.get()));
            map.put(class_2350.field_11039, FurnitureUtil.rotateShape(class_2350.field_11043, class_2350.field_11039, leftShapeSupplier.get()));
        });
        NONE_REST_SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
            for (class_2350 direction : class_2350.class_2353.field_11062.method_29716().toList()) {
                map.put(direction, FurnitureUtil.rotateShape(class_2350.field_11043, direction, noneRestShapeSupplier.get()));
            }
        });
        LEFT_REST_SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
            map.put(class_2350.field_11043, FurnitureUtil.rotateShape(class_2350.field_11043, class_2350.field_11043, rightRestShapeSupplier.get()));
            map.put(class_2350.field_11035, FurnitureUtil.rotateShape(class_2350.field_11043, class_2350.field_11035, rightRestShapeSupplier.get()));
            map.put(class_2350.field_11034, FurnitureUtil.rotateShape(class_2350.field_11043, class_2350.field_11034, rightRestShapeSupplier.get()));
            map.put(class_2350.field_11039, FurnitureUtil.rotateShape(class_2350.field_11043, class_2350.field_11039, rightRestShapeSupplier.get()));
        });
        RIGHT_REST_SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
            map.put(class_2350.field_11043, FurnitureUtil.rotateShape(class_2350.field_11043, class_2350.field_11043, leftRestShapeSupplier.get()));
            map.put(class_2350.field_11035, FurnitureUtil.rotateShape(class_2350.field_11043, class_2350.field_11035, leftRestShapeSupplier.get()));
            map.put(class_2350.field_11034, FurnitureUtil.rotateShape(class_2350.field_11043, class_2350.field_11034, leftRestShapeSupplier.get()));
            map.put(class_2350.field_11039, FurnitureUtil.rotateShape(class_2350.field_11043, class_2350.field_11039, leftRestShapeSupplier.get()));
        });
    }
}

