/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.block.FacingBlock;
import com.berksire.furniture.block.entity.ClockBlockEntity;
import com.berksire.furniture.registry.SoundRegistry;
import com.berksire.furniture.util.FurnitureUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClockBlock
extends FacingBlock
implements class_2343 {
    private final WoodType woodType;
    private static final Supplier<class_265> voxelShapeSupplier = () -> {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.21875, (double)0.21875, (double)0.875, (double)0.78125, (double)0.78125, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.46875, (double)0.46875, (double)0.84375, (double)0.53125, (double)0.53125, (double)0.90625), (class_247)class_247.field_1366);
        return shape;
    };
    public static final Map<class_2350, class_265> SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            map.put(direction, FurnitureUtil.rotateShape(class_2350.field_11043, direction, voxelShapeSupplier.get()));
        }
    });

    public ClockBlock(class_4970.class_2251 settings, WoodType woodType) {
        super(settings);
        this.woodType = woodType;
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE.get(state.method_11654((class_2769)field_11177));
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)field_11177);
        class_2338 blockPos = pos.method_10093(direction.method_10153());
        class_2680 blockState = world.method_8320(blockPos);
        return blockState.method_26206((class_1922)world, blockPos, direction);
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350[] placementDirections;
        class_2680 blockState = this.method_9564();
        class_1937 worldView = ctx.method_8045();
        class_2338 blockPos = ctx.method_8037();
        for (class_2350 direction : placementDirections = ctx.method_7718()) {
            if (!direction.method_10166().method_10179() || !(blockState = (class_2680)blockState.method_11657((class_2769)field_11177, (Comparable)direction.method_10153())).method_26184((class_4538)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ClockBlockEntity(pos, state);
    }

    @NotNull
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public WoodType getWoodType() {
        return this.woodType;
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        world.method_8396(null, pos, (class_3414)SoundRegistry.GRANDFATHERS_CLOCK_TICKING.get(), class_3419.field_15245, 0.15f, 1.0f);
    }

    public boolean method_9516(class_2680 state, class_1922 level, class_2338 pos, class_10 type) {
        return false;
    }

    @NotNull
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.field_9236) {
            long time = world.method_8532();
            int hours = (int)((time / 1000L + 6L) % 24L);
            int minutes = (int)(60L * (time % 1000L) / 1000L);
            player.method_7353((class_2561)class_2561.method_43469((String)"tooltip.furniture.clock", (Object[])new Object[]{String.format(Locale.ENGLISH, "%02d:%02d", hours, minutes)}), true);
        }
        return class_1269.field_5812;
    }

    public static enum WoodType {
        OAK,
        SPRUCE,
        BIRCH,
        JUNGLE,
        ACACIA,
        DARK_OAK,
        MANGROVE,
        CHERRY;

    }
}

