/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.util.FurnitureUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurtainBlock
extends class_2248
implements class_3737 {
    public static final class_2753 FACING;
    public static final class_2754<FurnitureUtil.VerticalConnectingType> TYPE;
    public static final class_2746 OPEN;
    public static final class_2746 POWERED;
    public static final class_2746 WATERLOGGED;
    public static final Map<class_2350, class_265> SHAPE_TOP_OR_SINGLE;
    public static final Map<class_2350, class_265> SHAPE_OTHER;

    public CurtainBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(TYPE, (Comparable)((Object)FurnitureUtil.VerticalConnectingType.NONE))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2338 clickedPos;
        class_2350 facing = context.method_8042().method_10153();
        class_2680 blockState = (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing);
        class_1937 world = context.method_8045();
        if (world.method_49803(clickedPos = context.method_8037())) {
            blockState = (class_2680)((class_2680)blockState.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true));
        }
        blockState = (class_2680)blockState.method_11657(TYPE, (Comparable)((Object)this.getType(blockState, world.method_8320(clickedPos.method_10084()), world.method_8320(clickedPos.method_10074()))));
        return (class_2680)blockState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(world.method_8316(clickedPos).method_15772() == class_3612.field_15910));
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        boolean powered = world.method_49803(pos);
        if (powered != (Boolean)state.method_11654((class_2769)POWERED)) {
            if ((Boolean)state.method_11654((class_2769)OPEN) != powered) {
                state = (class_2680)state.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(powered));
                world.method_8396(null, pos, CurtainBlock.Curtainsound(powered), class_3419.field_15245, 1.0f, 1.0f);
            }
            if (((Boolean)(state = (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered))).method_11654((class_2769)WATERLOGGED)).booleanValue()) {
                world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
            }
        }
        FurnitureUtil.VerticalConnectingType type = this.getType(state, world.method_8320(pos.method_10084()), world.method_8320(pos.method_10074()));
        if (state.method_11654(TYPE) != type) {
            state = (class_2680)state.method_11657(TYPE, (Comparable)((Object)type));
        }
        world.method_8652(pos, state, 3);
    }

    @NotNull
    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        return this.toggleCurtain(state, level, pos, player);
    }

    public class_1269 toggleCurtain(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        state = (class_2680)state.method_28493((class_2769)OPEN);
        level.method_8652(pos, state, 3);
        if (player == null || !player.method_18276()) {
            this.toggleCurtain(state, level, pos, (Boolean)state.method_11654((class_2769)OPEN));
        }
        level.method_8396(null, pos, CurtainBlock.Curtainsound((Boolean)state.method_11654((class_2769)OPEN)), class_3419.field_15245, 1.0f, 1.0f);
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    public void toggleCurtain(class_2680 state, class_1937 level, class_2338 pos, boolean open) {
        int i;
        class_2680 updateState = state;
        class_2338 updatePos = pos;
        if (state.method_11654(TYPE) == FurnitureUtil.VerticalConnectingType.MIDDLE || state.method_11654(TYPE) == FurnitureUtil.VerticalConnectingType.BOTTOM) {
            class_2680 above;
            int heightUp = level.method_8597().comp_652() - updatePos.method_10264();
            for (i = 0; i < heightUp && (above = level.method_8320(updatePos.method_10084())).method_27852(state.method_26204()) && above.method_11654((class_2769)FACING) == updateState.method_11654((class_2769)FACING) && (Boolean)above.method_11654((class_2769)OPEN) != open; ++i) {
                updateState = above;
                updatePos = updatePos.method_10084();
                level.method_8652(updatePos, (class_2680)updateState.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
        }
        if (state.method_11654(TYPE) == FurnitureUtil.VerticalConnectingType.MIDDLE || state.method_11654(TYPE) == FurnitureUtil.VerticalConnectingType.TOP) {
            class_2680 below;
            updateState = state;
            updatePos = pos;
            int heightDown = level.method_8597().comp_651() - updatePos.method_10264();
            heightDown = heightDown < 0 ? -heightDown : heightDown;
            for (i = 0; i < heightDown && (below = level.method_8320(updatePos.method_10074())).method_27852(state.method_26204()) && below.method_11654((class_2769)FACING) == updateState.method_11654((class_2769)FACING) && (Boolean)below.method_11654((class_2769)OPEN) != open; ++i) {
                updateState = below;
                updatePos = updatePos.method_10074();
                level.method_8652(updatePos, (class_2680)updateState.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
        }
    }

    public static class_3414 Curtainsound(boolean open) {
        if (open) {
            return class_3417.field_15048;
        }
        return class_3417.field_15226;
    }

    public FurnitureUtil.VerticalConnectingType getType(class_2680 state, class_2680 above, class_2680 below) {
        boolean shape_below_same;
        boolean shape_above_same = above.method_26204() == state.method_26204() && above.method_11654((class_2769)FACING) == state.method_11654((class_2769)FACING) && above.method_11654((class_2769)OPEN) == state.method_11654((class_2769)OPEN);
        boolean bl = shape_below_same = below.method_26204() == state.method_26204() && below.method_11654((class_2769)FACING) == state.method_11654((class_2769)FACING) && below.method_11654((class_2769)OPEN) == state.method_11654((class_2769)OPEN);
        if (shape_above_same && !shape_below_same) {
            return FurnitureUtil.VerticalConnectingType.BOTTOM;
        }
        if (!shape_above_same && shape_below_same) {
            return FurnitureUtil.VerticalConnectingType.TOP;
        }
        if (shape_above_same) {
            return FurnitureUtil.VerticalConnectingType.MIDDLE;
        }
        return FurnitureUtil.VerticalConnectingType.NONE;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, TYPE, OPEN, POWERED, WATERLOGGED});
    }

    @NotNull
    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @NotNull
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    @NotNull
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    private static class_265 makeTopOrSingleShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.8125, (double)0.9375, (double)1.0, (double)0.9375, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.875, (double)1.0, (double)1.0, (double)0.9375), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeOtherShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.875, (double)1.0, (double)1.0, (double)0.9375), (class_247)class_247.field_1366);
        return shape;
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        FurnitureUtil.VerticalConnectingType type = (FurnitureUtil.VerticalConnectingType)((Object)state.method_11654(TYPE));
        if (type == FurnitureUtil.VerticalConnectingType.TOP || type == FurnitureUtil.VerticalConnectingType.NONE) {
            return SHAPE_TOP_OR_SINGLE.get(direction);
        }
        return SHAPE_OTHER.get(direction);
    }

    static {
        SHAPE_TOP_OR_SINGLE = (Map)class_156.method_654(new HashMap(), map -> {
            Supplier<class_265> voxelShapeSupplier = CurtainBlock::makeTopOrSingleShape;
            for (class_2350 direction : class_2350.class_2353.field_11062.method_29716().toList()) {
                map.put(direction, FurnitureUtil.rotateShape(class_2350.field_11043, direction, voxelShapeSupplier.get()));
            }
        });
        SHAPE_OTHER = (Map)class_156.method_654(new HashMap(), map -> {
            Supplier<class_265> voxelShapeSupplier = CurtainBlock::makeOtherShape;
            for (class_2350 direction : class_2350.class_2353.field_11062.method_29716().toList()) {
                map.put(direction, FurnitureUtil.rotateShape(class_2350.field_11043, direction, voxelShapeSupplier.get()));
            }
        });
        FACING = class_2741.field_12481;
        TYPE = FurnitureUtil.VerticalConnectingType.VERTICAL_CONNECTING_TYPE;
        OPEN = class_2741.field_12537;
        POWERED = class_2741.field_12484;
        WATERLOGGED = class_2741.field_12508;
    }
}

