/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.util.FurnitureUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public class LampBlock
extends class_2248
implements class_3737 {
    public static final class_2754<FurnitureUtil.VerticalConnectingType> TYPE = FurnitureUtil.VerticalConnectingType.VERTICAL_CONNECTING_TYPE;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 LIT = class_2746.method_11825((String)"lit");
    private static final Map<FurnitureUtil.VerticalConnectingType, Supplier<class_265>> SHAPES_SUPPLIERS = new HashMap<FurnitureUtil.VerticalConnectingType, Supplier<class_265>>();
    private static final Map<FurnitureUtil.VerticalConnectingType, class_265> SHAPES = new HashMap<FurnitureUtil.VerticalConnectingType, class_265>();

    public LampBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(TYPE, (Comparable)((Object)FurnitureUtil.VerticalConnectingType.NONE))).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{TYPE, WATERLOGGED, LIT});
    }

    public class_2680 method_9605(class_1750 context) {
        class_2338 clickedPos = context.method_8037();
        class_1937 world = context.method_8045();
        class_2338 belowPos = clickedPos.method_10074();
        class_2338 abovePos = clickedPos.method_10084();
        class_2680 belowState = world.method_8320(belowPos);
        class_2680 aboveState = world.method_8320(abovePos);
        class_2680 blockState = this.method_9564();
        blockState = (class_2680)blockState.method_11657(TYPE, (Comparable)((Object)this.getType(aboveState, belowState)));
        blockState = (class_2680)blockState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(world.method_8316(clickedPos).method_15772() == class_3612.field_15910));
        return blockState;
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        FurnitureUtil.VerticalConnectingType type = this.getType(world.method_8320(pos.method_10084()), world.method_8320(pos.method_10074()));
        if (state.method_11654(TYPE) != type) {
            world.method_8652(pos, (class_2680)state.method_11657(TYPE, (Comparable)((Object)type)), 3);
        }
    }

    public FurnitureUtil.VerticalConnectingType getType(class_2680 above, class_2680 below) {
        boolean shapeAboveSame = above.method_26204() instanceof LampBlock;
        boolean shapeBelowSame = below.method_26204() instanceof LampBlock;
        if (shapeAboveSame && shapeBelowSame) {
            return FurnitureUtil.VerticalConnectingType.MIDDLE;
        }
        if (shapeAboveSame) {
            return FurnitureUtil.VerticalConnectingType.BOTTOM;
        }
        if (shapeBelowSame) {
            return FurnitureUtil.VerticalConnectingType.TOP;
        }
        return FurnitureUtil.VerticalConnectingType.NONE;
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPES.get(state.method_11654(TYPE));
    }

    private static class_265 makeTopShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.4375, (double)0.0, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.5, (double)0.125, (double)0.875, (double)1.0, (double)0.875), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeBottomShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.75, (double)0.6875), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.4375, (double)0.75, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeSingleShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.375, (double)0.6875), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.4375, (double)0.375, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.5, (double)0.125, (double)0.875, (double)1.0, (double)0.875), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeMiddleShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.4375, (double)0.0, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625), (class_247)class_247.field_1366);
        return shape;
    }

    @NotNull
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (player.method_5715() && (state.method_11654(TYPE) == FurnitureUtil.VerticalConnectingType.NONE || state.method_11654(TYPE) == FurnitureUtil.VerticalConnectingType.TOP)) {
            boolean lit = (Boolean)state.method_11654((class_2769)LIT) == false;
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(lit)), 3);
            world.method_8396(null, pos, class_3417.field_14961, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    static {
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.NONE, LampBlock::makeSingleShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.MIDDLE, LampBlock::makeMiddleShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.TOP, LampBlock::makeTopShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.BOTTOM, LampBlock::makeBottomShape);
        for (Map.Entry<FurnitureUtil.VerticalConnectingType, Supplier<class_265>> entry : SHAPES_SUPPLIERS.entrySet()) {
            SHAPES.put(entry.getKey(), entry.getValue().get());
        }
    }
}

