/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.util.FurnitureUtil;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public class MirrorBlock
extends class_2248
implements class_3737 {
    public static final class_2754<FurnitureUtil.VerticalConnectingType> TYPE = FurnitureUtil.VerticalConnectingType.VERTICAL_CONNECTING_TYPE;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2741.field_12481;
    private static final Map<FurnitureUtil.VerticalConnectingType, Supplier<class_265>> SHAPES_SUPPLIERS = new HashMap<FurnitureUtil.VerticalConnectingType, Supplier<class_265>>();
    private static final Map<class_2350, Map<FurnitureUtil.VerticalConnectingType, class_265>> SHAPES = new EnumMap<class_2350, Map<FurnitureUtil.VerticalConnectingType, class_265>>(class_2350.class);

    public MirrorBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(TYPE, (Comparable)((Object)FurnitureUtil.VerticalConnectingType.NONE))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, TYPE, WATERLOGGED});
    }

    public class_2680 method_9605(class_1750 context) {
        class_2350 facing = context.method_8042().method_10153();
        class_2680 blockState = (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing);
        class_1937 world = context.method_8045();
        class_2338 clickedPos = context.method_8037();
        blockState = (class_2680)blockState.method_11657(TYPE, (Comparable)((Object)this.getType(blockState, world.method_8320(clickedPos.method_10084()), world.method_8320(clickedPos.method_10074()))));
        return (class_2680)blockState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(world.method_8316(clickedPos).method_15772() == class_3612.field_15910));
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        FurnitureUtil.VerticalConnectingType type = this.getType(state, world.method_8320(pos.method_10084()), world.method_8320(pos.method_10074()));
        if (state.method_11654(TYPE) != type) {
            state = (class_2680)state.method_11657(TYPE, (Comparable)((Object)type));
        }
        world.method_8652(pos, state, 3);
    }

    public FurnitureUtil.VerticalConnectingType getType(class_2680 state, class_2680 above, class_2680 below) {
        boolean shapeBelowSame;
        boolean shapeAboveSame = above.method_26204() == state.method_26204() && above.method_11654((class_2769)FACING) == state.method_11654((class_2769)FACING);
        boolean bl = shapeBelowSame = below.method_26204() == state.method_26204() && below.method_11654((class_2769)FACING) == state.method_11654((class_2769)FACING);
        if (shapeAboveSame && shapeBelowSame) {
            return FurnitureUtil.VerticalConnectingType.MIDDLE;
        }
        if (shapeAboveSame) {
            return FurnitureUtil.VerticalConnectingType.BOTTOM;
        }
        if (shapeBelowSame) {
            return FurnitureUtil.VerticalConnectingType.TOP;
        }
        return FurnitureUtil.VerticalConnectingType.NONE;
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        FurnitureUtil.VerticalConnectingType type = (FurnitureUtil.VerticalConnectingType)((Object)state.method_11654(TYPE));
        return SHAPES.get(direction).get((Object)type);
    }

    private static class_265 makeTopShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.8125, (double)0.875, (double)0.9375, (double)0.9375, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.0, (double)0.875, (double)0.1875, (double)0.8125, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.8125, (double)0.0, (double)0.875, (double)0.9375, (double)0.8125, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.1875, (double)0.0, (double)0.9375, (double)0.8125, (double)0.8125, (double)1.0), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeBottomShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.0625, (double)0.875, (double)0.9375, (double)0.1875, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.1875, (double)0.875, (double)0.1875, (double)1.0, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.8125, (double)0.1875, (double)0.875, (double)0.9375, (double)1.0, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.1875, (double)0.1875, (double)0.9375, (double)0.8125, (double)1.0, (double)1.0), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeSingleShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.0625, (double)0.875, (double)0.9375, (double)0.1875, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.8125, (double)0.875, (double)0.9375, (double)0.9375, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.1875, (double)0.875, (double)0.1875, (double)0.8125, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.8125, (double)0.1875, (double)0.875, (double)0.9375, (double)0.8125, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.1875, (double)0.1875, (double)0.9375, (double)0.8125, (double)0.8125, (double)1.0), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeMiddleShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.0, (double)0.875, (double)0.1875, (double)1.0, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.8125, (double)0.0, (double)0.875, (double)0.9375, (double)1.0, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.1875, (double)0.0, (double)0.9375, (double)0.8125, (double)1.0, (double)1.0), (class_247)class_247.field_1366);
        return shape;
    }

    static {
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.NONE, MirrorBlock::makeSingleShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.MIDDLE, MirrorBlock::makeMiddleShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.TOP, MirrorBlock::makeTopShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.BOTTOM, MirrorBlock::makeBottomShape);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            SHAPES.put(direction, new HashMap());
            for (Map.Entry<FurnitureUtil.VerticalConnectingType, Supplier<class_265>> entry : SHAPES_SUPPLIERS.entrySet()) {
                SHAPES.get(direction).put(entry.getKey(), FurnitureUtil.rotateShape(class_2350.field_11043, direction, entry.getValue().get()));
            }
        }
    }
}

